/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing;

import com.metamatrix.common.types.TransformationException;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.processing.helper.ObjectToDBMappingHelper;
import com.metamatrix.metamodels.db.model.util.TypeMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MetaclassInstance {
    private static final String BOOLEAN_CHAR_VALUE_TRUE = "1";
    private static final String BOOLEAN_CHAR_VALUE_FALSE = "0";
    public static final int[] ID_COL_TYPES = new int[]{12, 4, 4, 12};
    private static final int TXN_ID_COL_SQL_TYPE = 4;
    final Map referenceFeatureIdToPosition = new HashMap();
    final String metaclassURI;
    final String statement;
    List featureValueData;
    final ObjectToDBMappingHelper helper;
    final List idData;
    final long txnID;
    final long metaclassID;
    int[] sqlTypes;
    final MetabaseRepositoryShredderComponentRequest request;

    public MetaclassInstance(List idData, String metaclassURI, String statement, ObjectToDBMappingHelper helper, long metaclassID, MetabaseRepositoryShredderComponentRequest request) {
        this.metaclassURI = metaclassURI;
        this.statement = statement;
        this.helper = helper;
        this.idData = idData;
        this.txnID = request.getTransactionID();
        this.metaclassID = metaclassID;
        this.request = request;
        this.setupFeaturesList();
    }

    public void setFeatureValue(String featureURI, Object featureValue) {
        String stringValue;
        Object[] params;
        Object transformedValue;
        Integer enumValue;
        String featureValueTypeURI;
        int index = this.helper.getFeatureValueInsertPosition(featureURI);
        if (index < 0) {
            Object[] params2 = new Object[]{featureURI};
            String errorMessage = DBModelPlugin.Util.getString("XMIModelProcessorHandler.Unable_to_get_the_insert_position_for_the_feature_URI__{0}_10", params2);
            DBModelPlugin.Util.log(2, errorMessage);
            this.request.addWarningStatus(errorMessage, null);
            return;
        }
        int sqlType = this.sqlTypes[index];
        if (featureValue != null && (featureValueTypeURI = this.helper.getEnumTypeForFeatureURI(featureURI)) != null && (enumValue = this.helper.getIntValueForEnum(featureValueTypeURI, featureValue.toString())) != null) {
            featureValue = enumValue;
        }
        int maxValueLength = this.helper.getMaxDataValueSizeForFeature(featureURI);
        if (sqlType == 1 && maxValueLength == 1) {
            Boolean booleanValue = Boolean.valueOf(featureValue.toString());
            featureValue = booleanValue != false ? BOOLEAN_CHAR_VALUE_TRUE : BOOLEAN_CHAR_VALUE_FALSE;
        }
        try {
            transformedValue = TypeMapping.transform(featureValue, sqlType);
        }
        catch (TransformationException e) {
            transformedValue = featureValue;
            params = new Object[]{featureValue, new Long(sqlType), featureURI};
            String errorMessage = DBModelPlugin.Util.getString("XMIModelProcessorHandler.Unable_to_transform_the_value_{0}_into_the_Sql_type_{1}_for_the_insert_data_for_feature_of_type_{2}_1", params);
            this.request.addWarningStatus(errorMessage, e);
            DBModelPlugin.Util.log(2, errorMessage);
        }
        if ((sqlType == 12 || sqlType == 2005) && transformedValue != null && (stringValue = transformedValue.toString()).length() > maxValueLength) {
            transformedValue = StringUtil.truncString((String)stringValue, (int)maxValueLength);
            params = new Object[]{featureURI, stringValue, transformedValue};
            String warningMessage = DBModelPlugin.Util.getString("XMIModelProcessorHandler.String_value_for_feature_{0}_too_large_for_column.__Original_value__{1}_Truncated_Value__{2}_1", params);
            DBModelPlugin.Util.log(2, warningMessage);
            this.request.addWarningStatus(warningMessage, null);
        }
        this.featureValueData.set(index, transformedValue);
    }

    public int getReferenceTypeFeaturePosition(Long featureId) {
        Object value = this.referenceFeatureIdToPosition.get(featureId);
        if (value != null) {
            Integer position = (Integer)value;
            int newPosition = position + 1;
            position = new Integer(newPosition);
            this.referenceFeatureIdToPosition.put(featureId, position);
            return newPosition;
        }
        this.referenceFeatureIdToPosition.put(featureId, new Integer(0));
        return 0;
    }

    public List getInsertData() {
        ArrayList<Long> insertData = new ArrayList<Long>(this.idData.size() + this.featureValueData.size() + 1);
        insertData.addAll(this.idData);
        insertData.addAll(this.featureValueData);
        insertData.add(new Long(this.txnID));
        return insertData;
    }

    public String getMetaclassURI() {
        return this.metaclassURI;
    }

    public int[] getSQLTypesForValues() {
        int[] sqlTypesWIDTypes = new int[ID_COL_TYPES.length + this.sqlTypes.length + 1];
        int i = 0;
        while (i != ID_COL_TYPES.length) {
            sqlTypesWIDTypes[i] = ID_COL_TYPES[i];
            ++i;
        }
        i = 0;
        while (i != this.sqlTypes.length) {
            sqlTypesWIDTypes[i + MetaclassInstance.ID_COL_TYPES.length] = this.sqlTypes[i];
            ++i;
        }
        sqlTypesWIDTypes[MetaclassInstance.ID_COL_TYPES.length + this.sqlTypes.length] = 4;
        return sqlTypesWIDTypes;
    }

    public String getStatement() {
        return this.statement;
    }

    public List getIDData() {
        return this.idData;
    }

    public long getMetaclassID() {
        return this.metaclassID;
    }

    protected void setupFeaturesList() {
        List featureURIs = this.helper.getFeatureURIsForMetaclassURI(this.metaclassURI);
        int numberOfFeatures = featureURIs.size();
        this.featureValueData = new ArrayList(numberOfFeatures);
        List<Object> nullList = Collections.nCopies(numberOfFeatures, null);
        this.featureValueData.addAll(nullList);
        this.sqlTypes = new int[numberOfFeatures];
        Iterator iter = featureURIs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String featureURI = (String)iter.next();
            Object defaultValue = this.helper.getDefaultValueForFeatureURI(featureURI);
            this.sqlTypes[i++] = this.helper.getJDBCSQLTypeForFeature(featureURI);
            if (defaultValue == null) continue;
            int position = this.helper.getFeatureValueInsertPosition(featureURI);
            if (position >= 0) {
                this.setFeatureValue(featureURI, defaultValue);
                continue;
            }
            Object[] params = new Object[]{featureURI};
            String errorMessage = String.valueOf(DBModelPlugin.Util.getString("XMIModelProcessorHandler.Unable_to_get_a_feature_position_value_for_the_feature_URI__{0}._1", params)) + DBModelPlugin.Util.getString("XMIModelProcessorHandler._A_default_value_will_not_be_set_for_this_feature._2", params);
            DBModelPlugin.Util.log(2, errorMessage);
            this.request.addWarningStatus(errorMessage, null);
        }
    }
}

