/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.processing;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.processing.XMIModelProcessorHandler;
import com.metamatrix.metamodels.db.model.processing.helper.IDHelper;
import com.metamatrix.metamodels.db.model.processing.helper.ObjectToDBMappingHelper;
import com.metamatrix.metamodels.db.model.statement.StatementTarget;
import java.util.ArrayList;
import java.util.List;

public class MMUUIDXMIModelProcessorHandler
extends XMIModelProcessorHandler {
    public MMUUIDXMIModelProcessorHandler(IDGenerator idGenerator, IDHelper idHelper, ObjectToDBMappingHelper insertMappingHelper, MetabaseRepositoryShredderComponentRequest request, StatementTarget target) {
        super(idGenerator, idHelper, insertMappingHelper, request, target);
    }

    protected MMUUIDXMIModelProcessorHandler() {
    }

    public List getDBIDToInsertDataList(Object id, String lgclID) {
        ArgCheck.isTrue((id == null || id instanceof UUID ? 1 : 0) != 0, (String)DBModelPlugin.Util.getString("MMUUIDXMIModelProcessorHandler.ID_not_UUID"));
        ArrayList<Object> idData = new ArrayList<Object>(4);
        if (id == null && lgclID == null) {
            int i = 0;
            while (i < 4) {
                idData.add(null);
                ++i;
            }
            return idData;
        }
        idData.add(lgclID);
        UUID uuid = (UUID)id;
        String uuidString = id.toString();
        long uuid1 = UUID.getPart1((ObjectID)uuid);
        long uuid2 = UUID.getPart2((ObjectID)uuid);
        idData.add(new Long(uuid1));
        idData.add(new Long(uuid2));
        idData.add(uuidString);
        return idData;
    }

    public boolean representsADBID(String id) {
        return id != null && id.startsWith("mmuuid");
    }

    public Object getDBIDForString(String id) throws IllegalArgumentException {
        if (!this.representsADBID(id)) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("MMUUIDXMIModelProcessorHandler.UUID_String_in_invalid_format"));
        }
        if (id != null) {
            id = id.replace('/', ':');
        }
        id = id.substring(id.indexOf(":") + 1);
        ObjectID uuid = null;
        try {
            uuid = UUID.stringToObject((String)id);
        }
        catch (InvalidIDException e) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("MMUUIDXMIModelProcessorHandler.UUID_String_in_invalid_format"));
        }
        return uuid;
    }
}

