/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.pool;

import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.exception.ResourceException;
import com.metamatrix.metamodels.db.model.pool.ConnectionPool;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionPoolImpl
implements ConnectionPool {
    final Properties env;
    private static final String INTERNAL_USER_NAME = "MetadataInternalUser";

    public ConnectionPoolImpl(Properties env) {
        this.env = env;
    }

    public Connection getConnection(String userName) throws ResourceException {
        ArgCheck.isNotNull((Object)userName);
        try {
            return JDBCConnectionPoolHelper.getConnection((Properties)this.env, (String)userName);
        }
        catch (Exception e) {
            Object[] params = new String[]{};
            throw new ResourceException(e, DBModelPlugin.Util.getString("ConnectionPoolImpl.Unable_to_get_a_connection_from_the_Connection_Pool._1", params));
        }
    }

    public void returnConnection(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            Object[] params = new String[]{};
            DBModelPlugin.Util.log(2, (Throwable)e, DBModelPlugin.Util.getString("ConnectionPoolImpl.Unable_to_close_the_connection_to_the_Design_Time_Metadata_Repository._1", params));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean areConnectionsBatchCapable() {
        Object[] params;
        boolean supportsBatch;
        block11: {
            supportsBatch = false;
            Connection connection = null;
            try {
                try {
                    block13: {
                        block12: {
                            connection = this.getConnection(INTERNAL_USER_NAME);
                            JDBCPlatform platform = JDBCPlatformFactory.getPlatform((Connection)connection);
                            if (platform.isDerby()) break block12;
                            if (!platform.isSecure()) break block13;
                        }
                        Object var5_5 = null;
                        if (connection == null) return false;
                        this.returnConnection(connection);
                        return false;
                    }
                    DatabaseMetaData dmd = connection.getMetaData();
                    if (dmd != null) {
                        supportsBatch = dmd.supportsBatchUpdates();
                    }
                }
                catch (Throwable platform) {}
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (connection == null) throw throwable;
                this.returnConnection(connection);
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (connection != null) {
                    this.returnConnection(connection);
                }
                if (supportsBatch) break block11;
            }
            params = new String[]{};
            DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("ConnectionPoolImpl.The_JDBC_Connection_given_to_the_Indexing_service_does_not_support_statement_batching_1", params));
            return supportsBatch;
        }
        params = new String[]{};
        DBModelPlugin.Util.log(2, DBModelPlugin.Util.getString("ConnectionPoolImpl.The_JDBC_Connection_given_to_the_Indexing_service_was_found_to_support_statement_batching.__Batching_will_be_used_to_optimize_performance._1", params));
        return supportsBatch;
    }
}

