/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.component.request;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.metabase.repository.api.BufferedInputStreamWrapper;
import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.ShredderRequestKey;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.component.request.StatusListener;
import com.metamatrix.metamodels.db.model.processing.status.ProcessingEvent;
import com.metamatrix.metamodels.db.model.processing.status.StateChangeEvent;
import com.metamatrix.metamodels.db.platform.api.IndexingServiceModelActionRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Status;

public class MetabaseRepositoryShredderComponentRequestImpl
implements MetabaseRepositoryShredderComponentRequest {
    private List status;
    private int statementsAdded = 0;
    private int statementsExcecuted = 0;
    private long requestID;
    private Object clientRequestID;
    private long timeCreated;
    private long timeSubmitted;
    private long timeCompleted;
    private IndexingServiceModelActionRequest serviceRequest;
    private ShredderRequestKey shredderRequestKey;
    List transactionStatusListeners;
    transient String topic;
    transient ClientConnection clientConn;

    public MetabaseRepositoryShredderComponentRequestImpl(IndexingServiceModelActionRequest clientRequest) {
        if (clientRequest == null) {
            throw new IllegalArgumentException(DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponentRequestImpl.Unable_to_create_an_instance_of_MetabaseRepositoryShredderComponentRequestImpl._The_passed_in_instance_of_IndexingServiceModelActionRequest_was_null._1"));
        }
        this.setTimeCreated(System.currentTimeMillis());
        this.transactionStatusListeners = new ArrayList();
        this.status = new ArrayList();
        this.status.add(new ProcessingEvent(0, "Request created", null));
        this.serviceRequest = clientRequest;
    }

    public MetabaseRepositoryShredderComponentRequestImpl(IndexingServiceModelActionRequest clientRequest, ShredderRequestKey requestKey) {
        this(clientRequest);
        this.shredderRequestKey = requestKey;
    }

    protected MetabaseRepositoryShredderComponentRequestImpl() {
        this.transactionStatusListeners = new ArrayList();
    }

    public ClientConnection getClientConnection() {
        return this.clientConn;
    }

    public void setClientConnection(ClientConnection connection) {
        this.clientConn = connection;
    }

    public List getStatus() {
        return this.status;
    }

    public synchronized void setTransactionState(int requestState) {
        if (this.isValidRequestState(requestState)) {
            this.notifyMessageStatusListeners(new StateChangeEvent(requestState));
        }
    }

    public synchronized void submitted() {
        this.setTimeSubmitted(System.currentTimeMillis());
        this.setTransactionState(1);
    }

    protected synchronized void completed() {
        this.setTimeCompleted(System.currentTimeMillis());
        this.setTransactionState(4);
    }

    public synchronized void addStatusListener(StatusListener listener) {
        this.transactionStatusListeners.add(listener);
    }

    public synchronized void removeStatusListener(StatusListener listener) {
        this.transactionStatusListeners.remove(listener);
    }

    public int getCommandType() {
        return this.serviceRequest.getCommandType();
    }

    public IndexingServiceModelActionRequest getMetabaseRequest() {
        return this.serviceRequest;
    }

    public synchronized void statementAdded() {
        ++this.statementsAdded;
    }

    public synchronized void statementProcessed() {
        ++this.statementsExcecuted;
        if (this.statementsExcecuted == this.statementsAdded) {
            this.completed();
        }
    }

    public synchronized void addErrorStatus(String message, Throwable t) {
        ProcessingEvent event = new ProcessingEvent(4, message, t);
        this.status.add(event);
        this.notifyMessageStatusListeners(event);
    }

    public synchronized void addWarningStatus(String message, Throwable t) {
        ProcessingEvent event = null;
        event = t == null ? new ProcessingEvent(2, message) : new ProcessingEvent(2, message, t);
        this.status.add(event);
        this.notifyMessageStatusListeners(event);
    }

    public synchronized void addInfoStatus(String message, Throwable t) {
        ProcessingEvent event = new ProcessingEvent(1, message, t);
        this.status.add(event);
        this.notifyMessageStatusListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMessageStatusListeners(Status newStatus) {
        if (this.transactionStatusListeners != null && this.transactionStatusListeners.size() > 0) {
            List list = this.transactionStatusListeners;
            synchronized (list) {
                Iterator iter = this.transactionStatusListeners.iterator();
                while (iter.hasNext()) {
                    StatusListener listener = (StatusListener)iter.next();
                    if (listener == null) continue;
                    listener.requestProcessingEvent(newStatus, (Message)this);
                }
            }
        }
    }

    private boolean isValidRequestState(int state) {
        return state >= 0 && state <= 5;
    }

    public long getTransactionID() {
        return this.requestID;
    }

    public void setTransactionID(long requestID) {
        this.requestID = requestID;
    }

    public Object getClientRequestID() {
        return this.clientRequestID;
    }

    public void setClientRequestID(Object id) {
        this.clientRequestID = id;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getTimeSubmitted() {
        return this.timeSubmitted;
    }

    public long getTimeCompleted() {
        return this.timeCompleted;
    }

    public long getProcessingTime() {
        return this.timeCompleted - this.timeSubmitted;
    }

    public synchronized boolean isSubmitted() {
        return this.timeSubmitted > 0L;
    }

    public synchronized boolean isCompleted() {
        return this.timeCompleted > 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getTransactionID());
        if (this.isSubmitted()) {
            sb.append(", submittal time= ");
            sb.append(DateUtil.getDateAsString((long)this.getTimeSubmitted()));
        }
        if (this.isCompleted()) {
            sb.append(", completion time= ");
            sb.append(DateUtil.getDateAsString((long)this.getTimeCompleted()));
            sb.append(", processing time= ");
            sb.append(this.getProcessingTime());
            sb.append(" ms");
        }
        return sb.toString();
    }

    protected void setTimeCreated(long time) {
        this.timeCreated = time;
    }

    protected void setTimeSubmitted(long time) {
        this.timeSubmitted = time;
    }

    protected void setTimeCompleted(long time) {
        this.timeCompleted = time;
    }

    public String getCommandTypeString() {
        return this.serviceRequest.getCommandTypeString();
    }

    public Object getModelID() {
        return this.serviceRequest.getModelID();
    }

    public String getModelName() {
        return this.serviceRequest.getModelName();
    }

    public BufferedInputStreamWrapper getModelStream() {
        return this.serviceRequest.getModelStream();
    }

    public String getModelURI() {
        return this.serviceRequest.getModelURI();
    }

    public String getModelVersion() {
        return this.serviceRequest.getModelVersion();
    }

    public String getUserName() {
        return this.serviceRequest.getUserName();
    }

    public int getMessageType() {
        return this.serviceRequest.getCommandType();
    }

    public String getModelRepositoryPath() {
        return this.serviceRequest.getModelRepositoryPath();
    }

    public ShredderRequestKey getShredderRequestKey() {
        return this.shredderRequestKey;
    }
}

