/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.component;

import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.metamodels.db.platform.api.IndexingServiceModelActionRequest;
import java.io.Serializable;

public class ShredderRequestKey
implements Serializable {
    private boolean shredNow = false;
    private long uuid1;
    private long uuid2;
    private ObjectID objectID;
    private String uuid;
    private String path;
    private String modelName;
    private String version;
    private String vmkey = null;
    private long transID;
    private String userName;
    private int action;
    private long queueid = -1L;

    public static final ShredderRequestKey createKey(IndexingServiceModelActionRequest request, long queueID, long transactionID) {
        ShredderRequestKey k = new ShredderRequestKey();
        k.setObjectdID(request.getModelID());
        k.queueid = queueID;
        k.userName = request.getUserName();
        k.vmkey = VMNaming.getVMName();
        k.transID = transactionID;
        k.path = request.getModelRepositoryPath();
        k.modelName = request.getModelName();
        k.version = request.getModelVersion();
        k.action = request.getCommandType();
        return k;
    }

    public static final ShredderRequestKey createKey(long queueID, long uuid1, long uuid2, String modelName, String version, String path, long transactionID, String username, int action) {
        ShredderRequestKey k = new ShredderRequestKey();
        k.queueid = queueID;
        UUID id = new UUID(uuid1, uuid2);
        k.setObjectdID(id);
        k.userName = username;
        k.vmkey = VMNaming.getVMName();
        k.transID = transactionID;
        k.path = path;
        int idx = modelName.lastIndexOf(".");
        k.modelName = idx > 0 ? modelName.substring(0, idx) : modelName;
        k.version = version;
        k.action = action;
        return k;
    }

    void setObjectdID(Object objectID) {
        if (objectID instanceof UUID) {
            UUID uuid = (UUID)objectID;
            this.objectID = uuid;
            this.uuid = uuid.toString();
            this.uuid1 = UUID.getPart1((ObjectID)uuid);
            this.uuid2 = UUID.getPart2((ObjectID)uuid);
        } else {
            this.uuid = objectID.toString();
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getUUID1() {
        return this.uuid1;
    }

    public long getUUID2() {
        return this.uuid2;
    }

    public void setShredNow(boolean shredNow) {
        this.shredNow = shredNow;
    }

    public long getQueueID() {
        return this.queueid;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPath() {
        return this.path;
    }

    public int getAction() {
        return this.action;
    }

    public String getActionString() {
        return IndexingServiceModelActionRequest.MESSAGE_TYPE_NAMES[this.action];
    }

    public String getUUID() {
        return this.uuid;
    }

    public ObjectID getObjectID() {
        return this.objectID;
    }

    public boolean isToShredNow() {
        return this.shredNow;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getVMKey() {
        return this.vmkey;
    }

    public long getTransactionID() {
        return this.transID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ShredderRequestKey) {
            ShredderRequestKey that = (ShredderRequestKey)obj;
            if (this.getTransactionID() == that.getTransactionID()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.vmkey) + "." + this.objectID + "." + this.version + "." + this.transID;
    }
}

