/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.component;

import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.MetabaseRepositoryShredderConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyConfigSourceImpl
implements MetabaseRepositoryShredderConfigSource {
    final int statementWorkerPoolMaxSize = 1;
    int statementWorkerPoolKeepAlive = 50000;
    int modelWorkerPoolMaxSize = 10;
    int modelWorkerPoolKeepAlive = 50000;
    final int statementBatchingSize = 500;
    Properties serviceConfigProps;

    public PropertyConfigSourceImpl(Properties serviceConfigProps) {
        Object[] params = new String[]{};
        try {
            this.statementWorkerPoolKeepAlive = Integer.parseInt(serviceConfigProps.getProperty("StatementWorkerKeepAlive"));
        }
        catch (NumberFormatException e) {
            DBModelPlugin.Util.log(2, (Throwable)e, DBModelPlugin.Util.getString("PropertyConfigSourceImpl.Unable_to_parse_the_configuration_value_for_statement_worker_pool_keep_alive._Using_the_default_for_that_config_property._1", params));
        }
        try {
            this.modelWorkerPoolKeepAlive = Integer.parseInt(serviceConfigProps.getProperty("ModelWorkerKeepAlive"));
        }
        catch (NumberFormatException e2) {
            DBModelPlugin.Util.log(2, (Throwable)e2, DBModelPlugin.Util.getString("PropertyConfigSourceImpl.Unable_to_parse_the_configuration_value_for_model_worker_pool_max_sise._Using_the_default_for_that_config_property._3", params));
        }
        try {
            this.modelWorkerPoolMaxSize = Integer.parseInt(serviceConfigProps.getProperty("ModelWorkerPoolSize"));
        }
        catch (NumberFormatException e3) {
            DBModelPlugin.Util.log(2, (Throwable)e3, DBModelPlugin.Util.getString("PropertyConfigSourceImpl.Unable_to_parse_the_configuration_value_for_model_worker_pool_max_sise._Using_the_default_for_that_config_property._4", params));
        }
    }

    public int getStatementWorkerPoolMaxSize() {
        return 1;
    }

    public int getStatementWorkerPoolKeepAlive() {
        return this.statementWorkerPoolKeepAlive;
    }

    public int getModelWorkerPoolMaxSize() {
        return this.modelWorkerPoolMaxSize;
    }

    public int getModelWorkerPoolKeepAlive() {
        return this.modelWorkerPoolKeepAlive;
    }

    public Properties getInsertMappingProperties() {
        Properties props = new Properties();
        try {
            String resourcePath = "runtime/ShredderMetamodelInfo.properties";
            Enumeration<URL> enumeration = ClassLoader.getSystemResources(resourcePath);
            if (!enumeration.hasMoreElements()) {
                Object[] params = new String[]{};
                String msg = DBModelPlugin.Util.getString("PropertyConfigSourceImpl.No_resources_for_Metamodel_shredding_properties_found_in_the_classpath.__Shredder_will_not_function_without_properties_to_map_model_constructs_to_metamodel_entities._1", params);
                DBModelPlugin.Util.log(4, msg);
            }
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream stream = url.openStream();
                props.load(stream);
            }
        }
        catch (IOException e) {
            Object[] params = new String[]{};
            String msg = String.valueOf(DBModelPlugin.Util.getString("PropertyConfigSourceImpl.Unable_to_load_the_Properties_which_allows_the_model_shredding_facility_to_map_1", params)) + DBModelPlugin.Util.getString("PropertyConfigSourceImpl._model_entities_to_their_respective_tables_in_the_DTMS._2", params);
            DBModelPlugin.Util.log(4, (Throwable)e, msg);
        }
        return props;
    }

    public int getStatementBatchingSize() {
        return 500;
    }
}

