/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.core.jdbc;

import com.metamatrix.common.jdbc.metadata.Column;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class JDBCNames {
    private static final String COMMA = ", ";
    private static final String PATH_SEPARATOR = ".";

    private static final String createCommaDelimString(String tableName, Collection columns) {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            sb.append(tableName);
            sb.append(PATH_SEPARATOR);
            sb.append(column.getName());
            if (!iterator.hasNext()) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }

    public static class TransactionTable {
        public static final String TABLE_NAME = "DD_TXN_LOG";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static Collection ALL_COLUMNS_LIST;
        public static final int ID_INDEX = 0;
        public static final int USER_NME_INDEX = 1;
        public static final int BEGIN_TXN_INDEX = 2;
        public static final int END_TXN_INDEX = 3;
        public static final int ACTION_INDEX = 4;
        public static final int TXN_STATE_INDEX = 5;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("ID", 12));
            ALL_COLUMNS_LIST.add(new Column("USER_NME", 4));
            ALL_COLUMNS_LIST.add(new Column("BEGIN_TXN", 4));
            ALL_COLUMNS_LIST.add(new Column("END_TXN", 12));
            ALL_COLUMNS_LIST.add(new Column("ACTION", 12));
            ALL_COLUMNS_LIST.add(new Column("TXN_STATE", 4));
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, TransactionTable.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String ID = "ID";
            public static final String USER_NME = "USER_NME";
            public static final String BEGIN_TXN = "BEGIN_TXN";
            public static final String END_TXN = "END_TXN";
            public static final String ACTION = "ACTION";
            public static final String TXN_STATE = "TXN_STATE";
        }
    }

    public static class MetamodelsTable {
        public static final String TABLE_NAME = "DD_MTAMDL";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static Collection ALL_COLUMNS_LIST;
        public static final int ID_INDEX = 0;
        public static final int URI_INDEX = 1;
        public static final int DSPLY_NME_INDEX = 2;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("ID", 4));
            ALL_COLUMNS_LIST.add(new Column("URI", 12));
            ALL_COLUMNS_LIST.add(new Column("DSPLY_NME", 12));
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, MetamodelsTable.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String ID = "ID";
            public static final String URI = "URI";
            public static final String DSPLY_NME = "DSPLY_NME";
        }
    }

    public static class MetaclassTable {
        public static final String TABLE_NAME = "DD_MTACLS_TYPE";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static Collection ALL_COLUMNS_LIST;
        public static final int ID_INDEX = 0;
        public static final int MTACLS_URI_INDEX = 1;
        public static final int MTAMDL_ID_INDEX = 2;
        public static final int DSPLY_NME_INDEX = 3;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("ID", 4));
            ALL_COLUMNS_LIST.add(new Column("MTACLS_URI", 12));
            ALL_COLUMNS_LIST.add(new Column("MTAMDL_ID", 4));
            ALL_COLUMNS_LIST.add(new Column("DSPLY_NME", 12));
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, MetaclassTable.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String ID = "ID";
            public static final String MTACLS_URI = "MTACLS_URI";
            public static final String MTAMDL_ID = "MTAMDL_ID";
            public static final String DSPLY_NME = "DSPLY_NME";
        }
    }

    public static class FeaturesTable {
        public static final String TABLE_NAME = "DD_FTRE";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static Collection ALL_COLUMNS_LIST;
        public static final int ID_INDEX = 0;
        public static final int MTACLS_FTRE_URI_INDEX = 1;
        public static final int MTACLS_TYPE_ID_INDEX = 2;
        public static final int MTAMDL_ID_INDEX = 3;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("ID", 4));
            ALL_COLUMNS_LIST.add(new Column("MTACLS_FTRE_URI", 12));
            ALL_COLUMNS_LIST.add(new Column("MTACLS_TYPE_ID", 4));
            ALL_COLUMNS_LIST.add(new Column("MTACLS_FTRE_URI", 4));
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, FeaturesTable.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String ID = "ID";
            public static final String MTACLS_FTRE_URI = "MTACLS_FTRE_URI";
            public static final String MTACLS_TYPE_ID = "MTACLS_TYPE_ID";
            public static final String MTAMDL_ID = "MTAMDL_ID";
        }
    }

    public static class RelationshipsTable {
        public static final String TABLE_NAME = "DD_RELATIONSHIPS";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static Collection ALL_COLUMNS_LIST;
        public static int[] ALL_COLUMNS_SQLTYPE;
        public static final int REFERRER_LGCL_ID_INDEX = 0;
        public static final int REFERRER_UUID1_INDEX = 1;
        public static final int REFERRER_UUID2_INDEX = 2;
        public static final int REFERRER_UUID_STRING_INDEX = 3;
        public static final int REFEREE_LGCL_ID_INDEX = 4;
        public static final int REFEREE_UUID1_INDEX = 5;
        public static final int REFEREE_UUID2_INDEX = 6;
        public static final int REFEREE_UUID_STRING_INDEX = 7;
        public static final int REFEREE_POSITION_INDEX = 8;
        public static final int REL_FTRE_ID_INDEX = 9;
        public static final int TXN_ID_INDEX = 10;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("REFERRER_LGCL_ID", 12));
            ALL_COLUMNS_LIST.add(new Column("REFERRER_UUID1", 4));
            ALL_COLUMNS_LIST.add(new Column("REFERRER_UUID2", 4));
            ALL_COLUMNS_LIST.add(new Column("REFERRER_UUID_STRING", 12));
            ALL_COLUMNS_LIST.add(new Column("REFEREE_LGCL_ID", 12));
            ALL_COLUMNS_LIST.add(new Column("REFEREE_UUID1", 4));
            ALL_COLUMNS_LIST.add(new Column("REFEREE_UUID2", 4));
            ALL_COLUMNS_LIST.add(new Column("REFEREE_UUID_STRING", 4));
            ALL_COLUMNS_LIST.add(new Column("REFEREE_POSITION", 4));
            ALL_COLUMNS_LIST.add(new Column("REL_FTRE_ID", 4));
            ALL_COLUMNS_LIST.add(new Column("TXN_ID", 4));
            ALL_COLUMNS_SQLTYPE = new int[ALL_COLUMNS_LIST.size()];
            Iterator iter = ALL_COLUMNS_LIST.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Column element = (Column)iter.next();
                RelationshipsTable.ALL_COLUMNS_SQLTYPE[i] = element.getDataType();
                ++i;
            }
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, RelationshipsTable.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String REFERRER_LGCL_ID = "REFERRER_LGCL_ID";
            public static final String REFERRER_UUID1 = "REFERRER_UUID1";
            public static final String REFERRER_UUID2 = "REFERRER_UUID2";
            public static final String REFERRER_UUID_STRING = "REFERRER_UUID_STRING";
            public static final String REFEREE_LGCL_ID = "REFEREE_LGCL_ID";
            public static final String REFEREE_UUID1 = "REFEREE_UUID1";
            public static final String REFEREE_UUID2 = "REFEREE_UUID2";
            public static final String REFEREE_UUID_STRING = "REFEREE_UUID_STRING";
            public static final String REFEREE_POSITION = "REFEREE_POSITION";
            public static final String REL_FTRE_ID = "REL_FTRE_ID";
            public static final String TXN_ID = "TXN_ID";
        }
    }

    public static class ModelsTable {
        public static final String TABLE_NAME = "DD_MDL";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static Collection ALL_COLUMNS_LIST;
        public static int[] ALL_COLUMNS_SQLTYPE;
        public static final int LGCL_ID_INDEX = 0;
        public static final int UUID1_INDEX = 1;
        public static final int UUID2_INDEX = 2;
        public static final int UUID_STRING_INDEX = 3;
        public static final int NME_INDEX = 4;
        public static final int TXN_ID_INDEX = 5;
        public static final int VRSION_INDEX = 6;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("LGCL_ID", 12));
            ALL_COLUMNS_LIST.add(new Column("UUID1", 4));
            ALL_COLUMNS_LIST.add(new Column("UUID2", 4));
            ALL_COLUMNS_LIST.add(new Column("UUID_STRING", 12));
            ALL_COLUMNS_LIST.add(new Column("NME", 12));
            ALL_COLUMNS_LIST.add(new Column("TXN_ID", 4));
            ALL_COLUMNS_LIST.add(new Column("VRSION", 12));
            ALL_COLUMNS_SQLTYPE = new int[ALL_COLUMNS_LIST.size()];
            Iterator iter = ALL_COLUMNS_LIST.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Column element = (Column)iter.next();
                ModelsTable.ALL_COLUMNS_SQLTYPE[i] = element.getDataType();
                ++i;
            }
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, ModelsTable.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String LGCL_ID = "LGCL_ID";
            public static final String UUID1 = "UUID1";
            public static final String UUID2 = "UUID2";
            public static final String UUID_STRING = "UUID_STRING";
            public static final String NME = "NME";
            public static final String TXN_ID = "TXN_ID";
            public static final String VRSION = "VRSION";
        }
    }

    public static class ModelMetamodelIntersectTable {
        public static final String TABLE_NAME = "DD_MDL_MTAMDL";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static Collection ALL_COLUMNS_LIST;
        public static int[] ALL_COLUMNS_SQLTYPE;
        public static final int MDL_LGCL_ID_INDEX = 0;
        public static final int MDL_UUID1_INDEX = 1;
        public static final int MDL_UUID2_INDEX = 2;
        public static final int MDL_UUID_STRING_INDEX = 3;
        public static final int MTAMDL_ID_INDEX = 4;
        public static final int TXN_ID_INDEX = 5;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("MDL_LGCL_ID", 12));
            ALL_COLUMNS_LIST.add(new Column("MDL_UUID1", 4));
            ALL_COLUMNS_LIST.add(new Column("MDL_UUID2", 4));
            ALL_COLUMNS_LIST.add(new Column("MDL_UUID_STRING", 12));
            ALL_COLUMNS_LIST.add(new Column("MTAMDL_ID", 4));
            ALL_COLUMNS_LIST.add(new Column("TXN_ID", 4));
            ALL_COLUMNS_SQLTYPE = new int[ALL_COLUMNS_LIST.size()];
            Iterator iter = ALL_COLUMNS_LIST.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Column element = (Column)iter.next();
                ModelMetamodelIntersectTable.ALL_COLUMNS_SQLTYPE[i] = element.getDataType();
                ++i;
            }
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, ModelMetamodelIntersectTable.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String MDL_LGCL_ID = "MDL_LGCL_ID";
            public static final String MDL_UUID1 = "MDL_UUID1";
            public static final String MDL_UUID2 = "MDL_UUID2";
            public static final String MDL_UUID_STRING = "MDL_UUID_STRING";
            public static final String MTAMDL_ID = "MTAMDL_ID";
            public static final String TXN_ID = "TXN_ID";
        }
    }

    public static class ObjectIndexTable {
        public static final String TABLE_NAME = "DD_INDEX";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static Collection ALL_COLUMNS_LIST;
        public static int[] ALL_COLUMNS_SQLTYPE;
        public static final int LGCL_ID_INDEX = 0;
        public static final int UUID1_INDEX = 1;
        public static final int UUID2_INDEX = 2;
        public static final int UUID_STRING_INDEX = 3;
        public static final int NME_INDEX = 4;
        public static final int VIRTUAL_DETAIL_TBLE_NME_INDEX = 5;
        public static final int DETAIL_TBLE_NME_INDEX = 6;
        public static final int MDL_LGCL_ID_INDEX = 7;
        public static final int MDL_UUID1_INDEX = 8;
        public static final int MDL_UUID2_INDEX = 9;
        public static final int MDL_UUID_STRING_INDEX = 10;
        public static final int MTACLS_TYPE_ID_INDEX = 11;
        public static final int PARENT_LGCL_ID_INDEX = 12;
        public static final int PARENT_UUID1_INDEX = 13;
        public static final int PARENT_UUID2_INDEX = 14;
        public static final int PARENT_UUID_STRING_INDEX = 15;
        public static final int TXN_ID_INDEX = 16;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("LGCL_ID", 12));
            ALL_COLUMNS_LIST.add(new Column("UUID1", 4));
            ALL_COLUMNS_LIST.add(new Column("UUID2", 4));
            ALL_COLUMNS_LIST.add(new Column("UUID_STRING", 12));
            ALL_COLUMNS_LIST.add(new Column("NME", 12));
            ALL_COLUMNS_LIST.add(new Column("DETAIL_TBLE_NME", 12));
            ALL_COLUMNS_LIST.add(new Column("VIRT_DETL_TBLE_NME", 12));
            ALL_COLUMNS_LIST.add(new Column("MDL_LGCL_ID", 12));
            ALL_COLUMNS_LIST.add(new Column("MDL_UUID1", 4));
            ALL_COLUMNS_LIST.add(new Column("MDL_UUID2", 4));
            ALL_COLUMNS_LIST.add(new Column("MDL_UUID_STRING", 12));
            ALL_COLUMNS_LIST.add(new Column("MTACLS_TYPE_ID", 4));
            ALL_COLUMNS_LIST.add(new Column("PARENT_LGCL_ID", 12));
            ALL_COLUMNS_LIST.add(new Column("PARENT_UUID1", 4));
            ALL_COLUMNS_LIST.add(new Column("PARENT_UUID2", 4));
            ALL_COLUMNS_LIST.add(new Column("PARENT_UUID_STRING", 12));
            ALL_COLUMNS_LIST.add(new Column("TXN_ID", 4));
            ALL_COLUMNS_SQLTYPE = new int[ALL_COLUMNS_LIST.size()];
            Iterator iter = ALL_COLUMNS_LIST.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Column element = (Column)iter.next();
                ObjectIndexTable.ALL_COLUMNS_SQLTYPE[i] = element.getDataType();
                ++i;
            }
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, ObjectIndexTable.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String LGCL_ID = "LGCL_ID";
            public static final String UUID1 = "UUID1";
            public static final String UUID2 = "UUID2";
            public static final String UUID_STRING = "UUID_STRING";
            public static final String NME = "NME";
            public static final String DETAIL_TBLE_NME = "DETAIL_TBLE_NME";
            public static final String VIRTUAL_DETAIL_TBLE_NME = "VIRT_DETL_TBLE_NME";
            public static final String MDL_LGCL_ID = "MDL_LGCL_ID";
            public static final String MDL_UUID1 = "MDL_UUID1";
            public static final String MDL_UUID2 = "MDL_UUID2";
            public static final String MDL_UUID_STRING = "MDL_UUID_STRING";
            public static final String MTACLS_TYPE_ID = "MTACLS_TYPE_ID";
            public static final String PARENT_LGCL_ID = "PARENT_LGCL_ID";
            public static final String PARENT_UUID1 = "PARENT_UUID1";
            public static final String PARENT_UUID2 = "PARENT_UUID2";
            public static final String PARENT_UUID_STRING = "PARENT_UUID_STRING";
            public static final String TXN_ID = "TXN_ID";
        }
    }

    public static class ShredderQueueTable {
        public static final String TABLE_NAME = "DD_SHREDQUEUE";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static String ALL_COLUMNS_COMMA_DELIMITED_USING_AS;
        public static Collection ALL_COLUMNS_LIST;
        public static final int QUEUE_ID_INDEX = 0;
        public static final int UUID1_INDEX = 1;
        public static final int UUID2_INDEX = 2;
        public static final int OJECT_ID_INDEX = 3;
        public static final int NAME_INDEX = 4;
        public static final int VERSION_INDEX = 5;
        public static final int PATH_INDEX = 6;
        public static final int ACTION_INDEX = 7;
        public static final int TXN_ID_INDEX = 8;
        public static final int SUB_BY_INDEX = 9;
        public static final int SUB_BY_DATE_INDEX = 10;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("QUEUE_ID", 4));
            ALL_COLUMNS_LIST.add(new Column("UUID1", 2));
            ALL_COLUMNS_LIST.add(new Column("UUID2", 2));
            ALL_COLUMNS_LIST.add(new Column("OBJECT_ID", 12));
            ALL_COLUMNS_LIST.add(new Column("NAME", 12));
            ALL_COLUMNS_LIST.add(new Column("VERSION", 12));
            ALL_COLUMNS_LIST.add(new Column("MDL_PATH", 12));
            ALL_COLUMNS_LIST.add(new Column("CMD_ACTION", 12));
            ALL_COLUMNS_LIST.add(new Column("TXN_ID", 4));
            ALL_COLUMNS_LIST.add(new Column("SUB_BY_NME", 12));
            ALL_COLUMNS_LIST.add(new Column("SUB_BY_DATE", 12));
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, ShredderQueueTable.ALL_COLUMNS_LIST);
            ALL_COLUMNS_COMMA_DELIMITED_USING_AS = JDBCNames.createCommaDelimString("a", ShredderQueueTable.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String QUEUE_ID = "QUEUE_ID";
            public static final String UUID1 = "UUID1";
            public static final String UUID2 = "UUID2";
            public static final String OBJECT_ID = "OBJECT_ID";
            public static final String NAME = "NAME";
            public static final String VERSION = "VERSION";
            public static final String PATH = "MDL_PATH";
            public static final String ACTION = "CMD_ACTION";
            public static final String TXN_ID = "TXN_ID";
            public static final String SUBMITTED_BY = "SUB_BY_NME";
            public static final String SUBMITTED_DATE = "SUB_BY_DATE";
        }
    }

    public static class ReQueueToShredView {
        public static final String TABLE_NAME = "DD_REQUEUETOSHRED_VIEW";
        public static String ALL_COLUMNS_COMMA_DELIMITED;
        public static Collection ALL_COLUMNS_LIST;
        public static final int UUID1_INDEX = 1;
        public static final int UUID2_INDEX = 2;
        public static final int MDLNAME_INDEX = 3;
        public static final int DDVRSION_INDEX = 4;
        public static final int MBRVRSION_INDEX = 5;
        public static final int TXN_ID_INDEX = 6;
        public static final int COMMAND_TYPE_INDEX = 7;

        static {
            ALL_COLUMNS_LIST = new ArrayList();
            ALL_COLUMNS_LIST.add(new Column("UUID1", 2));
            ALL_COLUMNS_LIST.add(new Column("UUID2", 2));
            ALL_COLUMNS_LIST.add(new Column("MDLNAME", 12));
            ALL_COLUMNS_LIST.add(new Column("DDVRSION", 12));
            ALL_COLUMNS_LIST.add(new Column("MBRVRSION", 12));
            ALL_COLUMNS_LIST.add(new Column("TXN_ID", 2));
            ALL_COLUMNS_LIST.add(new Column("COMMAND_TYPE", 2));
            ALL_COLUMNS_COMMA_DELIMITED = JDBCNames.createCommaDelimString(TABLE_NAME, ReQueueToShredView.ALL_COLUMNS_LIST);
        }

        public static class ColumnName {
            public static final String UUID1 = "UUID1";
            public static final String UUID2 = "UUID2";
            public static final String MDLNAME = "MDLNAME";
            public static final String DDVRSION = "DDVRSION";
            public static final String MBRVRSION = "MBRVRSION";
            public static final String TXN_ID = "TXN_ID";
            public static final String COMMAND_TYPE = "COMMAND_TYPE";
        }
    }
}

