/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.installer.server.tasks;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.id.UUID;
import com.metamatrix.installer.InstallerPlugin;
import com.metamatrix.installer.transformation.apiimpl.BasicTask;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import com.metamatrix.metabase.repository.internal.util.XsdToXmiUtil;
import com.metamatrix.metamodels.db.model.component.request.MetabaseRepositoryShredderComponentRequest;
import com.metamatrix.metamodels.db.model.service.IndexingService;
import com.metamatrix.metamodels.db.model.service.message.BasicIndexingServiceModelActionRequest;
import com.metamatrix.metamodels.db.platform.api.IndexingServiceModelActionRequest;
import com.metamatrix.modeler.core.types.DatatypeConstants;
import com.metamatrix.platform.resource.MessageReceiver;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;

public class LoadBuiltInDatatypesTask
extends BasicTask {
    public static final String BUILT_IN_DATATYPES_MODEL_RESOURCE_NAME = "builtInDataTypes.xsd";
    public static final String BUILT_IN_RELATIONSHIPS_RESOURCE_NAME = "builtInRelationshipTypes.xmi";
    public static final String PRIMITIVE_TYPES_RESOURCE_NAME = "primitiveTypes.xmi";
    public static final String SCHEMA_2001_BASE_REPOSITORY_LOCATION_URI = "www.w3.org/2001/";
    public static final String SCHEMA_1999_BASE_REPOSITORY_LOCATION_URI = "www.w3.org/1999/";
    public static final String SCHEMA_2000_10_BASE_REPOSITORY_LOCATION_URI = "www.w3.org/2000/10/";
    public static final String SETUPMM_USERNAME = "setupmm";
    public static final String FAKE_MESSAGE_TOPIC = "message";
    private static final String FILE_NOT_LOADED_MESSAGE_KEY = "LoadBuiltInDatatypesTask.file_named_not_obtained_as_a_resource_from_the_classpath";
    public static final String BUILT_IN_MODELS_REP_LOCATION = "/.metadata/";

    protected void process() throws MetaMatrixException {
        IndexingService service = null;
        try {
            service = this.getIndexingService();
        }
        catch (Exception e) {
            String msg = InstallerPlugin.Util.getString("LoadBuiltInDatatypesTask.Unable_to_create_an_Indexing_Service_instance._1");
            this.logError(e, msg);
            throw new MetaMatrixException((Throwable)e, msg);
        }
        this.loadBuiltInModelForNamespace("http://www.w3.org/2001/XMLSchema", 2, "MagicXMLSchema.xsd", SCHEMA_2001_BASE_REPOSITORY_LOCATION_URI, service, DatatypeConstants.XML_MAGIC_SCHEMA_UUID_2001);
        this.loadBuiltInModelForNamespace("http://www.w3.org/2001/XMLSchema-instance", 1, "XMLSchema-instance.xsd", SCHEMA_2001_BASE_REPOSITORY_LOCATION_URI, service, DatatypeConstants.XML_SCHEMA_INSTANCE_UUID_2001);
        this.loadBuiltInModelForNamespace("http://www.w3.org/2001/XMLSchema", 0, "XMLSchema.xsd", SCHEMA_2001_BASE_REPOSITORY_LOCATION_URI, service, DatatypeConstants.XML_SCHEMA_UUID_2001);
        this.loadBuiltInModelForNamespace("http://www.w3.org/1999/XMLSchema", 2, "MagicXMLSchema.xsd", SCHEMA_1999_BASE_REPOSITORY_LOCATION_URI, service, DatatypeConstants.XML_MAGIC_SCHEMA_UUID_1999);
        this.loadBuiltInModelForNamespace("http://www.w3.org/1999/XMLSchema", 0, "XMLSchema.xsd", SCHEMA_1999_BASE_REPOSITORY_LOCATION_URI, service, DatatypeConstants.XML_SCHEMA_UUID_1999);
        this.loadBuiltInModelForNamespace("http://www.w3.org/2000/10/XMLSchema", 2, "MagicXMLSchema.xsd", SCHEMA_2000_10_BASE_REPOSITORY_LOCATION_URI, service, DatatypeConstants.XML_MAGIC_SCHEMA_UUID_2000_10);
        this.loadBuiltInModelForNamespace("http://www.w3.org/2000/10/XMLSchema", 0, "XMLSchema.xsd", SCHEMA_2000_10_BASE_REPOSITORY_LOCATION_URI, service, DatatypeConstants.XML_SCHEMA_UUID_2000_10);
        IndexingServiceModelActionRequest builtInDatatypesRequest = this.getXsdResourceIndexingServiceRequest(BUILT_IN_DATATYPES_MODEL_RESOURCE_NAME, DatatypeConstants.BUILTIN_DATATYPES_MODEL_UUID);
        this.submitIndexingServiceRequest(builtInDatatypesRequest, service);
        IndexingServiceModelActionRequest builtInRelationshipsRequest = this.getXmiResourceIndexingServiceRequest(BUILT_IN_RELATIONSHIPS_RESOURCE_NAME);
        this.submitIndexingServiceRequest(builtInRelationshipsRequest, service);
        IndexingServiceModelActionRequest primitiveTypesRequest = this.getXmiResourceIndexingServiceRequest(PRIMITIVE_TYPES_RESOURCE_NAME);
        this.submitIndexingServiceRequest(primitiveTypesRequest, service);
    }

    private IndexingServiceModelActionRequest getXmiResourceIndexingServiceRequest(String resourceName) throws MetaMatrixException {
        try {
            InputStream headerStream = ClassLoader.getSystemResourceAsStream(resourceName);
            InputStream parserStream = ClassLoader.getSystemResourceAsStream(resourceName);
            BufferedInputStream stream = new BufferedInputStream(parserStream);
            if (headerStream == null || parserStream == null) {
                Object[] params = new Object[]{resourceName};
                String message = InstallerPlugin.Util.getString(FILE_NOT_LOADED_MESSAGE_KEY, params);
                throw new MetaMatrixException(message);
            }
            String fileURI = BUILT_IN_MODELS_REP_LOCATION + resourceName;
            XMIHeader header = XMIHeaderReader.readHeader((InputStream)headerStream);
            String uuid = header.getUUID();
            ObjectID id = UUID.stringToObject((String)uuid.substring(uuid.indexOf(58) + 1));
            BasicIndexingServiceModelActionRequest request = new BasicIndexingServiceModelActionRequest(id, stream, 0, resourceName, SETUPMM_USERNAME, fileURI);
            return request;
        }
        catch (Exception e) {
            Object[] params = new Object[]{resourceName};
            String message = InstallerPlugin.Util.getString("LoadBuiltInDatatypesTask.Unable_to_create_a_request_to_load_the_built_in_model_xmi_resource__{0}_into_the_DTC._1", params);
            this.logError(e, message);
            throw new MetaMatrixException((Throwable)e, message);
        }
    }

    private IndexingServiceModelActionRequest getXsdResourceIndexingServiceRequest(String resourceName, ObjectID modelUUID) throws MetaMatrixException {
        try {
            InputStream parserStream = ClassLoader.getSystemResourceAsStream(resourceName);
            if (parserStream == null) {
                Object[] params = new Object[]{resourceName};
                String message = InstallerPlugin.Util.getString(FILE_NOT_LOADED_MESSAGE_KEY, params);
                throw new MetaMatrixException(message);
            }
            String fileURI = BUILT_IN_MODELS_REP_LOCATION + resourceName;
            InputStream xmiStream = XsdToXmiUtil.transformXsdToXmiStream((InputStream)parserStream, (URI)URI.createFileURI((String)resourceName), (URI)URI.createFileURI((String)resourceName), (String)fileURI);
            BufferedInputStream bufXmiStream = new BufferedInputStream(xmiStream);
            BasicIndexingServiceModelActionRequest request = new BasicIndexingServiceModelActionRequest(modelUUID, bufXmiStream, 0, resourceName, SETUPMM_USERNAME, fileURI);
            return request;
        }
        catch (MetaMatrixException e) {
            Object[] params = new Object[]{resourceName};
            String message = InstallerPlugin.Util.getString("LoadBuiltInDatatypesTask.Unable_to_create_a_request_to_load_the_built_in_model_xsd_resource__{0}_into_the_DTC._2", params);
            this.logError(e, message);
            throw new MetaMatrixException((Throwable)e, message);
        }
    }

    private IndexingServiceModelActionRequest getBuiltInXsdResourceIndexingServiceRequest(String schemaNamespace, int schemaType, String resourceName, String repLocationURI, ObjectID modelUUID) throws Exception {
        String fileURI = BUILT_IN_MODELS_REP_LOCATION + repLocationURI;
        InputStream xmiStream = XsdToXmiUtil.getBuiltInXSDXMIStream((String)schemaNamespace, (int)schemaType, (URI)URI.createURI((String)fileURI), (URI)URI.createURI((String)fileURI), (String)fileURI);
        if (xmiStream == null) {
            return null;
        }
        BufferedInputStream bufXmiStream = new BufferedInputStream(xmiStream);
        BasicIndexingServiceModelActionRequest request = new BasicIndexingServiceModelActionRequest(modelUUID, bufXmiStream, 0, resourceName, SETUPMM_USERNAME, fileURI);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitIndexingServiceRequest(IndexingServiceModelActionRequest request, IndexingService service) throws MetaMatrixException {
        BlockingMessageListener listener = new BlockingMessageListener();
        FakeMessageReceiver receiver = new FakeMessageReceiver();
        receiver.addListener(FAKE_MESSAGE_TOPIC, listener);
        try {
            service.setMessageReceiver(receiver, new Properties(), SETUPMM_USERNAME);
            service.send((Message)request, FAKE_MESSAGE_TOPIC, SETUPMM_USERNAME);
            BlockingMessageListener blockingMessageListener = listener;
            synchronized (blockingMessageListener) {
                listener.wait(45000L);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{request.getModelName()};
            String message = InstallerPlugin.Util.getString("LoadBuiltInDatatypesTask.Submitting_a_request_to_load_the_built_in_model_resource__{0}_caused_the_following_error._3", params);
            this.logError(e, message);
            throw new MetaMatrixException((Throwable)e, message);
        }
    }

    private IndexingService getIndexingService() throws Exception {
        IndexingService service = new IndexingService();
        Properties systemProps = System.getProperties();
        ((Hashtable)systemProps).remove("metamatrix.config.none");
        System.setProperties(systemProps);
        CurrentConfiguration.reset();
        Configuration config = CurrentConfiguration.getConfiguration();
        ServiceComponentDefn defn = config.getServiceComponentDefn("IndexingService");
        if (defn == null) {
            Object[] params = new Object[]{"IndexingService"};
            String msg = InstallerPlugin.Util.getString("LoadBuiltInDatatypesTask.There_was_a_problem_retreiving_the_ServiceComponentDefn_object_from_the_current_Configuration_for_the_id_name__{0}_4", params);
            this.logError(msg);
            throw new MetaMatrixException(msg);
        }
        Properties serviceProps = defn.getProperties();
        Properties resourceProps = CurrentConfiguration.getResourceProperties((String)"IndexingService");
        ((Hashtable)serviceProps).putAll(resourceProps);
        serviceProps.setProperty("turnoff.queue.checking", "true");
        service.initForTest(serviceProps);
        return service;
    }

    private void loadBuiltInModelForNamespace(String namespace, int schemaType, String schemaTypeName, String repModelLocation, IndexingService service, ObjectID modelID) throws MetaMatrixException {
        try {
            Object[] params = new Object[]{schemaTypeName, namespace};
            String logMessage = InstallerPlugin.Util.getString("LoadBuiltInDatatypesTask.The_model_with_name__{0}_and_namespace__1", params);
            this.logInfo(logMessage);
            IndexingServiceModelActionRequest builtInDatatypesRequest = this.getBuiltInXsdResourceIndexingServiceRequest(namespace, schemaType, schemaTypeName, String.valueOf(repModelLocation) + schemaTypeName, modelID);
            if (builtInDatatypesRequest != null) {
                this.submitIndexingServiceRequest(builtInDatatypesRequest, service);
            } else {
                String msg = InstallerPlugin.Util.getString("LoadBuiltInDatatypesTask.The_builtInResource__{0}_with_namespace_{1}_was_not_found_in_the_global_xsd_resource_set._1", params);
                this.logWarning(msg);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{schemaTypeName};
            String msg = InstallerPlugin.Util.getString("LoadBuiltInDatatypesTask.Unable_to_load_the_built_in_resource_for_the_XMLSchema_2001_standard_schemas_named__{0}._2", params);
            this.logError(e, msg);
            throw new MetaMatrixException((Throwable)e, msg);
        }
    }

    public class BlockingMessageListener
    implements MessageListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deliverMessage(Message message, String messageKey) {
            MetabaseRepositoryShredderComponentRequest request;
            if (message instanceof MetabaseRepositoryShredderComponentRequest && (request = (MetabaseRepositoryShredderComponentRequest)message).isCompleted()) {
                BlockingMessageListener blockingMessageListener = this;
                synchronized (blockingMessageListener) {
                    this.notifyAll();
                }
            }
        }
    }

    public class FakeMessageReceiver
    implements MessageReceiver {
        private Map topicsToListeners = new HashMap();

        public synchronized void receive(String topic, Message message) {
            List listeners = (List)this.topicsToListeners.get(topic);
            if (listeners != null) {
                Iterator iter = listeners.iterator();
                while (iter.hasNext()) {
                    MessageListener listener = (MessageListener)iter.next();
                    listener.deliverMessage(message, topic);
                }
            } else {
                Object[] params = new Object[]{message, topic};
                CommPlatformPlugin.Util.log(4, CommPlatformPlugin.Util.getString("PlatformMessageReceiver.Unable_to_receive_message_[{0}],_no_listeners_for_topic_[{1}]", params));
            }
        }

        public synchronized void addListener(String topic, MessageListener listener) {
            ArrayList<MessageListener> listeners = (ArrayList<MessageListener>)this.topicsToListeners.get(topic);
            if (listeners == null) {
                listeners = new ArrayList<MessageListener>();
            }
            listeners.add(listener);
            this.topicsToListeners.put(topic, listeners);
        }

        public synchronized void removeListener(String topic, MessageListener listener) {
            List listeners = (List)this.topicsToListeners.get(topic);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.topicsToListeners.remove(topic);
                }
            }
        }
    }
}

