/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.api.MMURL;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.log.Logger;
import com.metamatrix.core.log.NullLogger;
import com.metamatrix.jdbc.BaseDataSource;
import com.metamatrix.jdbc.DriverManagerLogger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMDriver;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMXAConnection;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class MMDataSource
extends BaseDataSource
implements XADataSource {
    protected static final int DEFAULT_TIMEOUT = 0;
    protected static final int DEFAULT_LOG_LEVEL = 0;
    private int portNumber;
    private String serverName;
    private String socketsPerVM;
    private String stickyConnections;
    private String credentials;
    private boolean secure = false;
    static final String SERVER_URL = "serverURL";
    static final String HOST = "host";
    static final String PORT = "port";
    private Logger logger;

    protected Properties buildProperties(String userName, String password) {
        Properties props = super.buildProperties(userName, password);
        props.setProperty(SERVER_URL, this.buildServerURL());
        props.setProperty(HOST, this.serverName);
        props.setProperty(PORT, String.valueOf(this.portNumber));
        if (this.getSocketsPerVM() != null) {
            props.setProperty("socketsPerVM", this.getSocketsPerVM());
        }
        if (this.getStickyConnections() != null) {
            props.setProperty("stickyConnections", this.getStickyConnections());
        }
        if (this.getCredentials() != null) {
            props.setProperty("credentials", this.getCredentials());
        }
        return props;
    }

    protected String buildServerURL() {
        return new MMURL(this.serverName, this.portNumber, this.secure).getAppServerURL();
    }

    protected String buildURL() {
        return new MMJDBCURL(this.getDatabaseName(), this.buildServerURL(), this.buildProperties(this.getUser(), this.getPassword())).getJDBCURL();
    }

    protected void validateProperties(String userName, String password) throws SQLException {
        super.validateProperties(userName, password);
        String reason = MMDataSource.reasonWhyInvalidPortNumber(this.portNumber);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = MMDataSource.reasonWhyInvalidServerName(this.serverName);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = MMDataSource.reasonWhyInvalidSocketsPerVM(this.socketsPerVM);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = MMDataSource.reasonWhyInvalidStickyConnections(this.stickyConnections);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
    }

    private MMSQLException createConnectionError(String reason) {
        String msg = JDBCPlugin.Util.getString("MMDataSource.Err_connecting", (Object)reason);
        return new MMSQLException(msg);
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            this.validateProperties(userName, password);
            Properties props = this.buildProperties(userName, password);
            MMDriver driver = new MMDriver();
            return driver.createMMConnection(null, props);
        }
        catch (MetaMatrixCoreException e2) {
            this.getLogger().log(1, (Throwable)e2, e2.getMessage());
            throw MMSQLException.create((Throwable)e2, (String)e2.getMessage());
        }
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(null, null);
    }

    public XAConnection getXAConnection(String userName, String password) throws SQLException {
        try {
            this.validateProperties(userName, password);
            Properties props = this.buildProperties(userName, password);
            String url = this.buildURL();
            return this.createMMXAConnection(url, props);
        }
        catch (Exception e2) {
            String msg = JDBCPlugin.Util.getString("MMDataSource.Err_creating_XAConn", (Object)e2.getMessage());
            this.getLogger().log(1, (Throwable)e2, msg);
            if (e2 instanceof MMSQLException) {
                throw (MMSQLException)e2;
            }
            throw MMSQLException.create((Throwable)e2, (String)msg);
        }
    }

    protected MMXAConnection createMMXAConnection(String url, Properties props) throws Exception {
        MMXAConnection mc = MMXAConnection.newInstance((String)url, (Properties)props);
        mc.setMmDataSource(this);
        return mc;
    }

    public String toString() {
        return this.buildURL().substring(16);
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getSocketsPerVM() {
        return this.socketsPerVM;
    }

    public String getStickyConnections() {
        return this.stickyConnections;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setSocketsPerVM(String socketsPerVM) {
        this.socketsPerVM = socketsPerVM;
    }

    public void setStickyConnections(String stickyConnections) {
        this.stickyConnections = stickyConnections;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public static String reasonWhyInvalidPortNumber(int portNumber) {
        if (portNumber == 0) {
            return null;
        }
        if (portNumber < 1) {
            return JDBCPlugin.Util.getString("MMDataSource.Port_number_must_be_positive");
        }
        return null;
    }

    public static String reasonWhyInvalidServerName(String serverName) {
        if (serverName == null || serverName.trim().length() == 0) {
            return JDBCPlugin.Util.getString("MMDataSource.Server_name_required");
        }
        return null;
    }

    public static String reasonWhyInvalidSocketsPerVM(String socketsPerVM) {
        if (socketsPerVM != null) {
            int value = -1;
            try {
                value = Integer.parseInt(socketsPerVM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value <= 0) {
                return JDBCPlugin.Util.getString("MMDataSource.Sockets_per_vm_invalid");
            }
        }
        return null;
    }

    public static String reasonWhyInvalidStickyConnections(String stickyConnections) {
        if (stickyConnections != null && !stickyConnections.equalsIgnoreCase("true") && !stickyConnections.equalsIgnoreCase("false")) {
            return JDBCPlugin.Util.getString("MMDataSource.Sticky_connections_invalid");
        }
        return null;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            try {
                this.logger = this.getLogFile() != null ? new DriverManagerLogger(this.getLogLevel(), new PrintWriter(new FileWriter(this.getLogFile()))) : new DriverManagerLogger(this.getLogLevel(), this.getLogWriter());
            }
            catch (Exception e2) {
                this.logger = new NullLogger();
            }
        }
        return this.logger;
    }

    static {
        try {
            Class.forName("com.metamatrix.jdbc.MMDriver");
        }
        catch (ClassNotFoundException e2) {
            String msg = JDBCPlugin.Util.getString("MMDataSource.Cant_load_driver");
            DriverManager.println(msg);
        }
    }
}

