/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xmlsource.soap;

import com.metamatrix.connector.xmlsource.XMLSourcePlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.ser.ElementDeserializerFactory;
import org.apache.axis.encoding.ser.ElementSerializerFactory;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.w3c.dom.Element;

public class ServiceOperation {
    private static final String DOCUMENT = "document";
    String name;
    Parameters parameters;
    Call stub;
    String endpoint;
    String portName;
    Integer queryTimeout = null;
    boolean usesComplexType = false;
    String style;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    ServiceOperation(String name, Parameters parms, String portName, String style) {
        this.name = name;
        this.parameters = parms;
        this.portName = portName;
        this.style = style;
        for (int i = 0; i < this.parameters.list.size(); ++i) {
            Parameter p = (Parameter)this.parameters.list.get(i);
            TypeEntry type = p.getType();
            if (type.isBaseType()) continue;
            this.usesComplexType = true;
        }
    }

    void setStub(Call stub) {
        this.stub = stub;
    }

    void setQueryTimeput(int timeInSec) {
        this.queryTimeout = new Integer(timeInSec * 1000);
    }

    void setEndpoint(String end) {
        this.endpoint = end;
    }

    boolean isDocLiteral() {
        return this.style != null && this.style.equalsIgnoreCase(DOCUMENT);
    }

    public Object execute(Object[] args, Map outs) throws ExcutionFailedException {
        Object doc = null;
        try {
            Parameter returnParam;
            if (this.endpoint != null) {
                this.stub.setTargetEndpointAddress(this.endpoint);
            }
            if (this.queryTimeout != null) {
                this.stub.setTimeout(this.queryTimeout);
            }
            if (this.isDocLiteral()) {
                if (args.length > 1) {
                    throw new ExcutionFailedException(XMLSourcePlugin.Util.getString("wrong_number_params", new Object[]{new Integer(1), new Integer(args.length)}));
                }
            } else {
                int requiredParamCount = this.stub.getOperation().getNumInParams();
                if (requiredParamCount != args.length) {
                    throw new ExcutionFailedException(XMLSourcePlugin.Util.getString("wrong_number_params", new Object[]{new Integer(requiredParamCount), new Integer(args.length)}));
                }
            }
            boolean messageStyleInvoke = false;
            if (this.usesComplexType || this.isDocLiteral()) {
                ArrayList<SOAPBodyElement> bodyElements = new ArrayList<SOAPBodyElement>();
                for (int i = 0; i < args.length; ++i) {
                    ByteArrayInputStream element = new ByteArrayInputStream(args[i].toString().getBytes());
                    bodyElements.add(new SOAPBodyElement((InputStream)element));
                }
                args = bodyElements.toArray(new Object[bodyElements.size()]);
                messageStyleInvoke = true;
            }
            if ((returnParam = this.parameters.returnParam) != null && !returnParam.getType().isBaseType()) {
                this.stub.registerTypeMapping(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = ServiceOperation.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element, returnParam.getType().getQName(), (SerializerFactory)new ElementSerializerFactory(), (DeserializerFactory)new ElementDeserializerFactory());
            }
            doc = this.stub.invoke(args);
            Map outputs = this.stub.getOutputParams();
            if (outputs != null) {
                outs.putAll(outputs);
            }
            if (messageStyleInvoke) {
                doc = ((Vector)doc).get(0);
            }
            if (doc instanceof Element) {
                return XMLUtils.ElementToString((Element)((Element)doc));
            }
            if (!this.isDocLiteral() && doc != null && returnParam != null && returnParam.getType().isBaseType()) {
                StringBuffer sb = new StringBuffer();
                sb.append("<return type=\"");
                sb.append(doc.getClass().getName());
                sb.append("\">");
                sb.append(XMLUtils.xmlEncodeString((String)doc.toString()));
                sb.append("</return>");
                return sb.toString();
            }
        }
        catch (RemoteException e) {
            throw new ExcutionFailedException(e);
        }
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ExcutionFailedException
    extends Exception {
        public ExcutionFailedException(Throwable e) {
            super(e);
        }

        public ExcutionFailedException(String msg) {
            super(msg);
        }
    }
}

