/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.connector.jdbc.util.FunctionReplacementVisitor;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.visitor.framework.LanguageObjectVisitor;
import com.metamatrix.data.visitor.util.NamingCorrectionVisitor;
import com.metamatrix.data.visitor.util.SQLStringVisitor;
import java.util.List;
import java.util.Map;

public class TranslatedCommand {
    public static final int EXEC_TYPE_QUERY = 0;
    public static final int EXEC_TYPE_UPDATE = 1;
    public static final int EXEC_TYPE_EXECUTE = 2;
    public static final int STMT_TYPE_STATEMENT = 0;
    public static final int STMT_TYPE_PREPARED_STATEMENT = 1;
    public static final int STMT_TYPE_CALLABLE_STATEMENT = 2;
    private String sql;
    private int executionType;
    private int statementType;
    private List preparedValues;
    private SQLConversionVisitor sqlConversionVisitor;
    private FunctionReplacementVisitor functionVisitor;
    private ExecutionContext context;
    private SQLTranslator sqlTranslator;

    public TranslatedCommand(ExecutionContext context, SQLTranslator sqlTranslator) {
        this.context = context;
        this.sqlTranslator = sqlTranslator;
        Map modifiers = sqlTranslator.getFunctionModifiers();
        this.sqlConversionVisitor = sqlTranslator.getTranslationVisitor();
        this.sqlConversionVisitor.setFunctionModifiers(modifiers);
        this.sqlConversionVisitor.setExecutionContext(context);
        this.functionVisitor = new FunctionReplacementVisitor(modifiers);
    }

    public TranslatedCommand(ExecutionContext context, SQLTranslator sqlTranslator, SQLConversionVisitor sqlConversionVisitor, FunctionReplacementVisitor functionVisitor) {
        this.context = context;
        this.sqlTranslator = sqlTranslator;
        this.sqlConversionVisitor = sqlConversionVisitor;
        this.functionVisitor = functionVisitor;
    }

    public void translateCommand(ICommand command) throws ConnectorException {
        this.sql = this.getSQL(command);
        this.statementType = this.sqlConversionVisitor.getStmtType();
        this.executionType = this.sqlConversionVisitor.getExecType();
        this.preparedValues = this.sqlConversionVisitor.getPreparedValues();
    }

    private String getSQL(ICommand command) throws ConnectorException {
        NamingCorrectionVisitor visitor = new NamingCorrectionVisitor((SQLStringVisitor)this.sqlConversionVisitor);
        command.acceptVisitor((LanguageObjectVisitor)visitor);
        command = this.sqlTranslator.modifyCommand(command, this.context);
        command.acceptVisitor((LanguageObjectVisitor)this.functionVisitor);
        this.sqlConversionVisitor.append((ILanguageObject)command);
        return this.sqlConversionVisitor.toString();
    }

    public int getExecutionType() {
        return this.executionType;
    }

    public List getPreparedValues() {
        return this.preparedValues;
    }

    public String getSql() {
        return this.sql;
    }

    public int getStatementType() {
        return this.statementType;
    }
}

