/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.parser;

import com.metamatrix.tools.toolshell.parser.Lexer;
import com.metamatrix.tools.toolshell.parser.TokenTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CommandIterator
implements TokenTypes {
    private static final int SCW = 0;
    private static final int SWS = 1;
    private static final int SCL = 2;
    private static final int T = 3;
    private static final int NO_ACTION = -1;
    public static final int RETURN_COMMAND_EOL = 0;
    public static final int RETURN_COMMAND_EOF = 1;
    private static final int ADD_TOKEN = 2;
    private static final int NEW_WORD = 3;
    private static final int[][][] FSM = new int[3][5][2];
    private int state = 1;
    private List commandWords = new ArrayList();
    private StringBuffer currentWord = new StringBuffer();
    private Lexer lexer;

    public CommandIterator(Lexer lexer) {
        this.lexer = lexer;
    }

    public int read() throws IOException {
        while (true) {
            int tokenType = this.lexer.nextToken();
            int[] next = FSM[this.state][tokenType];
            this.state = next[0];
            int action = next[1];
            switch (action) {
                case 0: 
                case 1: {
                    this.newWord();
                    return action;
                }
                case 2: {
                    this.addToken(this.lexer.getToken());
                    break;
                }
                case 3: {
                    this.newWord();
                }
            }
        }
    }

    private void newWord() {
        if (this.currentWord.length() > 0) {
            this.commandWords.add(this.currentWord.toString());
            this.currentWord = new StringBuffer();
        }
    }

    private void addToken(char token) {
        this.currentWord.append(token);
    }

    public List getCommandWords() {
        return this.commandWords;
    }

    public void reset() {
        this.state = 1;
        this.commandWords = new ArrayList();
        this.currentWord = new StringBuffer();
    }

    public static String wordsToString(List words) {
        return CommandIterator.wordsToString(words.iterator());
    }

    public static String wordsToString(Iterator argIter) {
        StringBuffer commandString = new StringBuffer();
        while (argIter.hasNext()) {
            commandString.append(argIter.next());
            if (!argIter.hasNext()) continue;
            commandString.append(" ");
        }
        return commandString.toString();
    }

    public static List iteratorToWords(Iterator argIter) {
        ArrayList words = new ArrayList();
        while (argIter.hasNext()) {
            words.add(argIter.next());
        }
        return words;
    }

    static {
        CommandIterator.FSM[0][0] = new int[]{3, 1};
        CommandIterator.FSM[0][1] = new int[]{1, 0};
        CommandIterator.FSM[0][3] = new int[]{0, 2};
        CommandIterator.FSM[0][2] = new int[]{1, 3};
        CommandIterator.FSM[0][4] = new int[]{2, -1};
        CommandIterator.FSM[1][0] = new int[]{3, 1};
        CommandIterator.FSM[1][1] = new int[]{1, 0};
        CommandIterator.FSM[1][3] = new int[]{0, 2};
        CommandIterator.FSM[1][2] = new int[]{1, -1};
        CommandIterator.FSM[1][4] = new int[]{2, -1};
        CommandIterator.FSM[2][0] = new int[]{3, 1};
        CommandIterator.FSM[2][1] = new int[]{1, 0};
        CommandIterator.FSM[2][3] = new int[]{2, -1};
        CommandIterator.FSM[2][2] = new int[]{2, -1};
        CommandIterator.FSM[2][4] = new int[]{2, -1};
    }
}

