/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.log;

import com.metamatrix.tools.toolshell.log.ShellLogger;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Logger
implements ShellLogger {
    private static final String ERROR = "Error:";
    private Map destinations = new HashMap();

    public Logger() {
        this.destinations.put(ShellLogger.DEST.STDOUT, null);
        this.destinations.put(ShellLogger.DEST.STDERR, null);
        this.destinations.put(ShellLogger.DEST.COMMAND, null);
        this.destinations.put(ShellLogger.DEST.LOG, null);
    }

    public void addDestination(Integer index, PrintStream out) {
        this.close(index);
        this.destinations.put(index, out);
    }

    public void log(Integer destination, String logStr) {
        PrintStream aDest = (PrintStream)this.destinations.get(destination);
        if (aDest != null) {
            aDest.print(logStr);
        }
    }

    public void logln(Integer destination, String logStr) {
        PrintStream aDest = (PrintStream)this.destinations.get(destination);
        if (aDest != null) {
            aDest.println(logStr);
        }
    }

    public void logln(Integer destination, Throwable error) {
        PrintStream aDest = (PrintStream)this.destinations.get(destination);
        if (aDest != null && error != null) {
            aDest.println(ERROR);
            error.printStackTrace(aDest);
        }
    }

    public void close(Integer destination) {
        PrintStream prev = (PrintStream)this.destinations.get(destination);
        if (prev != null) {
            prev.close();
        }
    }

    public void closeAll() {
        Iterator psItr = this.destinations.keySet().iterator();
        while (psItr.hasNext()) {
            PrintStream prev = (PrintStream)this.destinations.get(psItr.next());
            if (prev == null) continue;
            prev.close();
        }
    }

    public PrintStream getDestination(Integer destination) {
        return (PrintStream)this.destinations.get(destination);
    }
}

