/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.Command;
import com.metamatrix.tools.toolshell.ToolCommandImpl;
import com.metamatrix.tools.toolshell.ToolShell;
import com.metamatrix.tools.toolshell.parser.CommandIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HelpCommand
extends ToolCommandImpl {
    public boolean executeCommand(Iterator argIter) throws Exception {
        argIter.next();
        if (!argIter.hasNext()) {
            this.printAllCommands();
            this.printlnVerbose(ToolsPlugin.Util.getString("HelpCommand.nextSteps"));
        } else {
            this.printOneCommand(argIter);
        }
        return true;
    }

    private void printAllCommands() {
        List shellCommands = this.toolShell.getAvailableCommands();
        int maxArgLength = this.findMaxArgHelpSize(shellCommands);
        HashMap commandsByCategory = new HashMap();
        Iterator iter = shellCommands.iterator();
        while (iter.hasNext()) {
            Command command = (Command)iter.next();
            if (command.getShortHelp() == null) continue;
            String helpCategory = command.getHelpCategory();
            ArrayList<String> commands = (ArrayList<String>)commandsByCategory.get(helpCategory);
            if (commands == null) {
                commands = new ArrayList<String>();
                commandsByCategory.put(helpCategory, commands);
            }
            String line = this.formatCommandLine(command, maxArgLength);
            commands.add(line);
        }
        boolean firstCategory = true;
        Iterator categoryIter = commandsByCategory.keySet().iterator();
        while (categoryIter.hasNext()) {
            String category = (String)categoryIter.next();
            if (firstCategory) {
                firstCategory = false;
            } else {
                this.printlnVerbose("");
            }
            this.printlnVerbose(ToolsPlugin.Util.getString("HelpCommand.categoryText", (Object)category));
            List helps = (List)commandsByCategory.get(category);
            Iterator helpIter = helps.iterator();
            while (helpIter.hasNext()) {
                this.printlnVerbose((String)helpIter.next());
            }
        }
        this.printlnVerbose("");
    }

    private int findMaxArgHelpSize(Collection commands) {
        int max = 0;
        Iterator iter = commands.iterator();
        while (iter.hasNext()) {
            Command command = (Command)iter.next();
            String argHelp = command.getArgHelp();
            if (argHelp == null || argHelp.length() <= max) continue;
            max = argHelp.length();
        }
        return max;
    }

    private String formatCommandLine(Command command, int maxArgLength) {
        String tab = "  ";
        String args = command.getArgHelp();
        String description = command.getShortHelp();
        int tabSize = tab.length();
        int argSize = maxArgLength + 2;
        int descSize = 79 - argSize - tabSize;
        return tab + StringUtil.toFixedLength((String)args, (int)argSize) + StringUtil.toFixedLength((String)description, (int)descSize);
    }

    private void printOneCommand(Iterator argIter) throws Exception {
        List words = CommandIterator.iteratorToWords(argIter);
        Command command = this.toolShell.findCommand(words);
        String sHelp = command.getArgHelp();
        String lHelp = command.getLongHelp(words);
        if (sHelp != null) {
            this.printlnVerbose(sHelp);
        }
        if (lHelp != null) {
            this.printlnVerbose(ToolShell.LINE_FEED + lHelp);
        }
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("HelpCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("HelpCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("HelpCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("HelpCommand.argHelp");
    }
}

