/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.Command;
import com.metamatrix.tools.toolshell.ToolShell;
import com.metamatrix.tools.toolshell.parser.CommandIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class CommandImpl
implements Command {
    private static final String DEF_SEPARATOR = "- ";
    private static final int MAX_LEN = 79;
    protected ToolShell toolShell;

    private static boolean endsQuoted(String word) {
        return word.length() >= 1 && word.charAt(word.length() - 1) == '\"';
    }

    public static String format(String text) {
        return text.replaceAll("\n", System.getProperty("line.separator"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String formatDefinition(String text) {
        StringBuffer fmtdText = new StringBuffer();
        BufferedReader rdr = null;
        try {
            rdr = new BufferedReader(new StringReader(text));
            int indent = 0;
            String line = rdr.readLine();
            while (line != null) {
                int ndx = line.indexOf(DEF_SEPARATOR);
                if (ndx > indent) {
                    indent = ndx;
                }
                line = rdr.readLine();
            }
            rdr.close();
            int separatorLen = DEF_SEPARATOR.length();
            StringBuffer buf = new StringBuffer();
            int ndx = indent += separatorLen;
            while (--ndx >= 0) {
                buf.append(' ');
            }
            String indentText = buf.toString();
            rdr = new BufferedReader(new StringReader(text));
            String line2 = rdr.readLine();
            while (line2 != null) {
                int defNdx = line2.indexOf(DEF_SEPARATOR);
                if (defNdx > 0) {
                    fmtdText.append(line2.substring(0, defNdx));
                    int ndx2 = indent - separatorLen - defNdx;
                    while (--ndx2 >= 0) {
                        fmtdText.append(' ');
                    }
                    fmtdText.append(DEF_SEPARATOR);
                    defNdx += separatorLen;
                    int defLen = 79 - indent;
                    int lineLen = line2.length();
                    int lastDefNdx = lineLen - defLen;
                    while (lastDefNdx > defNdx) {
                        int endNdx = defNdx + defLen;
                        while (Character.isWhitespace(line2.charAt(endNdx - 1)) || !Character.isWhitespace(line2.charAt(endNdx))) {
                            --endNdx;
                        }
                        if (endNdx < defNdx) {
                            endNdx = defNdx + defLen;
                        }
                        fmtdText.append(line2.substring(defNdx, endNdx)).append('\n');
                        for (defNdx = endNdx; defNdx < lineLen && Character.isWhitespace(line2.charAt(defNdx)); ++defNdx) {
                        }
                        fmtdText.append(indentText);
                    }
                    fmtdText.append(line2.substring(defNdx)).append('\n');
                } else {
                    fmtdText.append(line2).append('\n');
                }
                line2 = rdr.readLine();
            }
        }
        catch (IOException notPossible) {
        }
        finally {
            try {
                rdr.close();
            }
            catch (IOException notPossible) {}
        }
        return CommandImpl.format(fmtdText.toString());
    }

    public static Properties getPropertiesFromArguments(Iterator argIter) {
        Properties properties = new Properties();
        List words = CommandIterator.iteratorToWords(argIter);
        for (int i = 0; i < words.size(); ++i) {
            String arg = (String)words.get(i);
            int index = arg.indexOf(61);
            if (index < 0) {
                throw new IllegalArgumentException(ToolsPlugin.Util.getString("CommandImpl.invalidArgument", (Object)arg));
            }
            String key = arg.substring(0, index).toLowerCase();
            String value = arg.substring(index + 1);
            if (CommandImpl.startsQuoted(value)) {
                if (CommandImpl.endsQuoted(value = value.substring(1))) {
                    value = value.substring(0, value.length() - 1);
                } else {
                    for (int wsIter = i + 1; wsIter < words.size(); ++wsIter) {
                        i = wsIter;
                        String quotedWord = (String)words.get(wsIter);
                        if (CommandImpl.endsQuoted(quotedWord)) {
                            value = value + " " + quotedWord.substring(0, quotedWord.length() - 1);
                            break;
                        }
                        value = value + " " + quotedWord;
                    }
                }
            }
            properties.put(key, value);
        }
        return properties;
    }

    private static boolean startsQuoted(String word) {
        return word.length() >= 1 && word.charAt(0) == '\"';
    }

    public void setToolShell(ToolShell toolShell) {
        this.toolShell = toolShell;
    }

    protected boolean getPrintResults() {
        return this.toolShell.getPrintResults();
    }

    public boolean isComplete(List commandWords) {
        return true;
    }

    protected void printHelp(String helpMsg) {
        this.toolShell.printHelp(helpMsg);
    }

    protected void printlnVerbose(String line) {
        this.toolShell.printlnVerbose(line);
    }

    protected void printVerbose(String line) {
        this.toolShell.printVerbose(line);
    }

    protected void printlnError(String error) {
        this.toolShell.printlnError(error);
    }

    protected void printlnException(Throwable e) {
        this.toolShell.printlnException(e);
    }

    protected void printlnSQLException(SQLException e) {
        this.toolShell.printlnSQLException(e);
    }

    protected void printlnProperties(Properties properties) {
        this.toolShell.printlnProperties(properties);
    }
}

