/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.sdt;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.PluginUtilImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.osgi.framework.BundleContext;

public class ModelerSdtPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.metamatrix.modeler.sdt";
    private static final String BUNDLE_NAME = "com.metamatrix.modeler.sdt.i18n";
    public static final PluginUtil Util = new PluginUtilImpl("com.metamatrix.modeler.sdt", "com.metamatrix.modeler.sdt.i18n", ResourceBundle.getBundle("com.metamatrix.modeler.sdt.i18n"));
    protected static ResourceSet globalResourceSet;
    protected static Resource builtInTypesResource;
    protected static URI BUILTIN_DATATYPES_URI;
    private static ModelerSdtPlugin plugin;
    protected URL baseURL;
    public static boolean DEBUG;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static ModelerSdtPlugin getDefault() {
        return plugin;
    }

    public static synchronized ResourceSet getGlobalResourceSet() {
        if (globalResourceSet == null) {
            globalResourceSet = ModelerSdtPlugin.createResourceSet();
            ModelerSdtPlugin.loadBuiltInTypesResource(globalResourceSet);
        }
        return globalResourceSet;
    }

    public static synchronized Resource getBuiltInTypesResource() {
        if (builtInTypesResource == null) {
            builtInTypesResource = ModelerSdtPlugin.getGlobalResourceSet().getResource(BUILTIN_DATATYPES_URI, true);
        }
        return builtInTypesResource;
    }

    protected static ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        result.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void loadBuiltInTypesResource(ResourceSet rs) {
        try {
            Resource r;
            URI uri;
            File xsdFile;
            block9: {
                String baseURL = ModelerSdtPlugin.getDefault().getBaseURL().getFile();
                File baseFolder = new File(baseURL);
                xsdFile = new File(baseFolder, "cache/www.metamatrix.com/metamodels/builtInDataTypes.xsd");
                File zipFile = new File(baseFolder, "builtInDatatypes.zip");
                uri = null;
                r = null;
                if (xsdFile.exists()) {
                    uri = URI.createFileURI((String)xsdFile.getAbsolutePath());
                    r = rs.getResource(uri, true);
                    ModelerSdtPlugin.addLogicalToPhysicalUriMapping(rs, r);
                    return;
                }
                if (!zipFile.exists()) return;
                InputStream is = null;
                try {
                    ZipFile archive = new ZipFile(zipFile);
                    ZipEntry entry = archive.getEntry("builtInDataTypes.xsd");
                    if (entry != null) {
                        is = archive.getInputStream(entry);
                        xsdFile = new File(baseURL + "builtInDataTypes.xsd");
                        FileUtils.write((InputStream)is, (File)xsdFile);
                    }
                    Object var11_13 = null;
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException ignored) {}
                is.close();
            }
            uri = URI.createFileURI((String)xsdFile.getAbsolutePath());
            r = rs.getResource(uri, true);
            ModelerSdtPlugin.addLogicalToPhysicalUriMapping(rs, r);
            return;
        }
        catch (Throwable e) {
            Object[] params = new Object[]{"builtInDataTypes.xsd", "builtInDatatypes.zip"};
            String msg = Util.getString("ModelerSdtPlugin.Error_loading_builtin_types_resource", params);
            Util.log(4, e, msg);
            e.printStackTrace();
        }
    }

    protected static void addLogicalToPhysicalUriMapping(ResourceSet rs, Resource r) {
        ArgCheck.isNotNull((Object)rs);
        ArgCheck.isNotNull((Object)r);
        if (r != null) {
            URI logicalURI = BUILTIN_DATATYPES_URI;
            URI physicalURI = r.getURI();
            rs.getURIConverter().getURIMap().put(logicalURI, physicalURI);
        } else {
            String msg = Util.getString("ModelerSdtPlugin.error_loading_builtin_types_resource_from_url", (Object)r.getURI());
            Util.log(4, msg);
        }
    }

    protected URL getBaseURL() {
        block16: {
            if (this.baseURL == null && plugin != null && plugin.getBundle() != null) {
                try {
                    this.baseURL = Platform.resolve((URL)plugin.getBundle().getEntry("/"));
                }
                catch (IOException err) {
                    this.baseURL = null;
                }
            }
            if (this.baseURL == null) {
                try {
                    Class<?> theClass = ((Object)((Object)this)).getClass();
                    URL pluginPropertiesURL = theClass.getResource("plugin.properties");
                    if (pluginPropertiesURL == null) {
                        String className = theClass.getName();
                        int index = className.lastIndexOf(".");
                        URL classURL = theClass.getResource((index == -1 ? className : className.substring(index + 1)) + ".class");
                        URI uri = URI.createURI((String)classURL.toString());
                        int count = 1;
                        int i = 0;
                        while ((i = className.indexOf(46, i)) != -1) {
                            ++count;
                            ++i;
                        }
                        if (URI.isArchiveScheme((String)(uri = uri.trimSegments(count)).scheme())) {
                            try {
                                InputStream inputStream = new URL(uri.appendSegment("plugin.properties").toString()).openStream();
                                inputStream.close();
                                this.baseURL = new URL(uri.toString());
                            }
                            catch (IOException exception) {
                                uri = URI.createURI((String)uri.authority()).trimSegments(1);
                            }
                        }
                        if (this.baseURL == null) {
                            String lastSegment = uri.lastSegment();
                            if ("bin".equals(lastSegment) || "runtime".equals(lastSegment)) {
                                uri = uri.trimSegments(1);
                            }
                            uri = uri.appendSegment("plugin.properties");
                            try {
                                InputStream inputStream = new URL(uri.toString()).openStream();
                                inputStream.close();
                                this.baseURL = new URL(uri.trimSegments(1).toString() + "/");
                            }
                            catch (IOException exception) {
                                // empty catch block
                            }
                        }
                        if (this.baseURL == null) {
                            String resourceName = index == -1 ? "plugin.properties" : className.substring(0, index + 1).replace('.', '/') + "plugin.properties";
                            throw new MissingResourceException("Missing properties: " + resourceName, theClass.getName(), "plugin.properties");
                        }
                        break block16;
                    }
                    this.baseURL = new URL(URI.createURI((String)pluginPropertiesURL.toString()).trimSegments(1).toString() + "/");
                }
                catch (IOException exception) {
                    throw new WrappedException((Exception)exception);
                }
            }
        }
        return this.baseURL;
    }

    static {
        BUILTIN_DATATYPES_URI = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
        plugin = new ModelerSdtPlugin();
        DEBUG = false;
    }
}

