/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.relational.impl.custom;

import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.RelationalFactory;
import com.metamatrix.metamodels.relational.util.RelationalTypeMapping;
import com.metamatrix.modeler.jdbc.metadata.JdbcTable;
import com.metamatrix.modeler.jdbc.relational.impl.Context;
import com.metamatrix.modeler.jdbc.relational.impl.RelationalModelProcessorImpl;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class OracleModelProcessor
extends RelationalModelProcessorImpl {
    private static final String BLOB_TYPE_NAME = "BLOB";
    private static final String CLOB_TYPE_NAME = "CLOB";
    private static final String VARCHAR2_TYPE_NAME = "VARCHAR2";
    private static final String NVARCHAR2_TYPE_NAME = "NVARCHAR2";
    private static final String TIMESTAMP_TYPE_NAME = "TIMESTAMP(";
    private static final String NUMBER_TYPE_NAME = "NUMBER";
    private static final String REF_CURSOR = "REF CURSOR";

    public OracleModelProcessor() {
    }

    public OracleModelProcessor(RelationalFactory factory) {
        super(factory);
    }

    public OracleModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
    }

    protected boolean isProcedureResultColumn(short columnType, short type, String typeName) {
        return REF_CURSOR.equals(typeName) || super.isProcedureResultColumn(columnType, type, typeName);
    }

    protected boolean includeColumnInProcedureResult(short columnType, short type, String typeName) {
        return false;
    }

    protected EObject findType(int jdbcType, String typeName, int length, int precision, int scale, List problems) {
        EObject result = null;
        if (precision != 0 && (NUMBER_TYPE_NAME.equalsIgnoreCase(typeName) || REF_CURSOR.equalsIgnoreCase(typeName))) {
            result = this.findType(precision, scale, problems);
        }
        if (result != null) {
            return result;
        }
        if (typeName.startsWith(TIMESTAMP_TYPE_NAME)) {
            result = this.findBuiltinType("timestamp", problems);
        }
        if (result != null) {
            return result;
        }
        return super.findType(jdbcType, typeName, length, precision, scale, problems);
    }

    protected EObject findType(String jdbcTypeName, List problems) {
        String standardName = jdbcTypeName;
        if (VARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName) || NVARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName)) {
            standardName = "VARCHAR";
        }
        return super.findType(standardName, problems);
    }

    protected void setColumnInfo(Column column, JdbcTable tableNode, Context context, List problems, String name, int type, String typeName, int columnSize, int numDecDigits, int numPrecRadix, int nullable, String defaultValue, int charOctetLen) {
        super.setColumnInfo(column, tableNode, context, problems, name, type, typeName, columnSize, numDecDigits, numPrecRadix, nullable, defaultValue, charOctetLen);
        if (type == 2004 || type == 2005 || BLOB_TYPE_NAME.equals(typeName) || CLOB_TYPE_NAME.equals(typeName)) {
            column.setLength(0);
        }
    }

    protected int getMaxSetSizeForModel() {
        return 1000;
    }

    protected void updateModelAnnotation(ModelAnnotation modelAnnotation) {
        super.updateModelAnnotation(modelAnnotation);
        modelAnnotation.setMaxSetSize(1000);
    }

    protected boolean checkExportedForeignKeysIfNoImportedForeignKeysFound() {
        return false;
    }

    protected boolean isFixedLength(int type, String typeName) {
        if (NVARCHAR2_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return false;
        }
        return super.isFixedLength(type, typeName);
    }
}

