/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.relational.impl;

import com.metamatrix.modeler.internal.jdbc.relational.util.JdbcRelationalUtil;
import java.util.HashMap;
import java.util.Map;

public class TableStatistics {
    private static final String DATABASE_OBJECT_NAME_SEPARATOR = ".";
    private String catalog;
    private String schema;
    private String name;
    private String fullyQualifiedName;
    private int cardinality;
    private Map columnStatistics;

    public TableStatistics(String fullName) {
        this.parseTableName(fullName);
        this.initialize();
    }

    public TableStatistics(String catalog, String schema, String fullName) {
        this(fullName);
        if (catalog != null) {
            this.catalog = catalog;
        }
        if (schema != null) {
            this.schema = schema;
        }
    }

    private void parseTableName(String fullName) {
        String[] qualifiedParts = fullName.split("\\.");
        int numParts = qualifiedParts.length;
        if (numParts > 0) {
            this.name = qualifiedParts[--numParts];
            if (numParts > 0) {
                this.schema = qualifiedParts[--numParts];
                if (numParts > 0) {
                    this.catalog = qualifiedParts[--numParts];
                }
            }
        } else {
            this.name = fullName;
        }
    }

    private void initialize() {
        this.columnStatistics = new HashMap();
    }

    public Map getColumnStats() {
        return this.columnStatistics;
    }

    public void setColumnStats(Map columnStats) {
        this.columnStatistics = columnStats;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
        this.resetFullyQualifiedName();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
        this.resetFullyQualifiedName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.resetFullyQualifiedName();
    }

    public String getFullyQualifiedEscapedName() {
        if (this.fullyQualifiedName == null) {
            String temp = "";
            if (this.getCatalog() != null) {
                temp = temp + JdbcRelationalUtil.escapeDatabaseObjectName(this.getCatalog()) + DATABASE_OBJECT_NAME_SEPARATOR;
            }
            if (this.getSchema() != null) {
                temp = temp + JdbcRelationalUtil.escapeDatabaseObjectName(this.getSchema()) + DATABASE_OBJECT_NAME_SEPARATOR;
            }
            this.fullyQualifiedName = temp = temp + JdbcRelationalUtil.escapeDatabaseObjectName(this.getName());
        }
        return this.fullyQualifiedName;
    }

    private void resetFullyQualifiedName() {
        this.fullyQualifiedName = null;
    }
}

