/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.relational;

import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.relational.CostAnalyzer;
import com.metamatrix.modeler.jdbc.relational.impl.DefaultCostAnalyzerImpl;
import com.metamatrix.modeler.jdbc.relational.impl.OracleCostAnalyzerImpl;

public class CostAnalyzerFactory {
    private static CostAnalyzerFactory costAnalyzerFactory = null;

    private CostAnalyzerFactory() {
    }

    public static CostAnalyzerFactory getCostAnalyzerFactory() {
        if (costAnalyzerFactory == null) {
            costAnalyzerFactory = new CostAnalyzerFactory();
        }
        return costAnalyzerFactory;
    }

    public CostAnalyzer getCostAnalyzer(JdbcSource src, String password) {
        String dbmsType = this.getDbmsType(src.getDriverName());
        if ("oracle".equals(dbmsType)) {
            return new OracleCostAnalyzerImpl(src, password);
        }
        return new DefaultCostAnalyzerImpl(src, password);
    }

    private String getDbmsType(String driverName) {
        if ((driverName = driverName.toLowerCase()).indexOf("oracle") > -1) {
            return "oracle";
        }
        if (driverName.indexOf("db2") > -1) {
            return "db2";
        }
        if (driverName.indexOf("sqlserver") > -1) {
            return "sqlserver";
        }
        return "";
    }

    private static class DBMS {
        public static final String ORACLE = "oracle";
        public static final String DB2 = "db2";
        public static final String SQL_SERVER = "sqlserver";

        private DBMS() {
        }
    }
}

