/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.metadata.impl;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.data.MetadataRequest;
import com.metamatrix.modeler.jdbc.data.Request;
import com.metamatrix.modeler.jdbc.metadata.JdbcCatalog;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcProcedure;
import com.metamatrix.modeler.jdbc.metadata.JdbcProcedureType;
import com.metamatrix.modeler.jdbc.metadata.JdbcSchema;
import com.metamatrix.modeler.jdbc.metadata.impl.DisabledRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetDescriptionRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.GetProcedureParametersRequest;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeImpl;
import java.sql.DatabaseMetaData;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class JdbcProcedureImpl
extends JdbcNodeImpl
implements JdbcProcedure {
    private String remarks;
    private short procType;

    public JdbcProcedureImpl(JdbcProcedureType parent, String name) {
        super(106, name, parent);
        ArgCheck.isNotNull((Object)parent);
    }

    protected JdbcNode[] computeChildren() throws JdbcException {
        return null;
    }

    public String getTypeName() {
        return this.getParent().getName();
    }

    public boolean allowsChildren() {
        return false;
    }

    protected int getDefaultSelectionMode() {
        return 1;
    }

    public String getFullyQualifiedName() {
        StringBuffer sb = new StringBuffer();
        String prefix = this.getParent().getFullyQualifiedName();
        if (prefix.length() != 0) {
            sb.append(prefix);
            sb.append(this.getQualifedNameDelimiter());
        }
        String unqualName = this.getUnqualifiedName();
        sb.append(unqualName);
        return sb.toString();
    }

    public IPath getPathInSource() {
        return this.getPathInSource(true, true);
    }

    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        JdbcNode parent = this.getParent();
        while (!(parent instanceof JdbcSchema && includeSchema || parent instanceof JdbcCatalog && includeCatalog || parent instanceof JdbcDatabase)) {
            parent = parent.getParent();
        }
        if (parent instanceof JdbcDatabase) {
            return new Path(this.getName());
        }
        return parent.getPathInSource().append(this.getName());
    }

    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        JdbcNode parent;
        for (parent = this.getParent(); !(parent == null || parent instanceof JdbcSchema && includeSchema || parent instanceof JdbcCatalog && includeCatalog || parent instanceof JdbcDatabase); parent = parent.getParent()) {
        }
        if (parent != null && parent.isDatabaseObject()) {
            return parent;
        }
        return null;
    }

    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public short getProcedureType() {
        return this.procType;
    }

    public void setProcedureType(short type) {
        ArgCheck.isTrue((type == 0 || type == 2 || type == 1 ? 1 : 0) != 0, (String)JdbcPlugin.Util.getString("JdbcProcedureImpl.Invalid_procedure_type"));
        this.procType = type;
    }

    protected Request[] createRequests() throws JdbcException {
        DatabaseMetaData metadata = this.getJdbcDatabase().getDatabaseMetaData();
        String catalogNamePattern = JdbcNodeImpl.getCatalogPattern(this);
        String schemaNamePattern = JdbcNodeImpl.getSchemaPattern(this);
        String procedureNamePattern = this.getName();
        String procedureColumnNamePattern = "%";
        Request[] requests = new Request[]{new GetProcedureParametersRequest(metadata, catalogNamePattern, schemaNamePattern, procedureNamePattern, "%"), new GetDescriptionRequest(this, "getRemarks")};
        if (!this.getJdbcDatabase().getIncludes().includeProcedures()) {
            requests[1] = new DisabledRequest((MetadataRequest)requests[1]);
        }
        return requests;
    }
}

