/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.metadata.impl;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.metadata.JdbcCatalog;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcProcedureTypeImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcSchemaImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcTableTypeImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;

public class JdbcCatalogImpl
extends JdbcNodeImpl
implements JdbcCatalog {
    public JdbcCatalogImpl(JdbcNode parent, String name) {
        super(102, name, parent);
        ArgCheck.isNotNull((Object)parent);
    }

    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JdbcNode[] computeChildren() throws JdbcException {
        block21: {
            metadata = this.getJdbcDatabase().getDatabaseMetaData();
            children = new ArrayList<JdbcNodeImpl>();
            database = this.getJdbcDatabase();
            capabilities = database.getCapabilities();
            supportsSchemas = false;
            try {
                supportsSchemas = capabilities.supportsSchemas();
            }
            catch (Throwable t) {
                params = new Object[]{database.getConnection()};
                msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_discovering_support_for_schemas", params);
                JdbcPlugin.Util.log(2, t, msg);
            }
            if (!supportsSchemas) break block21;
            resultSet = null;
            try {
                resultSet = metadata.getSchemas();
                while (resultSet.next()) {
                    catalogName = resultSet.getString(1);
                    children.add(new JdbcSchemaImpl(this, catalogName));
                }
                var11_15 = null;
                if (resultSet == null) break block21;
                ** GOTO lbl61
            }
            catch (UnsupportedOperationException e) {
                supportsSchemas = false;
                var11_15 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        JdbcPlugin.Util.log((Throwable)e);
                    }
                }
                break block21;
            }
            catch (Throwable t) {
                params = new Object[]{metadata.getClass().getName(), database.getConnection()};
                msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_calling_getSchemas()_and_processing_results", params);
                JdbcPlugin.Util.log(2, t, msg);
                supportsSchemas = false;
                var11_15 = null;
                if (resultSet != null) {
                    ** try [egrp 3[TRYBLOCK] [7 : 241->251)] { 
lbl46:
                    // 1 sources

                    resultSet.close();
lbl48:
                    // 1 sources

                    catch (SQLException e) {
                        JdbcPlugin.Util.log((Throwable)e);
                    }
                }
                break block21;
            }
            {
                catch (Throwable var10_20) {
                    var11_16 = null;
                    if (resultSet == null) throw var10_20;
                    ** try [egrp 3[TRYBLOCK] [7 : 241->251)] { 
lbl56:
                    // 1 sources

                    resultSet.close();
                    throw var10_20;
lbl58:
                    // 1 sources

                    catch (SQLException e) {
                        JdbcPlugin.Util.log((Throwable)e);
                    }
                    throw var10_20;
                }
lbl61:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [7 : 241->251)] { 
lbl62:
                // 1 sources

                resultSet.close();
lbl64:
                // 1 sources

                catch (SQLException e) {}
                JdbcPlugin.Util.log((Throwable)e);
            }
        }
        if (supportsSchemas != false) return children.toArray(new JdbcNode[children.size()]);
        try {
            tableTypes = database.getIncludes().getIncludedTableTypes();
            if (tableTypes == null) {
                tableTypes = database.getCapabilities().getTableTypes();
            }
            for (i = 0; i < tableTypes.length; ++i) {
                children.add(new JdbcTableTypeImpl(this, tableTypes[i]));
            }
        }
        catch (Throwable t) {
            params = new Object[]{metadata.getClass().getName(), database};
            msg = JdbcPlugin.Util.getString("JdbcCatalogImpl.Unexpected_exception_while_calling_getTableTypes()_and_processing_results", params);
            JdbcPlugin.Util.log(2, t, msg);
        }
        if (database.getIncludes().includeProcedures() == false) return children.toArray(new JdbcNode[children.size()]);
        procTerm = null;
        try {
            procTerm = database.getCapabilities().getProcedureTerm();
        }
        catch (Throwable t) {
            procTerm = JdbcPlugin.Util.getString("JdbcCatalogImpl.ProcedureTypeName");
        }
        children.add(new JdbcProcedureTypeImpl(this, procTerm));
        return children.toArray(new JdbcNode[children.size()]);
    }

    public String getTypeName() {
        try {
            return this.getJdbcDatabase().getCapabilities().getCatalogTerm();
        }
        catch (Throwable t) {
            return JdbcPlugin.Util.getString("JdbcCatalogImpl.CatalogTypeName");
        }
    }

    public String getFullyQualifiedName() {
        boolean includeCatalogs = false;
        try {
            includeCatalogs = this.getJdbcDatabase().getCapabilities().supportsCatalogsInDataManipulation();
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (includeCatalogs) {
            return this.getUnqualifiedName();
        }
        return "";
    }

    public IPath getPathInSource() {
        return this.getPath();
    }

    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        if (includeCatalog) {
            return this.getPath();
        }
        return null;
    }

    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        return null;
    }
}

