/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.data;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResultsMetadata {
    public static final int NULLABLE_UNKNOWN = 2;
    public static final int NULLABLE = 1;
    public static final int NOT_NULLABLE = 0;
    private List columnMetadata = new ArrayList();

    protected ResultsMetadata() {
    }

    protected void set(ResultSetMetaData rsMetadata) throws SQLException {
        int numColumns = rsMetadata.getColumnCount();
        for (int i = 1; i <= numColumns; ++i) {
            ColumnMetadata m = new ColumnMetadata();
            m.setCatalogName(rsMetadata.getCatalogName(i));
            m.setClassName(rsMetadata.getColumnClassName(i));
            m.setDisplaySize(rsMetadata.getColumnDisplaySize(i));
            m.setLabel(rsMetadata.getColumnLabel(i));
            m.setName(rsMetadata.getColumnName(i));
            m.setNullable(rsMetadata.isNullable(i));
            m.setPrecision(rsMetadata.getPrecision(i));
            m.setScale(rsMetadata.getScale(i));
            m.setSchemaName(rsMetadata.getSchemaName(i));
            m.setTableName(rsMetadata.getTableName(i));
            m.setType(rsMetadata.getColumnType(i));
            m.setAutoIncrement(rsMetadata.isAutoIncrement(i));
            m.setCaseSensitive(rsMetadata.isCaseSensitive(i));
            m.setCurrency(rsMetadata.isCurrency(i));
            m.setDefinitelyWritable(rsMetadata.isDefinitelyWritable(i));
            m.setReadOnly(rsMetadata.isReadOnly(i));
            m.setSearchable(rsMetadata.isSearchable(i));
            m.setSigned(rsMetadata.isSigned(i));
            m.setWritable(rsMetadata.isWritable(i));
            this.columnMetadata.add(m);
        }
        this.columnMetadata = Collections.unmodifiableList(this.columnMetadata);
    }

    protected void set(String catalogName, String schemaName, String tableName, Object objectValue) throws SQLException {
        int length = objectValue.toString().length();
        ColumnMetadata m = new ColumnMetadata();
        m.setCatalogName(catalogName);
        m.setClassName(objectValue.getClass().getName());
        m.setDisplaySize(length);
        m.setLabel("");
        m.setName(m.getLabel());
        m.setNullable(0);
        m.setPrecision(length);
        m.setScale(0);
        m.setSchemaName(schemaName);
        m.setTableName(tableName);
        m.setAutoIncrement(false);
        m.setCaseSensitive(false);
        m.setCurrency(false);
        m.setDefinitelyWritable(false);
        m.setReadOnly(true);
        m.setSearchable(false);
        m.setSigned(false);
        m.setWritable(false);
        if (objectValue instanceof Integer) {
            m.setType(4);
        } else if (objectValue instanceof Long) {
            m.setType(2);
        } else if (objectValue instanceof Short) {
            m.setType(5);
        } else if (objectValue instanceof Double) {
            m.setType(8);
        } else if (objectValue instanceof Float) {
            m.setType(6);
        } else if (objectValue instanceof Boolean) {
            m.setType(-7);
        } else if (objectValue instanceof String) {
            m.setType(12);
        } else {
            m.setType(12);
        }
        this.columnMetadata.add(this.columnMetadata);
        this.columnMetadata = Collections.unmodifiableList(this.columnMetadata);
    }

    public List getColumnMetadata() {
        return this.columnMetadata;
    }

    public ColumnMetadata getColumnMetadata(int columnIndex) {
        return (ColumnMetadata)this.columnMetadata.get(columnIndex);
    }

    public static ResultsMetadata create(ResultSetMetaData rsMetadata) throws SQLException {
        ResultsMetadata metadata = new ResultsMetadata();
        metadata.set(rsMetadata);
        return metadata;
    }

    public static ResultsMetadata create(String catalogName, String schemaName, String tableName, Object objectValue) throws SQLException {
        ResultsMetadata metadata = new ResultsMetadata();
        metadata.set(catalogName, schemaName, tableName, objectValue);
        return metadata;
    }

    public class ColumnMetadata {
        private String name;
        private String label;
        private int type;
        private String typeName;
        private String className;
        private int displaySize;
        private int precision;
        private int scale;
        private String tableName;
        private String schemaName;
        private String catalogName;
        private boolean autoIncrement;
        private boolean caseSensitive;
        private boolean currency;
        private boolean definitelyWritable;
        private int nullable;
        private boolean readOnly;
        private boolean searchable;
        private boolean signed;
        private boolean writable;

        protected ColumnMetadata() {
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public String getCatalogName() {
            return this.catalogName;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isCurrency() {
            return this.currency;
        }

        public boolean isDefinitelyWritable() {
            return this.definitelyWritable;
        }

        public int getDisplaySize() {
            return this.displaySize;
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.name;
        }

        public int getNullable() {
            return this.nullable;
        }

        public int getPrecision() {
            return this.precision;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public int getScale() {
            return this.scale;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public boolean isSearchable() {
            return this.searchable;
        }

        public boolean isSigned() {
            return this.signed;
        }

        public String getTableName() {
            return this.tableName;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isWritable() {
            return this.writable;
        }

        protected void setAutoIncrement(boolean b) {
            this.autoIncrement = b;
        }

        protected void setCaseSensitive(boolean b) {
            this.caseSensitive = b;
        }

        protected void setCatalogName(String string) {
            this.catalogName = string;
        }

        protected void setClassName(String string) {
            this.className = string;
        }

        protected void setCurrency(boolean b) {
            this.currency = b;
        }

        protected void setDefinitelyWritable(boolean b) {
            this.definitelyWritable = b;
        }

        protected void setDisplaySize(int i) {
            this.displaySize = i;
        }

        protected void setLabel(String string) {
            this.label = string;
        }

        protected void setName(String string) {
            this.name = string;
        }

        protected void setNullable(int i) {
            this.nullable = i;
        }

        protected void setPrecision(int i) {
            this.precision = i;
        }

        protected void setReadOnly(boolean b) {
            this.readOnly = b;
        }

        protected void setScale(int i) {
            this.scale = i;
        }

        protected void setSchemaName(String string) {
            this.schemaName = string;
        }

        protected void setSearchable(boolean b) {
            this.searchable = b;
        }

        protected void setSigned(boolean b) {
            this.signed = b;
        }

        protected void setTableName(String string) {
            this.tableName = string;
        }

        protected void setType(int i) {
            this.type = i;
        }

        protected void setTypeName(String string) {
            this.typeName = string;
        }

        protected void setWritable(boolean b) {
            this.writable = b;
        }
    }
}

