/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.data;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.internal.jdbc.JdbcUtil;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.data.Request;
import com.metamatrix.modeler.jdbc.data.Response;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;

public class QueryRequest
extends Request {
    private final String sql;

    public QueryRequest(String name, Connection connection, String sql) {
        super(name, connection);
        ArgCheck.isNotNull((Object)sql);
        ArgCheck.isNotZeroLength((String)sql);
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected IStatus performInvocation(Response results) {
        ArrayList<IStatus> statuses;
        Connection conn;
        block41: {
            SQLException e3222;
            ResultSet resultSet;
            Statement statement;
            block39: {
                conn = (Connection)this.getTarget();
                statuses = new ArrayList<IStatus>();
                statement = null;
                resultSet = null;
                statement = conn.createStatement();
                boolean isResultSet = statement.execute(this.sql);
                if (isResultSet) {
                    resultSet = statement.getResultSet();
                    Response.addResults(results, resultSet, this.isMetadataRequested());
                } else {
                    try {
                        int updateCount = statement.getUpdateCount();
                        Integer value = new Integer(updateCount);
                        Response.addResults(results, value, true);
                    }
                    catch (SQLException e2) {
                        statuses.add(JdbcUtil.createIStatus(e2));
                    }
                }
                for (SQLWarning warning = statement.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    statuses.add(JdbcUtil.createIStatus(warning));
                }
                Object var10_14 = null;
                if (resultSet == null) break block39;
                try {
                    resultSet.close();
                }
                catch (SQLException e3222) {
                    statuses.add(JdbcUtil.createIStatus(e3222));
                }
                finally {
                    resultSet = null;
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e3222) {
                    statuses.add(JdbcUtil.createIStatus(e3222));
                }
                finally {
                    statement = null;
                }
            }
            break block41;
            {
                catch (SQLException e4) {
                    SQLException e3222;
                    statuses.add(JdbcUtil.createIStatus(e4));
                    Object var10_15 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                            resultSet = null;
                        }
                        catch (SQLException e3222) {
                            try {}
                            catch (Throwable throwable) {
                                resultSet = null;
                                throw throwable;
                            }
                            statuses.add(JdbcUtil.createIStatus(e3222));
                            resultSet = null;
                        }
                    }
                    if (statement == null) break block41;
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e3222) {
                        try {}
                        catch (Throwable throwable) {
                            statement = null;
                            throw throwable;
                        }
                        statuses.add(JdbcUtil.createIStatus(e3222));
                        statement = null;
                        break block41;
                    }
                }
                catch (Throwable e5) {
                    SQLException e3222;
                    statuses.add(JdbcUtil.createIStatus(e5));
                    Object var10_16 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                            resultSet = null;
                        }
                        catch (SQLException e3222) {
                            try {}
                            catch (Throwable throwable) {
                                resultSet = null;
                                throw throwable;
                            }
                            statuses.add(JdbcUtil.createIStatus(e3222));
                            resultSet = null;
                        }
                    }
                    if (statement == null) break block41;
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e3222) {
                        try {}
                        catch (Throwable throwable) {
                            statement = null;
                            throw throwable;
                        }
                        statuses.add(JdbcUtil.createIStatus(e3222));
                        statement = null;
                        break block41;
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException e3222;
                Object var10_17 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                        resultSet = null;
                    }
                    catch (SQLException e3222) {
                        try {}
                        catch (Throwable throwable2) {
                            resultSet = null;
                            throw throwable2;
                        }
                        statuses.add(JdbcUtil.createIStatus(e3222));
                        resultSet = null;
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException e3222) {
                        try {}
                        catch (Throwable throwable3) {
                            statement = null;
                            throw throwable3;
                        }
                        statuses.add(JdbcUtil.createIStatus(e3222));
                        statement = null;
                    }
                }
                throw throwable;
            }
        }
        if (statuses.size() == 1) {
            return (IStatus)statuses.get(0);
        }
        if (statuses.size() > 1) {
            String text = JdbcPlugin.Util.getString("QueryRequest.Error_while_processing_sql_against_connection", (Object)this.sql, (Object)conn);
            return JdbcUtil.createIStatus(statuses, text);
        }
        return null;
    }
}

