/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.custom;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.jdbc.custom.ResultSetImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelDatabaseMetaDataHandler
implements InvocationHandler {
    private static List COLUMN_DESCRIPTIONS = new ArrayList();
    private static ResultSet EMPTY_RESULTSET;
    private DatabaseMetaData metadata;
    private File excelFile;
    protected ResultSet tables;
    protected Map columns = new HashMap();

    protected ExcelDatabaseMetaDataHandler(DatabaseMetaData metadata, File excelFile) throws SQLException {
        ArgCheck.isNotNull((Object)excelFile);
        this.metadata = metadata;
        this.excelFile = excelFile;
        this.loadExcelDocument();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getColumns")) {
            ResultSet results = (ResultSet)this.columns.get(((String)args[2]).toUpperCase());
            if (results == null) {
                results = EMPTY_RESULTSET;
            }
            ((ResultSetImpl)results).reset();
            return results;
        }
        if (methodName.equals("getTables")) {
            return this.tables;
        }
        if (methodName.equals("getTableTypes")) {
            ArrayList types = new ArrayList();
            ArrayList<String> row = new ArrayList<String>();
            row.add("TABLE");
            types.add(row);
            ArrayList<String> columnNames = new ArrayList<String>(1);
            columnNames.add("TABLE_TYPE");
            return new ResultSetImpl(types, columnNames);
        }
        if (methodName.equals("supportsCatalogsInDataManipulation")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsCatalogsInIndexDefinitions")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsCatalogsInDataManipulation")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsCatalogsInPrivilegeDefinitions")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsCatalogsInProcedureCalls")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsCatalogsInTableDefinitions")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsSchemasInDataManipulation")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsSchemasInIndexDefinitions")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsSchemasInPrivilegeDefinitions")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsSchemasInProcedureCalls")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("supportsSchemasInTableDefinitions")) {
            return Boolean.FALSE;
        }
        if (methodName.equals("getPrimaryKeys")) {
            return EMPTY_RESULTSET;
        }
        if (methodName.equals("getImportedKeys")) {
            return EMPTY_RESULTSET;
        }
        if (methodName.equals("getExportedKeys")) {
            return EMPTY_RESULTSET;
        }
        return method.invoke((Object)this.metadata, args);
    }

    protected void loadExcelDocument() throws SQLException {
        try {
            POIFSFileSystem pfs = new POIFSFileSystem(new FileInputStream(this.excelFile));
            HSSFWorkbook workBook = new HSSFWorkbook(pfs);
            int sheetNumber = workBook.getNumberOfSheets();
            if (sheetNumber == 0) {
                return;
            }
            ArrayList<List<Object>> tables = new ArrayList<List<Object>>();
            for (int i = 0; i < sheetNumber; ++i) {
                HSSFSheet sheet = workBook.getSheetAt(i);
                String tableName = workBook.getSheetName(i);
                int firstRowNumber = sheet.getFirstRowNum();
                HSSFRow firstRow = sheet.getRow(firstRowNumber);
                HSSFRow firstDataRow = sheet.getRow(firstRowNumber + 1);
                if (firstRow == null) continue;
                short firstCell = firstRow.getFirstCellNum();
                short lastCell = firstRow.getLastCellNum();
                ArrayList<List<Object>> columns = new ArrayList<List<Object>>();
                for (short j = firstCell; j < lastCell; j = (short)(j + 1)) {
                    HSSFCell cell = firstRow.getCell(j);
                    Object[] cellType = this.getCellType(firstDataRow, j, sheet);
                    columns.add(Arrays.asList(null, null, tableName, cell.getStringCellValue(), cellType[0], cellType[1], null, null, null, null, new Integer(1), null, null, null, null, null, null, "YES", null, null, null, null));
                }
                tables.add(Arrays.asList(null, null, tableName, "TABLE", "Excel_Sheet", null, null, null, null, null));
                this.columns.put(tableName.toUpperCase(), new ResultSetImpl(columns, COLUMN_DESCRIPTIONS));
            }
            this.tables = new ResultSetImpl(tables, COLUMN_DESCRIPTIONS);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe.getMessage());
        }
    }

    private Object[] getCellType(HSSFRow firstDataRow, short cellIndex, HSSFSheet sheet) {
        if (firstDataRow != null) {
            HSSFCell cell = firstDataRow.getCell(cellIndex);
            if (cell == null) {
                HSSFRow row;
                int dataRowNumber = firstDataRow.getRowNum();
                while (cell == null && (row = sheet.getRow(++dataRowNumber)) != null) {
                    cell = row.getCell(cellIndex);
                }
            }
            if (cell != null) {
                int celltype = cell.getCellType();
                switch (celltype) {
                    case 4: {
                        return new Object[]{new Integer(16), "BOOLEAN"};
                    }
                    case 0: {
                        if (HSSFDateUtil.isCellDateFormatted(firstDataRow.getCell(cellIndex))) {
                            return new Object[]{new Integer(91), "DATE"};
                        }
                        return new Object[]{new Integer(8), "DOUBLE"};
                    }
                }
            }
        }
        return new Object[]{new Integer(12), "VARCHAR2"};
    }

    static {
        COLUMN_DESCRIPTIONS.add("TABLE_CAT");
        COLUMN_DESCRIPTIONS.add("TABLE_SCHEM");
        COLUMN_DESCRIPTIONS.add("TABLE_NAME ");
        COLUMN_DESCRIPTIONS.add("COLUMN_NAME ");
        COLUMN_DESCRIPTIONS.add("DATA_TYPE ");
        COLUMN_DESCRIPTIONS.add("TYPE_NAME ");
        COLUMN_DESCRIPTIONS.add("COLUMN_SIZE ");
        COLUMN_DESCRIPTIONS.add("BUFFER_LENGTH ");
        COLUMN_DESCRIPTIONS.add("DECIMAL_DIGITS ");
        COLUMN_DESCRIPTIONS.add("NUM_PREC_RADIX ");
        COLUMN_DESCRIPTIONS.add("NULLABLE ");
        COLUMN_DESCRIPTIONS.add("REMARKS");
        COLUMN_DESCRIPTIONS.add("COLUMN_DEF");
        COLUMN_DESCRIPTIONS.add("SQL_DATA_TYPE");
        COLUMN_DESCRIPTIONS.add("SQL_DATETIME_SUB");
        COLUMN_DESCRIPTIONS.add("CHAR_OCTET_LENGTH");
        COLUMN_DESCRIPTIONS.add("ORDINAL_POSITION");
        COLUMN_DESCRIPTIONS.add("IS_NULLABLE");
        COLUMN_DESCRIPTIONS.add("SCOPE_CATLOG");
        COLUMN_DESCRIPTIONS.add("SCOPE_SCHEMA");
        COLUMN_DESCRIPTIONS.add("SCOPE_TABLE");
        COLUMN_DESCRIPTIONS.add("SOURCE_DATA_TYPE");
        EMPTY_RESULTSET = new ResultSetImpl(Collections.EMPTY_LIST, COLUMN_DESCRIPTIONS);
    }
}

