/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.mapping.factory;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.transformation.FragmentMappingRoot;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.MappingClassColumn;
import com.metamatrix.metamodels.transformation.StagingTable;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TreeMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.internal.mapping.factory.FragmentMappingAdapter;
import com.metamatrix.modeler.internal.mapping.factory.MappingList;
import com.metamatrix.modeler.internal.mapping.factory.ModelMapperFactory;
import com.metamatrix.modeler.mapping.PluginConstants;
import com.metamatrix.modeler.mapping.factory.IMappableTree;
import com.metamatrix.modeler.mapping.factory.ITreeToRelationalMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;

public class TreeMappingAdapter
implements PluginConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$mapping$factory$TreeMappingAdapter == null ? (class$com$metamatrix$modeler$internal$mapping$factory$TreeMappingAdapter = TreeMappingAdapter.class$("com.metamatrix.modeler.internal.mapping.factory.TreeMappingAdapter")) : class$com$metamatrix$modeler$internal$mapping$factory$TreeMappingAdapter));
    private FragmentMappingAdapter fragmentAdapter;
    private List mappingRoots;
    private List mappingClasses;
    private HashMap mappingClassLocationMap = new HashMap();
    private HashMap locationToMappingClassMap = new HashMap();
    private HashMap stagingTableLocationMap = new HashMap();
    private HashMap treeNodesToMappingClassColumnsMap = new HashMap();
    private HashMap treeNodesToMappingClassScopeMap = new HashMap();
    private ITreeToRelationalMapper mapper;
    private EObject root;
    private ModelContents modelContents;
    private List stagingTables;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$mapping$factory$TreeMappingAdapter;

    public TreeMappingAdapter(EObject theTreeRoot) {
        ArgCheck.isNotNull((Object)theTreeRoot);
        this.root = theTreeRoot;
        this.modelContents = ModelerCore.getModelEditor().getModelContents(this.root);
        this.mappingClasses = new ArrayList();
        this.stagingTables = new ArrayList();
        if (this.modelContents != null) {
            ArrayList<MappingRoot> fragmentRoots = new ArrayList<MappingRoot>();
            this.mappingRoots = this.modelContents.getTransformations(theTreeRoot);
            if (this.mappingRoots == null || this.mappingRoots.isEmpty()) {
                this.mappingRoots = new ArrayList();
            } else {
                int size = this.mappingRoots.size();
                for (int i = 0; i < size; ++i) {
                    MappingRoot mappingRoot = (MappingRoot)this.mappingRoots.get(i);
                    Iterator outputIter = mappingRoot.getOutputs().iterator();
                    if (mappingRoot instanceof TreeMappingRoot) {
                        MappingClass mappingClass = this.getMappingClass(mappingRoot);
                        if (mappingClass instanceof StagingTable) {
                            this.mappingClasses.add(null);
                            this.stagingTables.add(mappingClass);
                            while (outputIter.hasNext()) {
                                Object oTreeNode = outputIter.next();
                                this.stagingTableLocationMap.put(oTreeNode, mappingClass);
                            }
                            continue;
                        }
                        this.mappingClasses.add(mappingClass);
                        this.stagingTables.add(null);
                        while (outputIter.hasNext()) {
                            Object oTemp = outputIter.next();
                            this.mappingClassLocationMap.put(oTemp, mappingClass);
                            this.locationToMappingClassMap.put(mappingClass, oTemp);
                        }
                        continue;
                    }
                    if (!(mappingRoot instanceof FragmentMappingRoot)) continue;
                    fragmentRoots.add(mappingRoot);
                    this.mappingClasses.add(null);
                    this.stagingTables.add(null);
                }
            }
            this.fragmentAdapter = new FragmentMappingAdapter(this.root, fragmentRoots);
            this.mapper = ModelMapperFactory.createModelMapper(theTreeRoot);
            this.getTreeNodesToMappingClassColumnsMap(true);
            this.getTreeNodesToMappingClassScopeMap(true);
        }
    }

    public void addLocation(MappingClass theMappingClass, EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theMappingClass);
        ArgCheck.isNotNull((Object)theTreeNode);
        MappingList currentLocations = this.getMappingList(theMappingClass);
        if (currentLocations != null) {
            if (!currentLocations.contains(theTreeNode)) {
                try {
                    ModelerCore.getModelEditor().addValue((Object)currentLocations.mapping, (Object)theTreeNode, currentLocations.list);
                    this.mappingClassLocationMap.put(theTreeNode, theMappingClass);
                    this.locationToMappingClassMap.put(theMappingClass, theTreeNode);
                    this.addEntryToTreeNodesToMappingClassScopeMap(theMappingClass);
                }
                catch (Exception e) {
                    PluginConstants.Util.log(4, (Throwable)e, e.getMessage());
                }
            } else {
                PluginConstants.Util.log(2, PluginConstants.Util.getString(PREFIX + "duplicateMapping", new Object[]{"addLocation", "MappingClass", theMappingClass, theTreeNode}));
            }
        } else {
            PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "mappingRootsProblem", new Object[]{"addLocation", "MappingClass", theMappingClass, theTreeNode}));
        }
    }

    public void addLocation(MappingClassColumn theMappingColumn, EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theMappingColumn);
        ArgCheck.isNotNull((Object)theTreeNode);
        MappingList currentLocations = this.getMappingList(theMappingColumn);
        if (currentLocations != null) {
            if (!currentLocations.list.contains((Object)theTreeNode)) {
                try {
                    ModelerCore.getModelEditor().addValue((Object)currentLocations.mapping, (Object)theTreeNode, currentLocations.list);
                    this.treeNodesToMappingClassColumnsMap.put(theTreeNode, theMappingColumn);
                }
                catch (Exception e) {
                    PluginConstants.Util.log(4, (Throwable)e, e.getMessage());
                }
            } else {
                PluginConstants.Util.log(2, PluginConstants.Util.getString(PREFIX + "duplicateMapping", new Object[]{"addLocation", "MappingClassColumn", theMappingColumn, theTreeNode}));
            }
        } else {
            PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "mappingRootsProblem", new Object[]{"addLocation", "MappingClass", theMappingColumn, theTreeNode}));
        }
    }

    private Mapping createColumnMapping(MappingRoot theMappingRoot, MappingClassColumn theMappingColumn) {
        ArgCheck.isNotNull((Object)theMappingRoot);
        ArgCheck.isNotNull((Object)theMappingColumn);
        Mapping mapping = theMappingRoot.createMapping(Collections.singletonList(theMappingColumn), (Collection)Collections.EMPTY_LIST);
        theMappingRoot.getNested().add((Object)mapping);
        return mapping;
    }

    private int createMappingRoot(MappingClass theMappingClass) {
        ArgCheck.isNotNull((Object)theMappingClass);
        int result = -1;
        if (this.modelContents != null) {
            try {
                TreeMappingRoot newRoot = ModelResourceContainerFactory.createNewTreeMappingRoot((EObject)this.root, (Resource)this.root.eResource());
                ModelerCore.getModelEditor().addValue((Object)newRoot, (Object)theMappingClass, newRoot.getInputs());
                this.mappingRoots.add(newRoot);
                this.mappingClasses.add(theMappingClass);
                this.stagingTables.add(null);
                result = this.mappingRoots.size() - 1;
            }
            catch (Exception theException) {
                PluginConstants.Util.log(4, (Throwable)theException, PluginConstants.Util.getString(PREFIX + "createMappingRootProblem", new Object[]{this.root, theMappingClass}));
            }
        }
        return result;
    }

    public List getAllMappingClasses() {
        ArrayList result = new ArrayList(this.mappingClasses.size());
        Iterator iter = this.mappingClasses.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) continue;
            result.add(o);
        }
        return Collections.unmodifiableList(result);
    }

    public List getAllStagingTables() {
        ArrayList result = new ArrayList(this.stagingTables.size());
        Iterator iter = this.stagingTables.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) continue;
            result.add(o);
        }
        return Collections.unmodifiableList(result);
    }

    public FragmentMappingAdapter getFragmentMappingAdapter() {
        return this.fragmentAdapter;
    }

    private MappingList getMappingList(StagingTable theStagingTable) {
        ArgCheck.isNotNull((Object)theStagingTable);
        MappingList result = null;
        int index = this.stagingTables.indexOf(theStagingTable);
        if (index != -1) {
            MappingRoot mappingRoot = (MappingRoot)this.mappingRoots.get(index);
            result = new MappingList((Mapping)mappingRoot, mappingRoot.getOutputs());
            if (result.list.size() > 1) {
                PluginConstants.Util.log(2, PluginConstants.Util.getString(PREFIX + "invalidStagingTableLocationSize", new Object[]{theStagingTable, new Integer(result.list.size()), "getLocation(StagingTable)"}));
            }
        } else {
            PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "noTreeNodeForStagingTable", new Object[]{theStagingTable}));
        }
        return result;
    }

    public EObject getLocation(StagingTable theStagingTable) {
        MappingList list = this.getMappingList(theStagingTable);
        if (list != null && list.list.size() == 1) {
            return (EObject)list.list.get(0);
        }
        return null;
    }

    public List getLocations(MappingClass theMappingClass) {
        MappingList result = this.getMappingList(theMappingClass);
        return result == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(result.list);
    }

    private MappingList getMappingList(MappingClass theMappingClass) {
        ArgCheck.isNotNull((Object)theMappingClass);
        MappingList result = null;
        int index = -1;
        if (index == -1) {
            index = this.mappingClasses.indexOf(theMappingClass);
        }
        if (index == -1) {
            Resource resource;
            if (this.stagingTables != null) {
                index = this.stagingTables.indexOf(theMappingClass);
            }
            if (index == -1 && (resource = theMappingClass.eResource()) != null) {
                index = this.createMappingRoot(theMappingClass);
            }
        }
        if (index != -1) {
            MappingRoot mappingRoot = (MappingRoot)this.mappingRoots.get(index);
            result = new MappingList((Mapping)mappingRoot, mappingRoot.getOutputs());
        }
        return result;
    }

    public List getLocations(MappingClassColumn theMappingColumn) {
        MappingList result = this.getMappingList(theMappingColumn);
        return result == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(result.list);
    }

    private MappingList getMappingList(MappingClassColumn theMappingColumn) {
        ArgCheck.isNotNull((Object)theMappingColumn);
        MappingList result = null;
        MappingClass mappingClass = theMappingColumn.getMappingClass();
        int index = -1;
        if (index == -1) {
            index = this.mappingClasses.indexOf(mappingClass);
        }
        if (index != -1) {
            MappingRoot mappingRoot = (MappingRoot)this.mappingRoots.get(index);
            EList columnMappings = mappingRoot.getNested();
            if (!columnMappings.isEmpty()) {
                int size = columnMappings.size();
                for (int i = 0; i < size; ++i) {
                    Mapping mapping = (Mapping)columnMappings.get(i);
                    EList columns = mapping.getInputs();
                    HashMap columnsMap = this.simpleListToMap((List)columns);
                    if (columnsMap.get(theMappingColumn) == null) continue;
                    result = new MappingList(mapping, mapping.getOutputs());
                    break;
                }
            }
            if (result == null) {
                Mapping newMapping = this.createColumnMapping(mappingRoot, theMappingColumn);
                result = new MappingList(newMapping, newMapping.getOutputs());
            }
        }
        return result;
    }

    private MappingClass getMappingClass(MappingRoot theMappingRoot) {
        ArgCheck.isNotNull((Object)theMappingRoot);
        MappingClass result = null;
        EList inputs = theMappingRoot.getInputs();
        int size = inputs.size();
        if (size > 0) {
            result = (MappingClass)inputs.get(0);
            if (size > 1) {
                PluginConstants.Util.log(2, PluginConstants.Util.getString(PREFIX + "multipleMappingClassesAtRoot", new Object[]{theMappingRoot, new Integer(size)}));
            }
        }
        return result;
    }

    public StagingTable getStagingTable(EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theTreeNode);
        StagingTable st = (StagingTable)this.stagingTableLocationMap.get(theTreeNode);
        return st;
    }

    public EObject getLocation(MappingClass theMappingClass) {
        ArgCheck.isNotNull((Object)theMappingClass);
        return (EObject)this.locationToMappingClassMap.get(theMappingClass);
    }

    public MappingClass getMappingClass(EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theTreeNode);
        return (MappingClass)this.mappingClassLocationMap.get(theTreeNode);
    }

    public MappingClassColumn getMappingClassColumn(EObject theTreeNode, MappingClass theMappingClass) {
        ArgCheck.isNotNull((Object)theTreeNode);
        MappingClassColumn result = null;
        Iterator iter = theMappingClass.getColumns().iterator();
        while (iter.hasNext()) {
            MappingClassColumn column = (MappingClassColumn)iter.next();
            MappingList mappingList = this.getMappingList(column);
            if (mappingList == null || !mappingList.contains(theTreeNode)) continue;
            result = column;
            break;
        }
        return result;
    }

    public HashMap getTreeNodesToMappingClassColumnsMap(boolean bForceCreate) {
        if (bForceCreate || this.treeNodesToMappingClassColumnsMap == null) {
            this.treeNodesToMappingClassColumnsMap = this.treeNodesToMappingClassColumnsMap != null ? new HashMap(this.treeNodesToMappingClassColumnsMap.keySet().size()) : new HashMap();
            int size = this.mappingClasses.size();
            for (int i = 0; i < size; ++i) {
                EList columns;
                MappingClass mappingClass = (MappingClass)this.mappingClasses.get(i);
                if (mappingClass == null || (columns = mappingClass.getColumns()) == null || columns.isEmpty()) continue;
                int numColumns = columns.size();
                for (int j = 0; j < numColumns; ++j) {
                    MappingClassColumn col = (MappingClassColumn)columns.get(j);
                    List treeNodes = this.getLocations(col);
                    Iterator itNodes = treeNodes.iterator();
                    while (itNodes.hasNext()) {
                        EObject oTreeNodeTemp = (EObject)itNodes.next();
                        this.treeNodesToMappingClassColumnsMap.put(oTreeNodeTemp, col);
                    }
                }
            }
        }
        return this.treeNodesToMappingClassColumnsMap;
    }

    public HashMap getTreeNodesToMappingClassScopeMap(boolean bForceCreate) {
        if (bForceCreate || this.treeNodesToMappingClassScopeMap == null) {
            this.treeNodesToMappingClassScopeMap = this.treeNodesToMappingClassScopeMap != null ? new HashMap(this.treeNodesToMappingClassScopeMap.keySet().size()) : new HashMap();
            int size = this.mappingClasses.size();
            for (int i = 0; i < size; ++i) {
                MappingClass mappingClass = (MappingClass)this.mappingClasses.get(i);
                if (mappingClass == null) continue;
                this.addEntryToTreeNodesToMappingClassScopeMap(mappingClass);
            }
        }
        return this.treeNodesToMappingClassScopeMap;
    }

    private void addEntryToTreeNodesToMappingClassScopeMap(MappingClass mappingClass) {
        List lstNodes = this.getTreeNodesInAMappingClassScope(mappingClass);
        if (lstNodes != null && !lstNodes.isEmpty()) {
            int iNodes = lstNodes.size();
            for (int j = 0; j < iNodes; ++j) {
                EObject eoTemp = (EObject)lstNodes.get(j);
                if (!this.mapper.isMappable(eoTemp)) continue;
                this.treeNodesToMappingClassScopeMap.put(eoTemp, mappingClass);
            }
        }
    }

    private void removeEntryFromTreeNodesToMappingClassScopeMap(MappingClass mappingClass) {
        Set colNodes = this.treeNodesToMappingClassScopeMap.keySet();
        if (colNodes != null && !colNodes.isEmpty()) {
            Iterator it = colNodes.iterator();
            while (it.hasNext()) {
                EObject tempNodeKey = (EObject)it.next();
                MappingClass tempMappingClass = (MappingClass)this.treeNodesToMappingClassScopeMap.get(tempNodeKey);
                if (tempMappingClass != mappingClass) continue;
                it.remove();
            }
        }
    }

    public List getTreeNodesInAMappingClassScope(MappingClass theMappingClass) {
        List locations = this.getLocations(theMappingClass);
        ArrayList extentNodes = new ArrayList();
        List columnLocations = this.getColumnLocations(theMappingClass);
        HashMap columnLocationsMap = this.simpleListToMap(columnLocations);
        if (!locations.isEmpty()) {
            ArrayList mappingClassLocations = new ArrayList();
            Iterator mcIter = this.getAllMappingClasses().iterator();
            while (mcIter.hasNext()) {
                mappingClassLocations.addAll(this.getLocations((MappingClass)mcIter.next()));
            }
            HashMap mappingClassLocationsMap = this.simpleListToMap(mappingClassLocations);
            int size = locations.size();
            for (int i = 0; i < size; ++i) {
                extentNodes.add(locations.get(i));
                extentNodes.addAll(this.gatherCoarseExtentNodes((EObject)locations.get(i), columnLocationsMap, mappingClassLocationsMap));
            }
        }
        return extentNodes;
    }

    private List gatherCoarseExtentNodes(EObject visibleNode, HashMap columnLocationsMap, HashMap mappingClassLocationsMap) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Iterator childIter = this.mapper.getMappableTree().getChildren(visibleNode).iterator();
        while (childIter.hasNext()) {
            EObject node = (EObject)childIter.next();
            if (columnLocationsMap.get(node) != null) {
                result.add(node);
                result.addAll(this.gatherCoarseExtentNodes(node, columnLocationsMap, mappingClassLocationsMap));
                continue;
            }
            if (mappingClassLocationsMap.get(node) != null) continue;
            result.add(node);
            result.addAll(this.gatherCoarseExtentNodes(node, columnLocationsMap, mappingClassLocationsMap));
        }
        return result;
    }

    public List getColumnLocations(MappingClass theMappingClass) {
        ArrayList result = new ArrayList();
        Iterator iter = theMappingClass.getColumns().iterator();
        while (iter.hasNext()) {
            result.addAll(this.getLocations((MappingClassColumn)iter.next()));
        }
        return result;
    }

    private HashMap simpleListToMap(List list) {
        HashMap hmap = new HashMap(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object oTemp = iter.next();
            hmap.put(oTemp, oTemp);
        }
        return hmap;
    }

    public MappingClassColumn getMappingClassColumn(EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theTreeNode);
        MappingClassColumn result = null;
        result = (MappingClassColumn)this.getTreeNodesToMappingClassColumnsMap(false).get(theTreeNode);
        return result;
    }

    public boolean isMapped(EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theTreeNode);
        return this.getTreeNodesToMappingClassColumnsMap(false).get(theTreeNode) != null;
    }

    public MappingClass getMappingClassForRootTreeNode(EObject theTreeNode) {
        Object oTemp = this.mappingClassLocationMap.get(theTreeNode);
        if (oTemp != null && oTemp instanceof MappingClass) {
            return (MappingClass)oTemp;
        }
        return null;
    }

    public StagingTable getStagingTableForRootTreeNode(EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theTreeNode);
        Object oTemp = this.stagingTableLocationMap.get(theTreeNode);
        if (oTemp != null && oTemp instanceof StagingTable) {
            return (StagingTable)oTemp;
        }
        return null;
    }

    public void removeLocation(MappingClass theMappingClass, EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theMappingClass);
        ArgCheck.isNotNull((Object)theTreeNode);
        MappingList currentLocations = this.getMappingList(theMappingClass);
        if (currentLocations.contains(theTreeNode)) {
            try {
                ModelerCore.getModelEditor().removeValue((Object)currentLocations.mapping, (Object)theTreeNode, currentLocations.list);
                this.removeEntryFromTreeNodesToMappingClassScopeMap(theMappingClass);
                this.removeFromMappingClassLocationMap(theMappingClass);
            }
            catch (Exception e) {
                PluginConstants.Util.log(4, (Throwable)e, PluginConstants.Util.getString(PREFIX + "removeLocationTreeNodeNotFound", new Object[]{theTreeNode, "MappingClass", theMappingClass}));
            }
        }
    }

    public void removeMappingClass(MappingClass theMappingClass) throws ModelerCoreException {
        ArgCheck.isNotNull((Object)theMappingClass);
        int index = this.mappingClasses.indexOf(theMappingClass);
        if (index >= 0 && index < this.mappingRoots.size()) {
            EObject mapping = (EObject)this.mappingRoots.get(index);
            this.mappingRoots.remove(index);
            this.mappingClasses.remove(index);
            this.stagingTables.remove(index);
            this.removeFromMappingClassLocationMap(theMappingClass);
            if (mapping != null) {
                ModelerCore.getModelEditor().delete(mapping, true, false);
            }
        }
    }

    private void removeFromMappingClassLocationMap(MappingClass theMappingClass) {
        Object matchingValueKey = null;
        Iterator iter = this.mappingClassLocationMap.keySet().iterator();
        while (iter.hasNext() && matchingValueKey == null) {
            Object key = iter.next();
            Object value = this.mappingClassLocationMap.get(key);
            if (value != null && !value.equals(theMappingClass)) continue;
            matchingValueKey = key;
        }
        if (matchingValueKey != null) {
            this.mappingClassLocationMap.remove(matchingValueKey);
        }
        this.locationToMappingClassMap.remove(theMappingClass);
    }

    public void removeLocation(MappingClassColumn theMappingColumn, EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theMappingColumn);
        ArgCheck.isNotNull((Object)theTreeNode);
        MappingList currentLocations = this.getMappingList(theMappingColumn);
        if (currentLocations != null) {
            try {
                ModelerCore.getModelEditor().removeValue((Object)currentLocations.mapping, (Object)theTreeNode, currentLocations.list);
                this.treeNodesToMappingClassColumnsMap.remove(theTreeNode);
            }
            catch (Exception e) {
                PluginConstants.Util.log(4, (Throwable)e, PluginConstants.Util.getString(PREFIX + "removeLocationTreeNodeNotFound", new Object[]{theTreeNode, "MappingClassColumn", theMappingColumn}));
            }
        } else {
            PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "removeLocationTreeNodeNotFound", new Object[]{theTreeNode, "MappingClassColumn", theMappingColumn}));
        }
    }

    public void setLocation(StagingTable theStagingTable, EObject theTreeNode) {
        ArgCheck.isNotNull((Object)theStagingTable);
        ArgCheck.isNotNull((Object)theTreeNode);
        int index = this.stagingTables.indexOf(theStagingTable);
        if (this.stagingTables.indexOf(theStagingTable) == -1) {
            try {
                this.stagingTables.add(theStagingTable);
                this.mappingClasses.add(null);
                TreeMappingRoot mappingRoot = ModelResourceContainerFactory.createNewTreeMappingRoot((EObject)this.root, (Resource)this.root.eResource());
                ModelerCore.getModelEditor().addValue((Object)mappingRoot, (Object)theStagingTable, mappingRoot.getInputs());
                ModelerCore.getModelEditor().addValue((Object)mappingRoot, (Object)theTreeNode, mappingRoot.getOutputs());
                this.mappingRoots.add(mappingRoot);
                this.stagingTableLocationMap.put(theTreeNode, theStagingTable);
            }
            catch (Exception e) {
                PluginConstants.Util.log(4, (Throwable)e, PluginConstants.Util.getString(PREFIX + "stagingTableMappingError", new Object[]{theStagingTable, "setLocation"}));
            }
        } else {
            MappingRoot mappingRoot = (MappingRoot)this.mappingRoots.get(index);
            EList treeNodes = mappingRoot.getOutputs();
            if (treeNodes.isEmpty()) {
                treeNodes.add(theTreeNode);
            } else {
                treeNodes.set(0, theTreeNode);
                if (treeNodes.size() > 1) {
                    PluginConstants.Util.log(2, PluginConstants.Util.getString(PREFIX + "invalidStagingTableLocationSize", new Object[]{theStagingTable, new Integer(treeNodes.size()), "setLocation(StagingTable, EObject)"}));
                }
            }
        }
    }

    public void unsetLocation(StagingTable theStagingTable) throws ModelerCoreException {
        ArgCheck.isNotNull((Object)theStagingTable);
        int index = this.stagingTables.indexOf(theStagingTable);
        if (this.stagingTables.indexOf(theStagingTable) == -1) {
            PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "stagingTableNotFound", new Object[]{theStagingTable, "unsetLocation"}));
        } else {
            MappingRoot mappingRoot = (MappingRoot)this.mappingRoots.get(index);
            if (mappingRoot != null) {
                ModelerCore.getModelEditor().delete((EObject)mappingRoot);
            }
            this.mappingRoots.remove(index);
            this.mappingClasses.remove(index);
            this.stagingTables.remove(index);
            Object matchingValueKey = null;
            Iterator iter = this.stagingTableLocationMap.keySet().iterator();
            while (iter.hasNext() && matchingValueKey == null) {
                Object key = iter.next();
                Object value = this.stagingTableLocationMap.get(key);
                if (value != null && !value.equals(theStagingTable)) continue;
                matchingValueKey = key;
            }
            if (matchingValueKey != null) {
                this.stagingTableLocationMap.remove(matchingValueKey);
            }
        }
    }

    public List getParentMappingClasses(MappingClass theMappingClass, IMappableTree theMappableTree, boolean includeStagingTables) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<EObject> locations = null;
        if (theMappingClass instanceof StagingTable) {
            locations = new ArrayList();
            locations.add(this.getLocation((StagingTable)theMappingClass));
        } else {
            locations = this.getLocations(theMappingClass);
        }
        Iterator iter = this.mappingClasses.iterator();
        block0: while (iter.hasNext()) {
            MappingClass mc = (MappingClass)iter.next();
            if (mc == null || mc.equals(theMappingClass)) continue;
            Iterator testLocIter = this.getLocations(mc).iterator();
            while (testLocIter.hasNext() && locations.size() != 0) {
                EObject possibleLoc = (EObject)testLocIter.next();
                for (int i = 0; i < locations.size(); ++i) {
                    if (theMappableTree.isAncestorOf(possibleLoc, (EObject)locations.get(i))) {
                        result.add(mc);
                        continue block0;
                    }
                    if (!theMappableTree.isSiblingOf((EObject)locations.get(i), possibleLoc, true)) continue;
                    result.add(mc);
                    continue block0;
                }
            }
        }
        if (includeStagingTables) {
            iter = this.stagingTables.iterator();
            block3: while (iter.hasNext()) {
                StagingTable st = (StagingTable)iter.next();
                if (st == null || st.equals(theMappingClass)) continue;
                EObject possibleLoc = this.getLocation(st);
                if (locations.contains(possibleLoc)) {
                    result.add(st);
                    continue;
                }
                for (int i = 0; i < locations.size(); ++i) {
                    if (theMappableTree.isAncestorOf(possibleLoc, (EObject)locations.get(i))) {
                        result.add(st);
                        continue block3;
                    }
                    if (!theMappableTree.isSiblingOf((EObject)locations.get(i), possibleLoc, true)) continue;
                    result.add(st);
                    continue block3;
                }
            }
        }
        return result;
    }

    public EObject getDocument() {
        EObject firstRoot;
        if (this.mappingRoots != null && !this.mappingRoots.isEmpty() && (firstRoot = (EObject)this.mappingRoots.get(0)) != null && firstRoot instanceof TransformationMappingRoot) {
            return ((TransformationMappingRoot)firstRoot).getTarget();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

