/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.mapping.factory;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.transformation.FragmentMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.mapping.PluginConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;

public class FragmentMappingAdapter
implements PluginConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$mapping$factory$FragmentMappingAdapter == null ? (class$com$metamatrix$modeler$internal$mapping$factory$FragmentMappingAdapter = FragmentMappingAdapter.class$("com.metamatrix.modeler.internal.mapping.factory.FragmentMappingAdapter")) : class$com$metamatrix$modeler$internal$mapping$factory$FragmentMappingAdapter));
    private FragmentMappingRoot fragmentRoot;
    private EObject root;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$mapping$factory$FragmentMappingAdapter;

    public FragmentMappingAdapter(EObject theTreeRoot) {
        ArgCheck.isNotNull((Object)theTreeRoot);
        this.root = theTreeRoot;
        ArrayList<MappingRoot> fragmentRoots = new ArrayList<MappingRoot>();
        ModelContents mc = ModelerCore.getModelEditor().getModelContents(this.root);
        if (mc != null) {
            List mappingRoots = mc.getTransformations(theTreeRoot);
            if (mappingRoots != null && !mappingRoots.isEmpty()) {
                int size = mappingRoots.size();
                for (int i = 0; i < size; ++i) {
                    MappingRoot mappingRoot = (MappingRoot)mappingRoots.get(i);
                    if (!(mappingRoot instanceof FragmentMappingRoot)) continue;
                    fragmentRoots.add(mappingRoot);
                }
            }
            this.setFragmentRoots(fragmentRoots);
        }
    }

    public FragmentMappingAdapter(EObject theTreeRoot, List theFragmentRoots) {
        ArgCheck.isNotNull((Object)theTreeRoot);
        this.root = theTreeRoot;
        this.setFragmentRoots(theFragmentRoots);
    }

    public void addFragment(EObject theFragmentReference, EObject theFragment) {
        ModelContents mc;
        ArgCheck.isNotNull((Object)theFragmentReference);
        ArgCheck.isNotNull((Object)theFragment);
        if (this.fragmentRoot == null && (mc = ModelerCore.getModelEditor().getModelContents(this.root)) != null) {
            this.fragmentRoot = ModelResourceContainerFactory.createNewFragmentMappingRoot((EObject)this.root);
        }
        boolean createFragment = true;
        List mappings = this.getMappings();
        if (!mappings.isEmpty()) {
            int size = 0;
            for (int i = 0; i < size; ++i) {
                Mapping mapping = (Mapping)mappings.get(i);
                EObject fragmentReference = this.getFragmentReference(mapping);
                if (!theFragmentReference.equals(fragmentReference)) continue;
                createFragment = false;
                break;
            }
        }
        if (createFragment) {
            this.fragmentRoot.createMapping(Collections.singletonList(theFragment), Collections.singletonList(theFragmentReference));
        } else {
            PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "duplicateFragment", new Object[]{theFragmentReference}));
        }
    }

    public boolean containsFragments() {
        return this.getFragmentCount() > 0;
    }

    public EObject getFragment(EObject theFragmentReference) {
        List fragmentMappings;
        ArgCheck.isNotNull((Object)theFragmentReference);
        EObject result = null;
        if (this.containsFragments() && !(fragmentMappings = this.getMappings()).isEmpty()) {
            int size = fragmentMappings.size();
            for (int i = 0; i < size; ++i) {
                Mapping mapping = (Mapping)fragmentMappings.get(i);
                EObject fragmentReference = this.getFragmentReference(mapping);
                if (!theFragmentReference.equals(fragmentReference)) continue;
                result = this.getFragment(mapping);
                break;
            }
        }
        return result;
    }

    private EObject getFragment(Mapping theMapping) {
        ArgCheck.isNotNull((Object)theMapping);
        EList inputs = theMapping.getInputs();
        return inputs.isEmpty() ? null : (EObject)inputs.get(0);
    }

    private int getFragmentCount() {
        return this.fragmentRoot == null ? 0 : this.getMappings().size();
    }

    private EObject getFragmentReference(Mapping theMapping) {
        ArgCheck.isNotNull((Object)theMapping);
        EList outputs = theMapping.getOutputs();
        return outputs.isEmpty() ? null : (EObject)outputs.get(0);
    }

    public EObject getInputSet() {
        EObject result = null;
        if (this.fragmentRoot != null) {
            // empty if block
        }
        return result;
    }

    public EObject getInputSet(EObject theFragmentReference) {
        List mappings;
        ArgCheck.isNotNull((Object)theFragmentReference);
        EObject result = null;
        if (this.containsFragments() && !(mappings = this.getMappings()).isEmpty()) {
            int size = mappings.size();
            for (int i = 0; i < size; ++i) {
                Mapping mapping = (Mapping)mappings.get(i);
                EObject fragmentReference = this.getFragmentReference(mapping);
                if (!theFragmentReference.equals(fragmentReference)) continue;
            }
        }
        return result;
    }

    private List getMappings() {
        return this.fragmentRoot == null ? null : this.fragmentRoot.getNested();
    }

    public void removeFragment(EObject theFragmentReference) {
        ArgCheck.isNotNull((Object)theFragmentReference);
        if (this.containsFragments()) {
            boolean foundIt = false;
            List mappings = this.getMappings();
            int size = mappings.size();
            for (int i = 0; i < size; ++i) {
                Mapping mapping = (Mapping)mappings.get(i);
                EObject fragmentReference = this.getFragmentReference(mapping);
                if (!theFragmentReference.equals(fragmentReference)) continue;
                foundIt = true;
                break;
            }
            if (!foundIt) {
                PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "removeFragmentProblemNotFound", new Object[]{theFragmentReference}));
            }
        } else {
            PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "removeFragmentProblemNoRoot", new Object[]{theFragmentReference}));
        }
    }

    private void setFragmentRoots(List theFragmentRoots) {
        ArgCheck.isNotNull((Object)theFragmentRoots);
        if (!theFragmentRoots.isEmpty()) {
            int size = theFragmentRoots.size();
            for (int i = 0; i < size; ++i) {
                Object potentialRoot = theFragmentRoots.get(i);
                if (potentialRoot instanceof FragmentMappingRoot) {
                    if (this.fragmentRoot == null) {
                        this.fragmentRoot = (FragmentMappingRoot)potentialRoot;
                        continue;
                    }
                    PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "multipleFragmentRootsFound", new Object[]{potentialRoot}));
                    continue;
                }
                PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "notFragmentRoot", new Object[]{potentialRoot}));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

