/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.mapping.factory;

import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlColumnAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import com.metamatrix.modeler.internal.mapping.factory.ChoiceFactoryManager;
import com.metamatrix.modeler.mapping.factory.IChoiceFactory;
import com.metamatrix.modeler.mapping.factory.IMappableTree;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;

public class DefaultMappableTree
implements IMappableTree {
    private EObject treeRoot;
    private AdapterFactoryItemDelegator emfContentProvider;

    public DefaultMappableTree(EObject treeRoot) {
        this.treeRoot = treeRoot;
    }

    public AdapterFactoryItemDelegator getModelContentProvider() {
        if (this.emfContentProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodels().getEmfAdapterFactory();
            this.emfContentProvider = new AdapterFactoryItemDelegator(factory);
        }
        return this.emfContentProvider;
    }

    public EObject getTreeRoot() {
        return this.treeRoot;
    }

    public EObject getParent(EObject node) {
        Object parent = this.getModelContentProvider().getParent((Object)node);
        if (parent instanceof EObject) {
            return (EObject)parent;
        }
        return null;
    }

    public Collection getChildren(EObject node) {
        return this.getModelContentProvider().getChildren((Object)node);
    }

    public boolean isAncestorOf(EObject ancestor, EObject descendent) {
        EObject parent = this.getParent(descendent);
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = this.getParent(parent);
        }
        return false;
    }

    public boolean isParentOf(EObject parent, EObject child) {
        return this.getParent(child).equals(parent);
    }

    public List getExternalRoots(boolean recurseFragments) {
        return Collections.EMPTY_LIST;
    }

    public boolean isExternal(EObject node) {
        return false;
    }

    public EObject getDatatype(EObject node) {
        EObject result = null;
        SqlAspect aspect = AspectManager.getSqlAspect((EObject)node);
        if (aspect instanceof SqlColumnAspect) {
            result = ((SqlColumnAspect)aspect).getDatatype(node);
        } else if (aspect instanceof SqlProcedureParameterAspect) {
            result = ((SqlProcedureParameterAspect)aspect).getDatatype(node);
        }
        return result;
    }

    public boolean isChoiceNode(EObject node) {
        IChoiceFactory factory = ChoiceFactoryManager.getChoiceFactory(node);
        return factory != null && factory.supports(node);
    }

    public boolean isSiblingOf(EObject instance, EObject possibleSibling, boolean higherOrderOnly) {
        boolean result = false;
        result = instance.eContainer().equals(possibleSibling.eContainer());
        if (result && higherOrderOnly) {
            EList siblingList = instance.eContainer().eContents();
            int a = siblingList.indexOf(instance);
            int b = siblingList.indexOf(possibleSibling);
            result = b < a;
        }
        return result;
    }

    public boolean areEquivalent(EObject objA, EObject objB) {
        return false;
    }

    public String getUniqueName(EObject node) {
        ModelEditor editor = ModelerCore.getModelEditor();
        String name = editor.getName(node);
        return name + '_' + editor.getName(node.eContainer());
    }
}

