/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.mapping.factory;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.mapping.DebugConstants;
import com.metamatrix.modeler.mapping.PluginConstants;
import com.metamatrix.modeler.mapping.factory.IChoiceFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;

public class ChoiceFactoryManager
implements DebugConstants,
PluginConstants,
PluginConstants.ExtensionPoints.ChoiceObjectHandler {
    private static final Class CLASS = class$com$metamatrix$modeler$internal$mapping$factory$ChoiceFactoryManager == null ? (class$com$metamatrix$modeler$internal$mapping$factory$ChoiceFactoryManager = ChoiceFactoryManager.class$("com.metamatrix.modeler.internal.mapping.factory.ChoiceFactoryManager")) : class$com$metamatrix$modeler$internal$mapping$factory$ChoiceFactoryManager;
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)CLASS);
    private static Map choiceHandlerMap;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$mapping$factory$ChoiceFactoryManager;

    private ChoiceFactoryManager() {
    }

    private static void buildChoiceHanderMaps() {
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printEntered(CLASS, "buildMapperMap()");
        }
        choiceHandlerMap = new HashMap();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.metamatrix.modeler.mapping", "choiceObjectHandler");
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length > 0) {
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                Object extension = null;
                Object sFactoryClass = null;
                if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
                    PluginConstants.Util.print(CLASS, "buildChoiceHanderMaps():found " + elements.length + " choice handler extensions");
                }
                for (int j = 0; j < elements.length; ++j) {
                    try {
                        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
                            PluginConstants.Util.print(CLASS, "buildChoiceHanderMaps():processing " + elements[j].getAttribute("name"));
                        }
                        if ((extension = elements[j].createExecutableExtension("factoryClass")) instanceof IChoiceFactory) {
                            choiceHandlerMap.put(sFactoryClass, extension);
                            continue;
                        }
                        PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "invalidChoiceHandlerMapperClass", new Object[]{extension.getClass().getName()}));
                        continue;
                    }
                    catch (Exception theException) {
                        PluginConstants.Util.log(4, (Throwable)theException, PluginConstants.Util.getString(PREFIX + "loadingChoiceHandlerProblem", new Object[]{elements[j].getAttribute("name")}));
                    }
                }
            }
        }
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printExited(CLASS, "buildChoiceHanderMaps():choiceHandlerMap=" + choiceHandlerMap);
        }
    }

    public static IChoiceFactory getChoiceFactory(EObject eo) {
        ArgCheck.isNotNull((Object)eo);
        Iterator it = choiceHandlerMap.values().iterator();
        while (it.hasNext()) {
            IChoiceFactory icf = (IChoiceFactory)it.next();
            if (!icf.supports(eo)) continue;
            return icf;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ChoiceFactoryManager.buildChoiceHanderMaps();
    }
}

