/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.ddl;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceSelections;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelWrapper {
    private final Resource emfResource;
    private final ModelContents contents;
    private final String modelName;
    private final String modelFilename;
    private final ModelWorkspaceSelections selections;

    public ModelWrapper(Resource emfResource, ModelContents contents, ModelWorkspaceSelections selections, String modelName, String modelFilename) {
        ArgCheck.isNotNull((Object)emfResource);
        this.emfResource = emfResource;
        this.selections = selections;
        this.contents = contents != null ? contents : (this.emfResource instanceof EmfResource ? ((EmfResource)this.emfResource).getModelContents() : new ModelContents(this.emfResource));
        this.modelName = modelName != null ? modelName : "";
        this.modelFilename = modelFilename != null ? modelFilename : "";
    }

    public ModelContents getContents() {
        return this.contents;
    }

    public Resource getEmfResource() {
        return this.emfResource;
    }

    public String getModelFilename() {
        return this.modelFilename;
    }

    public String getModelName() {
        return this.modelName;
    }

    public boolean isSelected(EObject obj) {
        if (this.selections == null) {
            return true;
        }
        int mode = this.selections.getSelectionMode((Object)obj);
        return mode == 1 || mode == 2;
    }
}

