/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.selector;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.compare.selector.ModelContentsModelHelper;
import com.metamatrix.modeler.compare.selector.ModelHelper;
import com.metamatrix.modeler.compare.selector.TemporaryResourceModelSelector;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class URIModelSelector
extends TemporaryResourceModelSelector {
    protected Resource resource;
    private final URI modelUri;
    protected ModelContents contents;
    private ModelHelper helper;

    public URIModelSelector(URI modelUri) {
        ArgCheck.isNotNull((Object)modelUri);
        this.modelUri = modelUri;
    }

    public void open() {
        if (this.resource == null) {
            this.resource = this.getResourceSet().getResource(this.modelUri, true);
            if (this.resource instanceof EmfResource) {
                this.contents = ((EmfResource)this.resource).getModelContents();
            }
            if (this.contents == null) {
                this.contents = new ModelContents(this.resource);
            }
        }
    }

    public Resource getResource() throws ModelerCoreException {
        this.open();
        return this.resource;
    }

    public List getRootObjects() throws ModelerCoreException {
        this.open();
        return this.resource.getContents();
    }

    public URI getUri() {
        return this.modelUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.resource != null) {
                this.resource.unload();
            }
            Object var2_1 = null;
            this.contents = null;
            this.helper = null;
            this.resource = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.contents = null;
            this.helper = null;
            this.resource = null;
            throw throwable;
        }
    }

    public ModelAnnotation getModelAnnotation() throws ModelWorkspaceException {
        this.open();
        return this.contents.getModelAnnotation();
    }

    public ModelHelper getModelHelper() throws ModelWorkspaceException {
        if (this.helper == null) {
            this.open();
            this.helper = new ModelContentsModelHelper(this.contents);
        }
        return this.helper;
    }

    public ModelContents getModelContents() throws ModelWorkspaceException {
        this.open();
        return this.contents;
    }
}

