/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.selector;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.compare.selector.AbstractModelSelector;
import com.metamatrix.modeler.compare.selector.ModelContentsModelHelper;
import com.metamatrix.modeler.compare.selector.ModelHelper;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelResourceSelector
extends AbstractModelSelector {
    private final ModelResource modelResource;
    private ModelContents contents;
    private String label;
    private ModelHelper helper;

    public ModelResourceSelector(ModelResource modelResource) {
        ArgCheck.isNotNull((Object)modelResource);
        this.modelResource = modelResource;
    }

    public void open() {
    }

    public Resource getResource() throws ModelerCoreException {
        return this.modelResource.getEmfResource();
    }

    public ModelResource getModelResource() {
        return this.modelResource;
    }

    public List getRootObjects() throws ModelerCoreException {
        return this.getResource().getContents();
    }

    public URI getUri() {
        IPath path = this.modelResource.getPath();
        URI result = URI.createFileURI((String)path.toFile().getAbsolutePath());
        return result;
    }

    public void close() {
        this.helper = null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ModelAnnotation getModelAnnotation() throws ModelWorkspaceException {
        return this.modelResource.getModelAnnotation();
    }

    public ModelHelper getModelHelper() throws ModelWorkspaceException {
        if (this.helper == null) {
            this.helper = new ModelContentsModelHelper(this.getModelContents());
        }
        return this.helper;
    }

    public ModelContents getModelContents() throws ModelWorkspaceException {
        if (this.contents == null) {
            this.contents = ModelContents.getModelContents((ModelResource)this.modelResource);
        }
        return this.contents;
    }
}

