/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.selector;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.compare.selector.AbstractModelSelector;
import com.metamatrix.modeler.compare.selector.ModelContentsModelHelper;
import com.metamatrix.modeler.compare.selector.ModelHelper;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class EmfResourceSelector
extends AbstractModelSelector {
    private final Resource resource;
    private String label;
    private ModelContents contents;
    private ModelHelper helper;

    public EmfResourceSelector(Resource resource) {
        ArgCheck.isNotNull((Object)resource);
        this.resource = resource;
    }

    public void open() {
        if (this.resource instanceof EmfResource) {
            this.contents = ((EmfResource)this.resource).getModelContents();
        }
        if (this.contents == null) {
            this.contents = new ModelContents(this.resource);
        }
    }

    public Resource getResource() throws ModelerCoreException {
        return this.resource;
    }

    public List getRootObjects() throws ModelerCoreException {
        return this.resource.getContents();
    }

    public URI getUri() {
        return this.resource.getURI();
    }

    public void close() {
        this.contents = null;
        this.helper = null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ModelAnnotation getModelAnnotation() throws ModelWorkspaceException {
        return this.contents.getModelAnnotation();
    }

    public ModelHelper getModelHelper() throws ModelWorkspaceException {
        if (this.helper == null) {
            this.helper = new ModelContentsModelHelper(this.contents);
        }
        return this.helper;
    }

    public ModelContents getModelContents() throws ModelWorkspaceException {
        return this.contents;
    }
}

