/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.generator;

import com.metamatrix.core.UserCancelledException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.compare.ModelGenerator;
import com.metamatrix.modeler.compare.generator.AbstractModelGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class CompositeModelGenerator
extends AbstractModelGenerator {
    private final List modelGenerators;

    public CompositeModelGenerator(List modelGenerators) {
        super(null);
        ArgCheck.isNotNull((Object)modelGenerators);
        this.modelGenerators = modelGenerators != null ? modelGenerators : new ArrayList();
    }

    public List getModelGenerators() {
        return this.modelGenerators;
    }

    public List getAllDifferenceReports() {
        LinkedList reports = new LinkedList();
        Iterator iter = this.getModelGenerators().iterator();
        while (iter.hasNext()) {
            ModelGenerator generator = (ModelGenerator)iter.next();
            reports.addAll(generator.getAllDifferenceReports());
        }
        return reports;
    }

    public void close() {
        super.close();
        Iterator iter = this.getModelGenerators().iterator();
        while (iter.hasNext()) {
            ModelGenerator generator = (ModelGenerator)iter.next();
            generator.close();
        }
    }

    protected void doClearDifferenceReports() {
    }

    protected void doGenerateOutput(IProgressMonitor monitor, LinkedList problems) throws UserCancelledException {
        Iterator iter = this.getModelGenerators().iterator();
        while (iter.hasNext()) {
            ModelGenerator generator = (ModelGenerator)iter.next();
            IStatus status = generator.generateOutput(monitor);
            problems.add(status);
        }
    }

    protected void doComputeDifferenceReport(IProgressMonitor monitor, LinkedList problems) throws UserCancelledException {
        Iterator iter = this.getModelGenerators().iterator();
        while (iter.hasNext()) {
            ModelGenerator generator = (ModelGenerator)iter.next();
            IStatus status = generator.computeDifferenceReport(monitor);
            problems.add(status);
        }
    }

    protected void doPostProcessDifferenceReports() {
    }

    protected void doMergeOutputIntoOriginal(IProgressMonitor monitor, LinkedList problems) throws UserCancelledException {
        Iterator iter = this.getModelGenerators().iterator();
        while (iter.hasNext()) {
            ModelGenerator generator = (ModelGenerator)iter.next();
            if (generator instanceof AbstractModelGenerator) {
                AbstractModelGenerator amg = (AbstractModelGenerator)generator;
                amg.setProducedToOutputMapping(this.getProducedToOutputMapping());
            }
            IStatus status = generator.mergeOutputIntoOriginal(monitor);
            problems.add(status);
        }
        this.doReresolveAndRebuildImports();
    }

    protected void doReresolveAndRebuildImports() {
        Iterator iter2 = this.getModelGenerators().iterator();
        while (iter2.hasNext()) {
            ModelGenerator generator = (ModelGenerator)iter2.next();
            if (!(generator instanceof AbstractModelGenerator)) continue;
            AbstractModelGenerator amg = (AbstractModelGenerator)generator;
            amg.doReresolveAndRebuildImports();
        }
    }
}

