/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.modeler.compare.DifferenceProcessor;
import com.metamatrix.modeler.compare.MergeProcessor;
import com.metamatrix.modeler.compare.impl.ComparePackageImpl;
import com.metamatrix.modeler.compare.processor.DifferenceProcessorImpl;
import com.metamatrix.modeler.compare.processor.MergeProcessorImpl;
import com.metamatrix.modeler.compare.selector.EmfResourceSelector;
import com.metamatrix.modeler.compare.selector.InputStreamModelSelector;
import com.metamatrix.modeler.compare.selector.ModelResourceSelector;
import com.metamatrix.modeler.compare.selector.URIModelSelector;
import com.metamatrix.modeler.core.MappingAdapterDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.compare.EObjectMatcherFactory;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.framework.BundleContext;

public class ModelerComparePlugin
extends Plugin {
    private static final String MISSING_RESOURCE = "<Missing message for key";
    public static final String PLUGIN_ID = "com.metamatrix.modeler.compare";
    private static final String BUNDLE_NAME = "com.metamatrix.modeler.compare.i18n";
    public static final PluginUtil Util = new PluginUtilImpl("com.metamatrix.modeler.compare", "com.metamatrix.modeler.compare.i18n", ResourceBundle.getBundle("com.metamatrix.modeler.compare.i18n"));
    private static final ResourceLocator RESOURCE_LOCATOR = new ResourceLocator(){
        private ResourceLocator delegate = EcorePlugin.INSTANCE.getPluginResourceLocator();

        public URL getBaseURL() {
            if (INSTANCE != null) {
                URL baseUrl;
                try {
                    baseUrl = Platform.resolve((URL)INSTANCE.getBundle().getEntry("/"));
                }
                catch (IOException err) {
                    baseUrl = null;
                }
                return baseUrl;
            }
            try {
                URI uri = URI.createURI((String)this.getClass().getResource("plugin.properties").toString());
                URL baseUrl = new URL(uri.trimSegments(1).toString() + "/");
                return baseUrl;
            }
            catch (IOException exception) {
                throw new WrappedException((Exception)exception);
            }
        }

        public Object getImage(String key) {
            try {
                URL baseUrl = this.getBaseURL();
                URL url = new URL(baseUrl + "icons/" + key + ".gif");
                InputStream inputStream = url.openStream();
                inputStream.close();
                return url;
            }
            catch (MalformedURLException exception) {
                throw new WrappedException((Exception)exception);
            }
            catch (IOException exception) {
                return this.delegate.getImage(key);
            }
        }

        public String getString(String key) {
            String result = Util.getString(key);
            if (result.startsWith(ModelerComparePlugin.MISSING_RESOURCE)) {
                result = this.delegate.getString(key);
            }
            return result;
        }

        public String getString(String key, Object[] substitutions) {
            String result = Util.getString(key);
            if (result.startsWith(ModelerComparePlugin.MISSING_RESOURCE)) {
                result = this.delegate.getString(key, substitutions);
            }
            return result;
        }

        public String getString(String key, boolean translate) {
            return this.getString(key);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return this.getString(key, substitutions);
        }
    };
    public static boolean DEBUG = false;
    private static ModelerComparePlugin INSTANCE = null;
    static /* synthetic */ Class class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl;

    public static ResourceLocator getPluginResourceLocator() {
        return RESOURCE_LOCATOR;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    public static DifferenceProcessor createDifferenceProcessor(ModelResource modelResource) throws ModelWorkspaceException {
        ArgCheck.isNotNull((Object)modelResource);
        ModelResourceSelector currentSelector = new ModelResourceSelector(modelResource);
        currentSelector.setLabel(modelResource.getPath().toString());
        DifferenceProcessorImpl processor = null;
        if (!modelResource.hasUnsavedChanges()) {
            processor = new DifferenceProcessorImpl(currentSelector);
        } else {
            URI uri = URI.createFileURI((String)modelResource.getResource().getLocation().toFile().getAbsolutePath());
            URIModelSelector savedSelector = new URIModelSelector(uri);
            Object[] params = new Object[]{modelResource.getPath().toString()};
            savedSelector.setLabel(Util.getString("ModelerComparePlugin.SavedModel", params));
            currentSelector.setLabel(Util.getString("ModelerComparePlugin.OpenedModel", params));
            processor = new DifferenceProcessorImpl(savedSelector, currentSelector);
        }
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static DifferenceProcessor createDifferenceProcessor(ModelResource startingResource, ModelResource endingResource) throws ModelWorkspaceException {
        ArgCheck.isNotNull((Object)startingResource);
        ArgCheck.isNotNull((Object)endingResource);
        ModelResourceSelector startingSelector = new ModelResourceSelector(startingResource);
        ModelResourceSelector endingSelector = new ModelResourceSelector(endingResource);
        endingSelector.setLabel(startingResource.getPath().toString());
        endingSelector.setLabel(endingResource.getPath().toString());
        DifferenceProcessorImpl processor = new DifferenceProcessorImpl(startingSelector, endingSelector);
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static DifferenceProcessor createDifferenceProcessor(InputStream startingResource, IPath startingResourcePath, ModelResource endingResource, String startingResourceDesc) throws ModelWorkspaceException {
        ArgCheck.isNotNull((Object)startingResource);
        ArgCheck.isNotNull((Object)startingResourcePath);
        ArgCheck.isNotNull((Object)endingResource);
        IResource resource = endingResource.getCorrespondingResource();
        URI temporayURI = null;
        if (ModelUtil.isXsdFile((IResource)resource)) {
            temporayURI = InputStreamModelSelector.XSD_URI;
        } else if (ModelUtil.isModelFile((IResource)resource)) {
            temporayURI = InputStreamModelSelector.XMI_URI;
        } else if (ModelUtil.isVdbArchiveFile((IResource)resource)) {
            temporayURI = InputStreamModelSelector.VDB_URI;
        }
        if (temporayURI == null) {
            return null;
        }
        InputStreamModelSelector startingSelector = new InputStreamModelSelector(startingResource, temporayURI);
        ModelResourceSelector endingSelector = new ModelResourceSelector(endingResource);
        startingSelector.setLabel(startingResourceDesc);
        endingSelector.setLabel(endingResource.getPath().toString());
        DifferenceProcessorImpl processor = new DifferenceProcessorImpl(startingSelector, endingSelector);
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static DifferenceProcessor createDifferenceProcessor(Resource startingResource, Resource endingResource) throws ModelWorkspaceException {
        ArgCheck.isNotNull((Object)startingResource);
        ArgCheck.isNotNull((Object)endingResource);
        EmfResourceSelector startingSelector = new EmfResourceSelector(startingResource);
        EmfResourceSelector endingSelector = new EmfResourceSelector(endingResource);
        startingSelector.setLabel(URI.decode((String)startingResource.getURI().toString()));
        endingSelector.setLabel(URI.decode((String)endingResource.getURI().toString()));
        DifferenceProcessorImpl processor = new DifferenceProcessorImpl(startingSelector, endingSelector);
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static DifferenceProcessor createDifferenceProcessor(Resource startingResource, Resource endingResource, HashMap mappings) throws ModelWorkspaceException {
        ArgCheck.isNotNull((Object)startingResource);
        ArgCheck.isNotNull((Object)endingResource);
        EmfResourceSelector startingSelector = new EmfResourceSelector(startingResource);
        EmfResourceSelector endingSelector = new EmfResourceSelector(endingResource);
        startingSelector.setLabel(URI.decode((String)startingResource.getURI().toString()));
        endingSelector.setLabel(URI.decode((String)endingResource.getURI().toString()));
        DifferenceProcessorImpl processor = new DifferenceProcessorImpl(startingSelector, endingSelector, mappings);
        List mappingAdapters = ModelerComparePlugin.createEObjectMatcherFactories();
        processor.addEObjectMatcherFactories(mappingAdapters);
        return processor;
    }

    public static MergeProcessor createMergeProcessor(DifferenceProcessor difference) {
        ArgCheck.isInstanceOf((Class)(class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl == null ? (class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl = ModelerComparePlugin.class$("com.metamatrix.modeler.compare.processor.DifferenceProcessorImpl")) : class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl), (Object)difference);
        return new MergeProcessorImpl((DifferenceProcessorImpl)difference);
    }

    public static MergeProcessor createMergeProcessor(DifferenceProcessor difference, EObject[] externalReferences) {
        ArgCheck.isInstanceOf((Class)(class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl == null ? (class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl = ModelerComparePlugin.class$("com.metamatrix.modeler.compare.processor.DifferenceProcessorImpl")) : class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl), (Object)difference);
        return new MergeProcessorImpl((DifferenceProcessorImpl)difference, externalReferences);
    }

    public static MergeProcessor createMergeProcessor(DifferenceProcessor difference, EObject[] externalReferences, boolean moveAddsRatherThanCopy) {
        ArgCheck.isInstanceOf((Class)(class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl == null ? (class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl = ModelerComparePlugin.class$("com.metamatrix.modeler.compare.processor.DifferenceProcessorImpl")) : class$com$metamatrix$modeler$compare$processor$DifferenceProcessorImpl), (Object)difference);
        return new MergeProcessorImpl((DifferenceProcessorImpl)difference, externalReferences, moveAddsRatherThanCopy);
    }

    public static List createEObjectMatcherFactories() {
        LinkedList<EObjectMatcherFactory> factories = new LinkedList<EObjectMatcherFactory>();
        List adapterDescriptors = ModelerCore.getMappingAdapterDescriptors();
        Iterator iter = adapterDescriptors.iterator();
        while (iter.hasNext()) {
            EObjectMatcherFactory factory;
            MappingAdapterDescriptor desc = (MappingAdapterDescriptor)iter.next();
            if (desc == null || (factory = (EObjectMatcherFactory)desc.getExtensionClassInstance()) == null) continue;
            factories.add(factory);
        }
        return factories;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ModelerCore.getMetamodelRegistry();
        }
        catch (ModelerCoreException err) {
            Util.log((Throwable)err);
        }
        ComparePackageImpl.init();
    }
}

