/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xsd.validator;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.xsd.XsdPlugin;
import com.metamatrix.metamodels.xsd.validator.XsdResourceValidationRule;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.builder.ResourceValidator;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.validation.ValidationRule;
import com.metamatrix.modeler.core.validation.ValidationRuleSet;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.ValidationRuleSetImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;

public class SimpleXsdResourceValidator
implements ResourceValidator {
    private static final ValidationRuleSet RULE_SET = new ValidationRuleSetImpl();

    public boolean isValidatorForObject(Object obj) {
        if (obj instanceof IResource) {
            return this.isValidatorForResource((IResource)obj);
        }
        return obj instanceof XSDResourceImpl;
    }

    public void validate(IProgressMonitor theMonitor, Object obj, ValidationContext context) throws ModelerCoreException {
        XSDResourceImpl eResource;
        IProgressMonitor monitor;
        if (!this.isValidatorForObject(obj)) {
            Object[] params = new Object[]{this.getClass().getName(), obj != null ? obj.getClass().getName() : null};
            String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.validator_cannot_be_used_to_validate_the_object", params);
            throw new ModelerCoreException(msg);
        }
        Object object = monitor = theMonitor != null ? theMonitor : new NullProgressMonitor();
        if (obj instanceof IResource) {
            IResource iResource = (IResource)obj;
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            ModelResource mResource = workspace.findModelResource(iResource);
            Resource eResource2 = mResource.getEmfResource();
            this.validate(monitor, eResource2, iResource, context);
        } else if (obj instanceof XSDResourceImpl && (eResource = (XSDResourceImpl)obj).isLoaded()) {
            try {
                this.validateResource(monitor, eResource, context);
            }
            catch (Throwable e) {
                String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.Error_validating_resource", (Object)eResource.getURI().lastSegment());
                XsdPlugin.Util.log(4, e, msg);
            }
        }
    }

    public void validate(IProgressMonitor theMonitor, Resource resource, IResource iResource, ValidationContext context) throws ModelerCoreException {
        IProgressMonitor monitor;
        Object object = monitor = theMonitor != null ? theMonitor : new NullProgressMonitor();
        if (!(resource instanceof EmfResource)) {
            String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.SimpleXsdResourceValidator_may_only_be_used_to_validate_instances_of_EmfResource_1");
            throw new ModelerCoreException(msg);
        }
        if (iResource == null) {
            String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.IResource_may_not_be_null_during_validation_2");
            throw new ModelerCoreException(msg);
        }
        if (!this.isValidatorForResource(iResource)) {
            String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.Unexpected_IResource_type_encountered_during_EMF_Resource_Validation_1");
            throw new ModelerCoreException(msg);
        }
        XSDResourceImpl eResource = (XSDResourceImpl)resource;
        if (eResource.isLoaded()) {
            try {
                this.validateResource(monitor, eResource, context);
            }
            catch (Throwable e) {
                String msg = XsdPlugin.Util.getString("SimpleXsdResourceValidator.Error_validating_resource", (Object)eResource.getURI().lastSegment());
                XsdPlugin.Util.log(4, e, msg);
            }
        }
    }

    public void addMarkers(ValidationContext context, IResource iResource) throws ModelerCoreException {
        if (context != null && context.hasResults()) {
            List results = context.getValidationResults();
            try {
                Iterator i = results.iterator();
                while (i.hasNext()) {
                    ValidationResult result = (ValidationResult)i.next();
                    if (result == null || !result.hasProblems()) continue;
                    ValidationProblem[] problems = result.getProblems();
                    String locationPath = result.getLocationPath();
                    String locationUri = result.getLocationUri();
                    String targetUri = result.getTargetUri();
                    for (int probCnt = 0; probCnt < problems.length; ++probCnt) {
                        this.createProblemMarker(locationPath, locationUri, targetUri, problems[probCnt], iResource);
                    }
                    if (!result.isFatalResource()) continue;
                    return;
                }
            }
            catch (CoreException err) {
                throw new ModelerCoreException(err);
            }
        }
    }

    public boolean isValidatorForResource(IResource iResource) {
        return ModelUtil.isXsdFile((IResource)iResource);
    }

    public void validationStarted(Collection resources, ValidationContext context) {
    }

    public void validationEnded(ValidationContext context) {
    }

    private void createProblemMarker(String locationPath, String locationUri, String targetUri, ValidationProblem problem, IResource resource) throws CoreException {
        IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("location", (Object)locationPath);
        marker.setAttribute("com.metamatrix.modeler.core.markerURI", (Object)locationUri);
        marker.setAttribute("com.metamatrix.modeler.core.targetMarkerURI", (Object)targetUri);
        marker.setAttribute("message", (Object)problem.getMessage());
        this.setMarkerSeverity(marker, problem);
    }

    private void setMarkerSeverity(IMarker marker, ValidationProblem problem) throws CoreException {
        switch (problem.getSeverity()) {
            case 4: {
                marker.setAttribute("severity", 2);
                break;
            }
            case 2: {
                marker.setAttribute("severity", 1);
                break;
            }
            case 1: {
                marker.setAttribute("severity", 0);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void validateResource(IProgressMonitor monitor, XSDResourceImpl eResource, ValidationContext context) {
        ArgCheck.isNotNull((Object)eResource);
        ArgCheck.isNotNull((Object)context);
        context.clearResults();
        RULE_SET.validate(monitor, (Object)eResource, context);
    }

    static {
        RULE_SET.addRule((ValidationRule)new XsdResourceValidationRule());
    }
}

