/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xsd.aspects.sql;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.xsd.XsdConstants;
import com.metamatrix.metamodels.xsd.XsdPlugin;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.AbstractMetamodelAspect;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelEntity;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.types.DatatypeConstants;
import com.metamatrix.modeler.core.types.EnterpriseDatatypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XsdSimpleTypeDefinitionAspect
extends AbstractMetamodelAspect
implements SqlDatatypeAspect {
    public static final String ASPECT_ID = "sqlAspect";
    public static final URI BUILTIN_DATATYPES_URI = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
    public static final String UUID_ATTRIBUTE_NAME = "UUID";
    public static final String RUNTIME_TYPE_ATTRIBUTE_NAME = "runtimeDataType";
    public static final String RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME = "runtimeDataTypeFixed";
    protected static final String ANY_SIMPLE_TYPE_URI_STRING = ModelerCore.XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI + "#//anySimpleType;XSDSimpleTypeDefinition=1";
    protected static final URI ANY_SIMPLE_TYPE_URI = URI.createURI((String)ANY_SIMPLE_TYPE_URI_STRING);
    private Map mmDatatypeMap;
    private EObject anySimpleType;
    static /* synthetic */ Class class$org$eclipse$xsd$XSDSimpleTypeDefinition;
    static /* synthetic */ Class class$java$lang$Object;

    public XsdSimpleTypeDefinitionAspect(MetamodelEntity entity) {
        super.setMetamodelEntity(entity);
        super.setID(ASPECT_ID);
        this.init();
    }

    private void init() {
        this.mmDatatypeMap = new HashMap();
        this.initializeMmDatatypeMap();
    }

    public String getName(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return entity.getName();
    }

    public String getNameInSource(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return entity.getName();
    }

    public Object getObjectID(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XsdUtil.checkForEnterpriseConversion(entity);
        String uuidString = null;
        if (this.isEnterpriseDataType((EObject)entity)) {
            uuidString = this.getEnterpriseAttributeValue(entity, UUID_ATTRIBUTE_NAME);
        }
        if (!StringUtil.isEmpty(uuidString)) {
            try {
                return IDGenerator.getInstance().stringToObject(uuidString, "mmuuid");
            }
            catch (InvalidIDException e) {
                String msg = XsdPlugin.Util.getString("XsdSimpleTypeDefinitionAspect.error_parsing_objectid", (Object)uuidString);
                XsdPlugin.Util.log(4, (Throwable)e, msg);
            }
        }
        return super.getObjectID(eObject);
    }

    public Object getParentObjectID(EObject eObject) {
        return null;
    }

    public IPath getPath(EObject eObject) {
        return null;
    }

    public String getFullName(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return this.getURI(entity);
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'M';
    }

    public boolean isQueryable(EObject eObject) {
        return !(eObject instanceof XSDSimpleTypeDefinition) || eObject.eContainer() instanceof XSDSchema;
    }

    public int getLength(EObject eObject) {
        return 0;
    }

    public int getPrecisionLength(EObject eObject) {
        return 0;
    }

    public int getRadix(EObject eObject) {
        return 0;
    }

    public int getScale(EObject eObject) {
        return 0;
    }

    public boolean isAutoIncrement(EObject eObject) {
        return false;
    }

    public boolean isCaseSensitive(EObject eObject) {
        return false;
    }

    public boolean isSigned(EObject eObject) {
        return false;
    }

    public short getType(EObject eObject) {
        return 1;
    }

    public short getSearchType(EObject eObject) {
        return 0;
    }

    public short getNullType(EObject eObject) {
        return 0;
    }

    public String getUuidString(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XsdUtil.checkForEnterpriseConversion(entity);
        String uuid = null;
        if (this.isEnterpriseDataType((EObject)entity)) {
            uuid = this.getEnterpriseAttributeValue(entity, UUID_ATTRIBUTE_NAME);
        }
        return uuid;
    }

    public String getJavaClassName(EObject eObject) {
        Class javaClass;
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        String runtimeTypeName = this.getRuntimeTypeName((EObject)entity);
        if (runtimeTypeName != null && (javaClass = DataTypeManager.getDataTypeClass((String)runtimeTypeName)) != null) {
            return javaClass.getName();
        }
        return (class$java$lang$Object == null ? (class$java$lang$Object = XsdSimpleTypeDefinitionAspect.class$("java.lang.Object")) : class$java$lang$Object).getName();
    }

    public String getRuntimeTypeName(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        if (this.isURType(eObject)) {
            return "object";
        }
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XsdUtil.checkForEnterpriseConversion(entity);
        String runtimeType = null;
        if (this.isEnterpriseDataType((EObject)entity)) {
            runtimeType = this.getEnterpriseAttributeValue(entity, RUNTIME_TYPE_ATTRIBUTE_NAME);
        }
        if (runtimeType == null || runtimeType.length() == 0) {
            entity = (XSDSimpleTypeDefinition)this.getBasetype(eObject);
            runtimeType = entity == null ? "object" : this.getRuntimeTypeName((EObject)entity);
        }
        return runtimeType;
    }

    public Boolean getRuntimeTypeFixed(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        Boolean fixed = Boolean.FALSE;
        if (!this.isURType(eObject)) {
            EObject type = this.getMmType(eObject);
            XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
            XsdUtil.checkForEnterpriseConversion(entity);
            String runtimeTypeFixedValue = null;
            if (this.isEnterpriseDataType((EObject)entity)) {
                runtimeTypeFixedValue = this.getEnterpriseAttributeValue(entity, RUNTIME_TYPE_ATTRIBUTE_NAME);
            }
            if (runtimeTypeFixedValue == null && (entity = (XSDSimpleTypeDefinition)this.getBasetype(eObject)) != null) {
                fixed = this.getRuntimeTypeFixed((EObject)entity);
            }
        }
        return fixed;
    }

    public String getDatatypeID(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return this.getURI(entity);
    }

    public String getBasetypeID(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition basetype = (XSDSimpleTypeDefinition)this.getBasetype(eObject);
        if (basetype != null) {
            return this.getURI(basetype);
        }
        return null;
    }

    public Object getBasetype(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject;
        XSDSimpleTypeDefinition basetype = null;
        XSDVariety variety = type.getVariety();
        if (variety == XSDVariety.LIST_LITERAL) {
            basetype = type.getItemTypeDefinition();
        } else if (variety == XSDVariety.UNION_LITERAL) {
            basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
        } else {
            basetype = type.getBaseTypeDefinition();
            if (basetype != null && this.isPrimitiveType((EObject)type) && this.isPrimitiveType((EObject)basetype) && "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance".equals(type.getTargetNamespace())) {
                basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
            }
        }
        if (basetype != null && basetype.getName() == null) {
            basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
        }
        return basetype;
    }

    private boolean isPrimitiveType(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject;
        return this.isBuiltInDatatype((EObject)type) && DatatypeConstants.getPrimitivedBuiltInTypeNames().contains(type.getName());
    }

    public Object getPrimitiveType(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        EObject simpleType = eObject;
        EObject baseType = null;
        while (simpleType != null) {
            baseType = (EObject)this.getBasetype(simpleType);
            if (XSDUtil.isURType((XSDTypeDefinition)((XSDSimpleTypeDefinition)baseType))) {
                return simpleType;
            }
            if (simpleType == baseType || baseType == null) break;
            simpleType = baseType;
        }
        return null;
    }

    public String getPrimitiveTypeID(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition primitiveType = (XSDSimpleTypeDefinition)this.getPrimitiveType(eObject);
        if (primitiveType != null) {
            return this.getURI(primitiveType);
        }
        return null;
    }

    public Map getEnterpriseExtensionsMap(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XsdUtil.checkForEnterpriseConversion(entity);
        return this.getEnterpriseAttributes(entity);
    }

    public String getDescription(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        EObject type = this.getMmType(eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)type;
        XSDAnnotation annotation = entity.getAnnotation();
        if (annotation != null) {
            Iterator userInfos = annotation.getUserInformation().iterator();
            while (userInfos.hasNext()) {
                Element userInfo = (Element)userInfos.next();
                String value = XsdUtil.getChildText(userInfo);
                if (value == null) continue;
                return value;
            }
        }
        return "";
    }

    public boolean isBuiltInDatatype(EObject eObject) {
        URI eProxyURI;
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        if (XSDConstants.isURType((XSDTypeDefinition)entity)) {
            return true;
        }
        if (entity.eIsProxy() && (eProxyURI = ((InternalEObject)eObject).eProxyURI()) != null) {
            String proxyURIString = eProxyURI.toString();
            return proxyURIString.startsWith("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance") || proxyURIString.startsWith("http://www.w3.org/2001/XMLSchema") || proxyURIString.startsWith("http://www.w3.org/2000/10/XMLSchema") || proxyURIString.startsWith("http://www.w3.org/1999/XMLSchema");
        }
        String typeName = entity.getName();
        if (typeName == null || this.mmDatatypeMap.get(typeName.toLowerCase()) == null) {
            return false;
        }
        String namespaceUri = entity.getTargetNamespace();
        if ("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance".equals(namespaceUri)) {
            return true;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(namespaceUri)) {
            return true;
        }
        if ("http://www.w3.org/2000/10/XMLSchema".equals(namespaceUri)) {
            return true;
        }
        return "http://www.w3.org/1999/XMLSchema".equals(namespaceUri);
    }

    public boolean isComplexDatatype(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        return false;
    }

    public boolean isSimpleDatatype(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        return true;
    }

    public boolean isURType(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        return XSDConstants.isURType((XSDTypeDefinition)entity);
    }

    public short getVarietyType(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        XSDVariety variety = entity.getVariety();
        if (variety.getValue() == 0) {
            return 0;
        }
        if (variety.getValue() == 1) {
            return 1;
        }
        if (variety.getValue() == 2) {
            return 2;
        }
        return 0;
    }

    public List getVarietyProps(EObject eObject) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)eObject;
        XSDVariety variety = entity.getVariety();
        ArrayList<String> varietyProps = new ArrayList<String>();
        if (variety.getValue() == 0) {
            XSDSimpleTypeDefinition primitiveType = entity.getPrimitiveTypeDefinition();
            if (primitiveType != null) {
                varietyProps.add(this.getURI(primitiveType));
            }
        } else if (variety.getValue() == 1) {
            XSDSimpleTypeDefinition itemType = entity.getItemTypeDefinition();
            if (itemType != null) {
                varietyProps.add(this.getURI(itemType));
            }
        } else if (variety.getValue() == 2) {
            Iterator iter = entity.getMemberTypeDefinitions().iterator();
            while (iter.hasNext()) {
                XSDSimpleTypeDefinition memberType = (XSDSimpleTypeDefinition)iter.next();
                if (memberType == null) continue;
                varietyProps.add(this.getURI(memberType));
            }
        }
        return varietyProps;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public boolean isDatatypeFeature(EObject eObject, EStructuralFeature eFeature) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = XsdSimpleTypeDefinitionAspect.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)eObject);
        EObjectImpl eObjectImpl = super.getEObjectImpl(eObject);
        if (eObjectImpl != null) {
            switch (eObjectImpl.eDerivedStructuralFeatureID(eFeature)) {
                case 26: {
                    return true;
                }
                case 28: {
                    return true;
                }
                case 29: {
                    return true;
                }
                case 30: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isEnterpriseDataType(EObject type) {
        Map enterpriseAttributes;
        ArgCheck.isNotNull((Object)type);
        this.argCheckIsResolved(type);
        boolean success = false;
        if (type instanceof XSDSimpleTypeDefinition && !(enterpriseAttributes = this.getEnterpriseAttributes((XSDSimpleTypeDefinition)type)).isEmpty()) {
            success = enterpriseAttributes.get(UUID_ATTRIBUTE_NAME) != null && enterpriseAttributes.get(RUNTIME_TYPE_ATTRIBUTE_NAME) != null && enterpriseAttributes.get(RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME) != null;
        }
        return success;
    }

    public void setEnterpriseDataAttributes(XSDSimpleTypeDefinition type, EnterpriseDatatypeInfo edtInfo) {
        ArgCheck.isNotNull((Object)type);
        this.argCheckIsResolved((EObject)type);
        if (edtInfo.isValid()) {
            Boolean runtimeTypeFixed;
            String runtimeType;
            Attr attribute;
            XsdUtil.setAsEnterpriseSchema(type.getSchema());
            Element element = type.getElement();
            Document doc = element.getOwnerDocument();
            boolean isModified = false;
            String uuid = edtInfo.getUuid();
            if (uuid != null) {
                attribute = doc.createAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", UUID_ATTRIBUTE_NAME);
                attribute.setValue(uuid);
                attribute.setPrefix("mmedt");
                type.getElement().setAttributeNode(attribute);
                isModified = true;
            }
            if ((runtimeType = edtInfo.getRuntimeType()) != null) {
                attribute = doc.createAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", RUNTIME_TYPE_ATTRIBUTE_NAME);
                attribute.setValue(runtimeType);
                attribute.setPrefix("mmedt");
                type.getElement().setAttributeNode(attribute);
                isModified = true;
            }
            if ((runtimeTypeFixed = edtInfo.getRuntimeTypeFixed()) != null) {
                attribute = doc.createAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME);
                attribute.setValue(runtimeTypeFixed.toString());
                attribute.setPrefix("mmedt");
                type.getElement().setAttributeNode(attribute);
                isModified = true;
            }
            type.eResource().setModified(isModified);
        }
    }

    public void unSetEnterpriseDataAttributes(XSDSimpleTypeDefinition type) {
        ArgCheck.isNotNull((Object)type);
        this.argCheckIsResolved((EObject)type);
        Element element = type.getElement();
        element.removeAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", UUID_ATTRIBUTE_NAME);
        element.removeAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", RUNTIME_TYPE_ATTRIBUTE_NAME);
        element.removeAttributeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME);
        if (!this.containsEnterpriseDatatypes(type.getSchema())) {
            XsdUtil.unsetAsEnterpriseSchema(type.getSchema());
        }
        type.eResource().setModified(true);
    }

    public EnterpriseDatatypeInfo getEnterpriseDatatypeInfo(XSDSimpleTypeDefinition type) {
        ArgCheck.isNotNull((Object)type);
        this.argCheckIsResolved((EObject)type);
        XsdUtil.checkForEnterpriseConversion(type);
        EnterpriseDatatypeInfo edtInfo = new EnterpriseDatatypeInfo();
        if (XsdUtil.isEnterpriseSchema(type.getSchema()) && this.isEnterpriseDataType((EObject)type)) {
            Map attributes = this.getEnterpriseAttributes(type);
            edtInfo.setUuid((String)attributes.get(UUID_ATTRIBUTE_NAME));
            edtInfo.setRuntimeType((String)attributes.get(RUNTIME_TYPE_ATTRIBUTE_NAME));
            String runtimeTypeFixed = (String)attributes.get(RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME);
            edtInfo.setRuntimeTypeFixed(Boolean.valueOf(runtimeTypeFixed));
        }
        return edtInfo;
    }

    public void convertEnterpriseDatatype(XSDSimpleTypeDefinition type) {
        EnterpriseDatatypeInfo edtInfo;
        ArgCheck.isNotNull((Object)type);
        this.argCheckIsResolved((EObject)type);
        if (!this.isEnterpriseDataType((EObject)type) && (edtInfo = this.getEnterpriseAttributesFromAppInfo(type)).isValid()) {
            this.setEnterpriseDataAttributes(type, edtInfo);
            this.removeEnterpriseAttributesFromAppInfo(type);
            type.eNotify((Notification)new ENotificationImpl((InternalEObject)type, 3, null, null, (Object)type));
        }
    }

    public void setBasetype(XSDSimpleTypeDefinition simpleType, XSDSimpleTypeDefinition baseType) {
        ArgCheck.isNotNull((Object)simpleType);
        ArgCheck.isNotNull((Object)baseType);
        this.argCheckIsResolved((EObject)simpleType);
        this.argCheckIsResolved((EObject)baseType);
        XSDSchema schema = simpleType.getSchema();
        if (simpleType.eResource() != baseType.eResource() && !XsdConstants.isSchemaForSchemaNamespace((String)baseType.getTargetNamespace()) && !XsdUtil.containsImport(schema, baseType.getTargetNamespace())) {
            XsdUtil.addImport(simpleType, baseType);
        }
        String oldReferencedNamespace = simpleType.getBaseTypeDefinition().getTargetNamespace();
        simpleType.setBaseTypeDefinition(baseType);
        if (oldReferencedNamespace != null && !oldReferencedNamespace.equals(schema.getTargetNamespace()) && !XsdUtil.containsReferenceToNamespace(schema, oldReferencedNamespace)) {
            XsdUtil.removeNamespaceRef(schema, oldReferencedNamespace);
            if (XsdUtil.containsImport(schema, oldReferencedNamespace)) {
                XsdUtil.removeImport(schema, oldReferencedNamespace);
            }
        }
    }

    private void argCheckIsResolved(EObject e) {
        if (e.eIsProxy()) {
            throw new IllegalArgumentException(XsdPlugin.Util.getString("XsdSimpleTypeDefinitionAspect.Error_EObject_can_not_be_a_proxy", (Object)e.toString()));
        }
    }

    private void initializeMmDatatypeMap() {
        try {
            ResourceSet resourceSet;
            Resource resource = null;
            ResourceSet[] resourceSets = ModelerCore.getExternalResourceSets();
            for (int i = 0; i < resourceSets.length && (resource = (resourceSet = resourceSets[i]).getResource(BUILTIN_DATATYPES_URI, false)) == null; ++i) {
            }
            if (resource == null) {
                Object[] params = new Object[]{BUILTIN_DATATYPES_URI};
                String msg = XsdPlugin.Util.getString("XsdSimpleTypeDefinitionAspect.Error_obtain_the_built-in_datatypes_resource_from_the_container_using_URI_1", params);
                XsdPlugin.Util.log(4, msg);
            }
            if (resource != null) {
                Iterator iter = resource.getContents().iterator();
                while (iter.hasNext()) {
                    EObject eObject = (EObject)iter.next();
                    if (eObject == null || !(eObject instanceof XSDSchema)) continue;
                    Iterator iter2 = eObject.eContents().iterator();
                    while (iter2.hasNext()) {
                        eObject = (EObject)iter2.next();
                        if (eObject == null || !(eObject instanceof XSDSimpleTypeDefinition)) continue;
                        XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject;
                        String typeName = type.getName();
                        this.mmDatatypeMap.put(typeName.toLowerCase(), type);
                    }
                }
            }
        }
        catch (Throwable e) {
            Object[] params = new Object[]{BUILTIN_DATATYPES_URI};
            String msg = XsdPlugin.Util.getString("XsdSimpleTypeDefinitionAspect.Error_obtain_the_built-in_datatypes_resource_from_the_container_using_URI_1", params);
            XsdPlugin.Util.log(4, e, msg);
        }
    }

    private EObject getAnySimpleType() {
        if (this.anySimpleType == null) {
            this.anySimpleType = XSDSchemaImpl.getGlobalResourceSet().getEObject(ANY_SIMPLE_TYPE_URI, true);
        }
        return this.anySimpleType;
    }

    private EObject getMmType(EObject eObject) {
        if (this.isURType(eObject)) {
            return eObject;
        }
        if (this.isBuiltInDatatype(eObject)) {
            XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject;
            String typeName = type.getName();
            EObject mmdt = (EObject)this.mmDatatypeMap.get(typeName.toLowerCase());
            return mmdt;
        }
        return eObject;
    }

    private boolean containsEnterpriseDatatypes(XSDSchema schema) {
        boolean success = false;
        EList contents = schema.getContents();
        Iterator it = new ArrayList(contents).iterator();
        while (it.hasNext()) {
            XSDSimpleTypeDefinition sdt;
            Object o = it.next();
            if (!(o instanceof XSDSimpleTypeDefinition) || !this.isEnterpriseDataType((EObject)(sdt = (XSDSimpleTypeDefinition)o))) continue;
            success = true;
            break;
        }
        return success;
    }

    public EnterpriseDatatypeInfo getEnterpriseAttributesFromAppInfo(XSDSimpleTypeDefinition type) {
        ArgCheck.isNotNull((Object)type);
        EnterpriseDatatypeInfo edtInfo = new EnterpriseDatatypeInfo();
        XSDAnnotation annotation = type.getAnnotation();
        if (annotation != null) {
            Iterator it = annotation.getApplicationInformation().iterator();
            while (it.hasNext()) {
                Element appInfo = (Element)it.next();
                if (appInfo.getAttributes() == null || appInfo.getAttributes().getLength() <= 0) continue;
                edtInfo.setUuid(appInfo.getAttribute(UUID_ATTRIBUTE_NAME));
                edtInfo.setRuntimeType(appInfo.getAttribute(RUNTIME_TYPE_ATTRIBUTE_NAME));
                edtInfo.setRuntimeTypeFixed(Boolean.FALSE);
            }
        }
        return edtInfo;
    }

    private void removeEnterpriseAttributesFromAppInfo(XSDSimpleTypeDefinition type) {
        ArgCheck.isNotNull((Object)type);
        XSDAnnotation annotation = type.getAnnotation();
        if (annotation != null) {
            Iterator it = annotation.getApplicationInformation().iterator();
            while (it.hasNext()) {
                Element appInfo = (Element)it.next();
                if (appInfo == null || appInfo.getAttributes() == null || appInfo.getAttributes().getLength() <= 0) continue;
                appInfo.removeAttribute(UUID_ATTRIBUTE_NAME);
                appInfo.removeAttribute(RUNTIME_TYPE_ATTRIBUTE_NAME);
                if (appInfo.getAttributes().getLength() != 0) continue;
                it.remove();
            }
            if (annotation.getApplicationInformation().size() == 0) {
                annotation.getApplicationInformation().clear();
            }
        }
    }

    private Map getEnterpriseAttributes(XSDSimpleTypeDefinition type) {
        ArgCheck.isNotNull((Object)type);
        HashMap<String, String> results = new HashMap<String, String>();
        Element typeElement = type.getElement();
        if (typeElement != null) {
            if (typeElement.getAttributes() == null || typeElement.getAttributes().getLength() == 0) {
                return Collections.EMPTY_MAP;
            }
            results.put(UUID_ATTRIBUTE_NAME, this.getEnterpriseAttributeValue(type, UUID_ATTRIBUTE_NAME));
            results.put(RUNTIME_TYPE_ATTRIBUTE_NAME, this.getEnterpriseAttributeValue(type, RUNTIME_TYPE_ATTRIBUTE_NAME));
            results.put(RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME, this.getEnterpriseAttributeValue(type, RUNTIME_TYPE_FIXED_ATTRIBUTE_NAME));
        }
        return results;
    }

    private String getEnterpriseAttributeValue(XSDSimpleTypeDefinition type, String name) {
        Attr attrNS = type.getElement().getAttributeNodeNS("http://www.metamatrix.com/2005/XmlSchema/EnterpriseDatatypes", name);
        return attrNS != null ? attrNS.getValue() : null;
    }

    private String getURI(XSDSimpleTypeDefinition type) {
        String theName;
        String theTargetNamespace;
        ArgCheck.isNotNull((Object)type);
        XSDSchema xsdSchema = type.getSchema();
        String string = theTargetNamespace = xsdSchema == null ? type.getTargetNamespace() : xsdSchema.getTargetNamespace();
        if (theTargetNamespace == null) {
            theTargetNamespace = "";
        }
        if (theTargetNamespace.equals("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) {
            String typeName = type.getName();
            if (!DatatypeConstants.getMetaMatrixExtendedBuiltInTypeNames().contains(typeName)) {
                theTargetNamespace = "http://www.w3.org/2001/XMLSchema";
            }
        }
        if ((theName = type.getName()) == null) {
            theName = type.getAliasName();
        }
        return theTargetNamespace + "#" + theName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

