/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xml.aspects.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.xml.XmlDocumentPlugin;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlNamespace;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.jdom.Verifier;

public class XmlNamespaceRule
implements ObjectValidationRule {
    static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    static final String XML = "xml";
    static final String NUMBER_ERR = "Namespace prefixes cannot begin with a number";
    static final String DOLLAR_ERR = "Namespace prefixes cannot begin with a dollar sign ($)";
    static final String HYPHEN_ERR = "Namespace prefixes cannot begin with a hyphen (-)";
    static final String PERIOD_ERR = "Namespace prefixes cannot begin with a period (.)";
    static final String COLON_ERR = "Namespace prefixes cannot contain colons";
    static final String INVALID_CHAR_ERR = "Namespace prefixes cannot contain the character \"";
    static final String XML_ERR = "Namespace prefixes cannot begin with \"xml\" in any combination of case";
    static /* synthetic */ Class class$com$metamatrix$metamodels$xml$XmlNamespace;

    public void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isInstanceOf((Class)(class$com$metamatrix$metamodels$xml$XmlNamespace == null ? (class$com$metamatrix$metamodels$xml$XmlNamespace = XmlNamespaceRule.class$("com.metamatrix.metamodels.xml.XmlNamespace")) : class$com$metamatrix$metamodels$xml$XmlNamespace), (Object)eObject);
        XmlNamespace ns = (XmlNamespace)eObject;
        String uri = ns.getUri();
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        this.validatePrefix(ns, (ValidationResult)result);
        this.validateUri(uri, (ValidationResult)result);
        this.validateElement(ns, (ValidationResult)result);
        context.addResult((ValidationResult)result);
    }

    private void validateElement(XmlNamespace ns, ValidationResult result) {
        XmlElement element = ns.getElement();
        if (element == null) {
            String msg = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Namespace_Element_attribute_may_not_be_null_1");
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
            return;
        }
        String nsPrefix = ns.getPrefix();
        if (nsPrefix == null || nsPrefix.trim().length() == 0) {
            Iterator namespaces = element.getDeclaredNamespaces().iterator();
            int numDefaultNamespaceDeclarations = 0;
            while (namespaces.hasNext()) {
                XmlNamespace next = (XmlNamespace)namespaces.next();
                String prefix = next.getPrefix();
                if (prefix != null && prefix.trim().length() != 0) continue;
                ++numDefaultNamespaceDeclarations;
            }
            if (numDefaultNamespaceDeclarations > 1) {
                String msg = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Namespace_Element_may_have_only_no_more_than_one_Namespace_Declaration_with_no_Prefix_(Target_Namespace)_2");
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem((ValidationProblem)problem);
            }
        }
    }

    private void validateUri(String uri, ValidationResult result) {
        if (uri == null || uri.trim().length() == 0) {
            String msg = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Uri_may_not_be_null_or_zero_length_1");
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
        }
    }

    private void validatePrefix(XmlNamespace ns, ValidationResult result) {
        String prefix = ns.getPrefix();
        if (prefix == null) {
            return;
        }
        String errMsg = this.convertPrefixProblemString(Verifier.checkNamespacePrefix((String)prefix), ns);
        if (errMsg != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, errMsg);
            result.addProblem((ValidationProblem)problem);
        }
    }

    private String convertPrefixProblemString(String errMsg, XmlNamespace ns) {
        if (errMsg == null) {
            return null;
        }
        String msg = null;
        if (errMsg.equals(NUMBER_ERR)) {
            msg = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Namespace_prefixes_cannot_begin_with_a_number_3");
        } else if (errMsg.equals(COLON_ERR)) {
            msg = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Namespace_prefixes_cannot_contain_colons_4");
        } else if (errMsg.equals(DOLLAR_ERR)) {
            msg = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Namespace_prefixes_cannot_begin_with_a_dollar_sign_($)_5");
        } else if (errMsg.equals(HYPHEN_ERR)) {
            msg = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Namespace_prefixes_cannot_begin_with_a_hyphen_(-)_6");
        } else if (errMsg.equals(PERIOD_ERR)) {
            msg = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Namespace_prefixes_cannot_begin_with_a_period_(.)_7");
        } else if (errMsg.startsWith(INVALID_CHAR_ERR)) {
            String part1 = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Namespace_prefixes_cannot_contain_the_character___8");
            String invalidChar = errMsg.substring(49, 50);
            msg = part1 + invalidChar + "\"";
        } else if (errMsg.equals(XML_ERR)) {
            if (XML_NS.equals(ns.getUri()) && XML.equals(ns.getPrefix())) {
                return null;
            }
            msg = XmlDocumentPlugin.Util.getString("XmlNamespaceRule.Namespace_prefixes_cannot_begin_with___xml___in_any_combination_of_case_9");
        }
        return msg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

