/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.webservice.aspects.validation.rules;

import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.webservice.Input;
import com.metamatrix.metamodels.webservice.Interface;
import com.metamatrix.metamodels.webservice.Message;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.metamodels.webservice.Output;
import com.metamatrix.metamodels.webservice.WebServiceMetamodelPlugin;
import com.metamatrix.metamodels.webservice.util.WebServiceUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.validation.rules.StringNameRule;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.util.XMLChar;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;

public class WebServiceComponentNameRule
extends StringNameRule {
    static /* synthetic */ Class class$com$metamatrix$metamodels$webservice$Interface;

    public WebServiceComponentNameRule(char[] invalidChars, int featureID) {
        super(invalidChars, featureID);
    }

    public WebServiceComponentNameRule(int featureID) {
        super(featureID);
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (super.getFeatureID() != eStructuralFeature.getFeatureID()) {
            return;
        }
        super.validate(eStructuralFeature, eObject, value, context);
        Collection results = context.getTargetResults(eObject);
        if (results != null && !results.isEmpty()) {
            return;
        }
        String name = (String)value;
        InvalidCharacter invalidCharInName = null;
        if (name != null) {
            invalidCharInName = this.isValidNCName(name);
        }
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        if (invalidCharInName != null) {
            String msg = null;
            if (invalidCharInName.index == 0) {
                msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.NameHasInvalidFirstCharacter", invalidCharInName.character);
            } else if (invalidCharInName.index == 1) {
                msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.NameHasInvalidSecondCharacter", invalidCharInName.character);
            } else if (invalidCharInName.index == 2) {
                msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.NameHasInvalidThirdCharacter", invalidCharInName.character);
            } else {
                Object[] params = new Object[]{new Integer(invalidCharInName.index + 1), new Character(invalidCharInName.character)};
                msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.NameHasInvalidNthCharacter", params);
            }
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
            return;
        }
        List siblings = this.getSiblingsForUniquenessCheck(eObject, context);
        if (siblings.isEmpty()) {
            return;
        }
        this.validateUniqueness(context, siblings, eStructuralFeature.getFeatureID());
    }

    protected InvalidCharacter isValidNCName(String ncName) {
        if (ncName.length() == 0) {
            return null;
        }
        char ch = ncName.charAt(0);
        if (!XMLChar.isNCNameStart((int)ch)) {
            return new InvalidCharacter(ch, 0);
        }
        for (int i = 1; i < ncName.length(); ++i) {
            ch = ncName.charAt(i);
            if (XMLChar.isNCName((int)ch)) continue;
            return new InvalidCharacter(ch, i);
        }
        return null;
    }

    protected boolean validateUniqueness() {
        return false;
    }

    protected List getSiblingsForUniquenessCheck(EObject eObject, ValidationContext context) {
        String objType = eObject.eClass().getName();
        String ruleName = this.getRuleName() + objType;
        if (eObject instanceof Interface) {
            String containerInfo;
            Container container = context.getResourceContainer();
            boolean modelContainer = ModelerCore.isModelContainer((Container)container);
            String string = modelContainer ? eObject.eResource().getURI().toString() : (containerInfo = (class$com$metamatrix$metamodels$webservice$Interface == null ? (class$com$metamatrix$metamodels$webservice$Interface = WebServiceComponentNameRule.class$("com.metamatrix.metamodels.webservice.Interface")) : class$com$metamatrix$metamodels$webservice$Interface).getName());
            if (!context.hasRunRule(containerInfo, ruleName)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                if (modelContainer) {
                    resources.add(eObject.eResource());
                } else {
                    EList containerResources = container.getResources();
                    int size = containerResources.size();
                    for (int i = 0; i < size; ++i) {
                        Resource resource = (Resource)containerResources.get(i);
                        if (!this.isWebServiceModel(resource)) continue;
                        resources.add(resource);
                    }
                }
                context.recordRuleRun(containerInfo, ruleName);
                List results = WebServiceUtil.findInterfaces(resources, 1);
                return results;
            }
        } else if (eObject instanceof Operation) {
            if (!context.hasRunRule(eObject, ruleName)) {
                context.recordRuleRun(eObject, ruleName);
                Interface parent = ((Operation)eObject).getInterface();
                List results = WebServiceUtil.findOperations(parent, 2);
                return results;
            }
        } else if (eObject instanceof Input) {
            if (!context.hasRunRule(eObject, ruleName)) {
                context.recordRuleRun(eObject, ruleName);
                EObject parent = eObject.eContainer();
                return WebServiceUtil.findMessages(parent);
            }
        } else if (eObject instanceof Output && !context.hasRunRule(eObject, ruleName)) {
            context.recordRuleRun(eObject, ruleName);
            EObject parent = eObject.eContainer();
            return WebServiceUtil.findMessages(parent);
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isWebServiceModel(Resource theResource) {
        XMIHeader header;
        File file;
        URI uri;
        boolean result = false;
        String metamodelUri = null;
        if (theResource instanceof EmfResource) {
            ModelAnnotation annotation = ((EmfResource)theResource).getModelAnnotation();
            if (annotation != null) {
                metamodelUri = annotation.getPrimaryMetamodelUri();
            }
        } else if (theResource instanceof XSDResourceImpl) {
            return false;
        }
        if (metamodelUri == null && (uri = theResource.getURI()) != null && (file = new File(uri.toFileString())).exists() && (header = ModelUtil.getXmiHeader((File)file)) != null) {
            metamodelUri = header.getPrimaryMetamodelURI();
        }
        if (metamodelUri != null && metamodelUri != null && "http://www.metamatrix.com/metamodels/WebService".equals(metamodelUri)) {
            result = true;
        }
        return result;
    }

    public void validateUniqueness(ValidationContext context, List siblings, int nameFeatureID) {
        StringNameValidator validator = new StringNameValidator();
        Map objectCountMap = validator.getDuplicateNamesMap(siblings, nameFeatureID);
        if (objectCountMap.size() > 0) {
            Iterator keyIter = objectCountMap.keySet().iterator();
            while (keyIter.hasNext()) {
                EObject eObject = (EObject)keyIter.next();
                EStructuralFeature eFeature = eObject.eClass().getEStructuralFeature(nameFeatureID);
                String name = (String)eObject.eGet(eFeature);
                Integer count = (Integer)objectCountMap.get(eObject);
                ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
                String message = this.getUniquenessMessage(context, eObject, name, count);
                if (message == null) continue;
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, message);
                result.addProblem((ValidationProblem)problem);
                context.addResult((ValidationResult)result);
            }
        }
    }

    protected String getUniquenessMessage(ValidationContext context, EObject eObject, String name, Integer count) {
        int numModels = context.getResourcesToValidate().length;
        String msg = null;
        if (eObject instanceof Interface) {
            msg = numModels > 1 ? WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.InterfaceNameMustBeUniqueInVdb", (Object)name, (Object)count) : WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.InterfaceNameMustBeUniqueInModel", (Object)name, (Object)count);
        } else if (eObject instanceof Operation) {
            msg = numModels > 1 ? WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.OperationNameMustBeUniqueInVdb", (Object)name, (Object)count) : WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.OperationNameMustBeUniqueInModel", (Object)name, (Object)count);
        } else if (eObject instanceof Message) {
            msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.InputAndOutputNamesMustBeUnique", (Object)name, (Object)count);
        }
        return msg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class InvalidCharacter {
        public final char character;
        public final int index;

        public InvalidCharacter(char character, int index) {
            this.character = character;
            this.index = index;
        }
    }
}

