/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.webservice.aspects.validation.rules;

import com.metamatrix.metamodels.webservice.WebServiceMetamodelPlugin;
import com.metamatrix.modeler.core.validation.StructuralFeatureValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SampleFileUrlRule
implements StructuralFeatureValidationRule {
    private final int featureID;

    public SampleFileUrlRule(int featureID) {
        this.featureID = featureID;
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String urlString = (String)value;
        boolean validUrl = false;
        if (urlString != null) {
            URLConnection connection = null;
            try {
                URL url = new URL(urlString);
                connection = url.openConnection();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (connection != null) {
                validUrl = true;
            }
        }
        if (!validUrl) {
            String msg = WebServiceMetamodelPlugin.Util.getString("SampleFileUrlRule.SampleFileHasInvalidUrl");
            ValidationResultImpl validationResult = new ValidationResultImpl((Object)eObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            validationResult.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)validationResult);
        }
    }
}

