/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell.config;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.config.SourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TypeManager {
    private Map typeMap = new HashMap();
    private ConfigurationModelContainer configCtnr;

    public TypeManager(ConfigurationModelContainer container, List sourceTypes) {
        this.configCtnr = container;
        Iterator iter = sourceTypes.iterator();
        while (iter.hasNext()) {
            SourceType type = (SourceType)iter.next();
            this.typeMap.put(type.getTypeName().toLowerCase(), type);
        }
    }

    public SourceType find(String typeName) throws Exception {
        SourceType type = (SourceType)this.typeMap.get(typeName.toLowerCase());
        if (type == null) {
            throw new Exception(DQPToolsPlugin.UTIL.getString("TypeManager.Unknown_source_type", (Object)typeName));
        }
        return type;
    }

    public SourceType findByDriverType(String driverType) throws Exception {
        Iterator i = this.typeMap.values().iterator();
        while (i.hasNext()) {
            SourceType type = (SourceType)i.next();
            if (!type.getImportDriverName().equalsIgnoreCase(driverType)) continue;
            return type;
        }
        throw new Exception(DQPToolsPlugin.UTIL.getString("TypeManager.Unknown_source_type", (Object)driverType));
    }

    public String findByConnectorType(String connectortype) {
        Iterator i = this.typeMap.values().iterator();
        while (i.hasNext()) {
            SourceType type = (SourceType)i.next();
            if (!type.getConnectorTypeName().equalsIgnoreCase(connectortype)) continue;
            return type.getTypeName();
        }
        return null;
    }

    public ComponentType getConnectorType(String typeName) throws Exception {
        SourceType sourceType = this.find(typeName);
        ComponentType connectorType = this.configCtnr.getComponentType(sourceType.getConnectorTypeName());
        if (connectorType == null) {
            throw new Exception(DQPToolsPlugin.UTIL.getString("VDBContext.invalidType", (Object)sourceType.getConnectorTypeName()));
        }
        return connectorType;
    }

    public String getDriverType(String typeName) throws Exception {
        SourceType sourceType = this.find(typeName);
        return sourceType.getImportDriverName();
    }

    public String getDescription(String typeName) throws Exception {
        SourceType sourceType = this.find(typeName);
        String description = sourceType.getDescription();
        if (description != null) {
            return description;
        }
        return "";
    }

    public String getTableTypes(String typeName) throws Exception {
        SourceType sourceType = this.find(typeName);
        String tableTypes = sourceType.getTableTypes();
        if (tableTypes != null) {
            return tableTypes;
        }
        return "";
    }

    public String[] getSourceTypeNames() {
        ArrayList types = new ArrayList(this.typeMap.values());
        Collections.sort(types);
        String[] typeNames = new String[types.size()];
        Iterator iter = types.iterator();
        int i = 0;
        while (iter.hasNext()) {
            SourceType type = (SourceType)iter.next();
            typeNames[i] = type.getTypeName();
            ++i;
        }
        return typeNames;
    }

    public List getProperties(String typeName) throws Exception {
        SourceType type = this.find(typeName);
        return type.getProperties();
    }
}

