/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.ListCommand;
import com.metamatrix.dqp.tools.mmshell.MMShell;
import com.metamatrix.dqp.tools.mmshell.RefreshJdbcSourceCommand;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;

public class RefreshCommand
extends EmbeddedAdminCommandImpl {
    private static RefreshCommand shared;

    public static RefreshCommand get() {
        if (shared == null) {
            shared = new RefreshCommand();
        }
        return shared;
    }

    public boolean executeCommand(Iterator iterator) throws Exception {
        if (!this.verifyOpen()) {
            return true;
        }
        iterator.next();
        String srcName = this.getSourceName(iterator);
        if (srcName == null) {
            return true;
        }
        VDBContext context = this.getVDBContext();
        EmfResource resrc = (EmfResource)context.findResource(srcName);
        if (resrc == null) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("invalidSource", (Object)srcName));
            return true;
        }
        boolean success = false;
        if (this.isRelational(resrc)) {
            success = new RefreshJdbcSourceCommand((MMShell)this.toolShell).execute(srcName, (Resource)resrc, context);
        } else {
            this.printlnError("Not yet implemented");
        }
        if (success) {
            resrc.save(new HashMap());
            this.toolShell.printlnVerbose(DQPToolsPlugin.UTIL.getString("RefreshCommand.refreshed", (Object)srcName));
            ListCommand.get().listAllTables(srcName);
            this.toolShell.printHelp(DQPToolsPlugin.UTIL.getString("ImportCommand.nextSteps", (Object)srcName));
        }
        return true;
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("RefreshCommand.argHelp");
    }

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("RefreshCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return RefreshCommand.formatDefinition(DQPToolsPlugin.UTIL.getString("RefreshCommand.longHelp"));
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("RefreshCommand.shortHelp");
    }
}

