/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.MMShell;
import com.metamatrix.dqp.tools.mmshell.VDBCommandImpl;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public final class OpenCommand
extends VDBCommandImpl {
    private static OpenCommand shared;

    public static OpenCommand get() {
        if (shared == null) {
            shared = new OpenCommand();
        }
        return shared;
    }

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("OpenCommand.commandName");
    }

    public String getLongHelp(List arguments) {
        StringBuffer help = new StringBuffer(DQPToolsPlugin.UTIL.getString("OpenCommand.longHelp"));
        return help.toString();
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("OpenCommand.shortHelp");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("OpenCommand.argHelp");
    }

    public boolean executeCommand(Iterator iterator) throws Exception {
        iterator.next();
        String vdbName = this.getArgument(iterator, DQPToolsPlugin.UTIL.getString("OpenCommand.vdbName"));
        if (vdbName == null) {
            return true;
        }
        if (!VDBContext.isVDBNameValid(vdbName)) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("MMShell.invalid_vdb", (Object)vdbName));
            return true;
        }
        VDBContext context = this.getVDBContext();
        context.undeployVDB();
        context.close();
        File vdb = new File(vdbName);
        vdbName = vdb.getName();
        if (vdb.getParentFile() != null) {
            context.setWorkspaceDirectory(vdb.getParentFile());
        } else {
            context.setWorkspaceDirectory(new File(System.getProperty("user.dir") + File.separator + "tools/workspace"));
        }
        context.setVDBName(vdbName);
        ((MMShell)this.toolShell).addKnownVdb(context.getVDBFile());
        context.open();
        ((MMShell)context.getToolShell()).setQueryURL(context.getVDBName());
        context.deployVDB();
        return true;
    }
}

