/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.JdbcManager;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.diagram.DiagramContainer;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.relational.util.RelationalTypeMapping;
import com.metamatrix.metamodels.relational.util.RelationalTypeMappingImpl;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.jdbc.CaseConversion;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcFactory;
import com.metamatrix.modeler.jdbc.JdbcImportSettings;
import com.metamatrix.modeler.jdbc.JdbcPackage;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.SourceNames;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.impl.ImportSettingsSelectionVisitor;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcDatabaseImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeSelections;
import com.metamatrix.modeler.jdbc.relational.impl.RelationalModelProcessorImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.ecore.resource.Resource;

public final class JdbcImporter {
    private JdbcSource src;
    private Connection connection;
    private JdbcDatabaseImpl db;

    private static void addImportOption(Map options, String name) {
        options.put(name, DQPToolsPlugin.UTIL.getString("JdbcImporter.description." + name));
    }

    public static Map getImportOptions() {
        JdbcPackage pkg = JdbcPackage.eINSTANCE;
        TreeMap options = new TreeMap();
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_IncludedTableTypes().getName());
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_IncludeForeignKeys().getName());
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_IncludeIndexes().getName());
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_IncludeApproximateIndexes().getName());
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_IncludeUniqueIndexes().getName());
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_IncludeProcedures().getName());
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_CreateCatalogsInModel().getName());
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_CreateSchemasInModel().getName());
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_ConvertCaseInModel().getName());
        JdbcImporter.addImportOption(options, pkg.getJdbcImportSettings_GenerateSourceNamesInModel().getName());
        return options;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public Connection connect(JdbcSource source, String password) throws JdbcException, SQLException {
        if (this.connection != null) {
            this.close();
        }
        this.src = source;
        this.connection = JdbcManager.get().createConnection(this.src, password);
        JdbcNodeSelections selections = new JdbcNodeSelections();
        this.db = new JdbcDatabaseImpl(this.connection, null, selections);
        return this.connection;
    }

    private JdbcNode findNode(IPath path, JdbcNode node) throws JdbcException {
        IPath parentPath;
        String parentPathText;
        String pathText = path.toString().toLowerCase();
        if (pathText.equals(parentPathText = (parentPath = node.getPath()).toString().toLowerCase())) {
            return node;
        }
        if (pathText.startsWith(parentPathText)) {
            JdbcNode[] children = node.getChildren();
            int ndx = children.length;
            while (--ndx >= 0) {
                JdbcNode child = this.findNode(path, children[ndx]);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    public JdbcImportSettings getImportSettings() {
        JdbcImportSettings settings = this.src.getImportSettings();
        if (settings == null) {
            Map options;
            settings = JdbcFactory.eINSTANCE.createJdbcImportSettings();
            settings.setCreateCatalogsInModel(false);
            settings.setCreateSchemasInModel(false);
            JdbcManager mgr = JdbcManager.get();
            String procName = mgr.getProcessor(this.src.getDriverClass());
            if (procName != null && (options = mgr.getImportOptions(procName)) != null) {
                this.setImportOptions(settings, options);
            }
            this.src.setImportSettings(settings);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus importModel(String pathArgument, Resource resource) throws ClassNotFoundException, CoreException, IllegalAccessException, InstantiationException {
        block23: {
            this.verifyConnected();
            if (resource == null) {
                throw new IllegalArgumentException(DQPToolsPlugin.UTIL.getString("JdbcImporter.nullResource"));
            }
            if (!(pathArgument != null && pathArgument.trim().length() != 0 || (status = this.db.selectDefaultNodes()).isOK())) {
                return status;
            }
            settings = this.getImportSettings();
            if (pathArgument != null) {
                iter = new StringTokenizer(pathArgument, ",;:");
                while (iter.hasMoreTokens()) {
                    path = new Path(iter.nextToken()).removeTrailingSeparator().makeAbsolute();
                    node = this.findNode(path, this.db);
                    if (node == null) {
                        throw new IllegalArgumentException(DQPToolsPlugin.UTIL.getString("noSourceObject", (Object)path));
                    }
                    node.setSelected(true);
                }
            }
            list = settings.getExcludedObjectPaths();
            i = list.iterator();
            while (i.hasNext()) {
                path = new Path((String)i.next());
                node = this.findNode((IPath)path, this.db);
                if (node == null) continue;
                node.setSelected(false);
            }
            validTypes = new HashSet<String>();
            dfltTypes = new HashSet<String>();
            result = null;
            try {
                try {
                    result = this.db.getDatabaseMetaData().getTableTypes();
                    while (result.next()) {
                        type = result.getString(1);
                        validTypes.add(type);
                        upperType = type.toUpperCase();
                        if (upperType.startsWith("SYSTEM") || upperType.endsWith("INDEX")) continue;
                        dfltTypes.add(type);
                    }
                    var11_11 = null;
                    if (result == null) break block23;
                }
                catch (SQLException err) {
                    validTypes = null;
                    var11_11 = null;
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException err) {}
                    }
                    break block23;
                }
            }
            catch (Throwable var10_16) {
                var11_12 = null;
                if (result == null) throw var10_16;
                ** try [egrp 2[TRYBLOCK] [4 : 369->379)] { 
lbl57:
                // 1 sources

                result.close();
                throw var10_16;
lbl59:
                // 1 sources

                catch (SQLException err) {
                    // empty catch block
                }
                throw var10_16;
            }
            try {}
            catch (SQLException err) {}
            result.close();
        }
        types = settings.getIncludedTableTypes();
        if (validTypes != null) {
            typesIter = types.listIterator();
            while (typesIter.hasNext()) {
                type = typesIter.next().toString();
                valid = false;
                validTypesIter = validTypes.iterator();
                while (validTypesIter.hasNext()) {
                    validType = validTypesIter.next().toString();
                    if (!validType.equalsIgnoreCase(type)) continue;
                    typesIter.set(validType);
                    valid = true;
                    break;
                }
                if (valid) continue;
                msg = DQPToolsPlugin.UTIL.getString("JdbcImporter.invalidTableType", (Object)JdbcPackage.eINSTANCE.getJdbcImportSettings_IncludedTableTypes().getName(), (Object)type, validTypes);
                throw new IllegalArgumentException(msg);
            }
        }
        includes = this.db.getIncludes();
        includes.setApproximateIndexes(settings.isIncludeApproximateIndexes());
        includes.setIncludeForeignKeys(settings.isIncludeForeignKeys());
        includes.setIncludeIndexes(settings.isIncludeIndexes());
        includes.setIncludeProcedures(settings.isIncludeProcedures());
        includes.setUniqueIndexesOnly(settings.isIncludeUniqueIndexes());
        if (types.isEmpty()) {
            settings.getIncludedTableTypes().addAll(dfltTypes);
            includes.setIncludedTableTypes(dfltTypes.toArray(new String[dfltTypes.size()]));
        } else {
            includes.setIncludedTableTypes(types.toArray(new String[types.size()]));
        }
        this.db.accept(new ImportSettingsSelectionVisitor(settings), 2);
        procName = JdbcManager.get().getProcessor(this.src.getDriverClass());
        processor = procName == null ? new RelationalModelProcessorImpl() : (RelationalModelProcessorImpl)Class.forName(procName).newInstance();
        ctnr = (Container)resource.getResourceSet();
        typeMgr = ctnr.getDatatypeManager();
        processor.setTypeMapping((RelationalTypeMapping)new RelationalTypeMappingImpl(typeMgr));
        processor.setDatatypeManager(typeMgr);
        processor.setMoveRatherThanCopyAdds(true);
        iter = resource.getContents().iterator();
        while (iter.hasNext() != false) {
            obj = iter.next();
            if (obj instanceof ModelAnnotation) {
                ((ModelAnnotation)obj).getModelImports().clear();
                continue;
            }
            if (!(obj instanceof RelationalEntity) && !(obj instanceof AnnotationContainer) && !(obj instanceof DiagramContainer)) continue;
            iter.remove();
        }
        return processor.execute(resource, ctnr, this.db, settings, null);
    }

    private void setImportListOption(List list, Object value) {
        list.clear();
        StringTokenizer iter = new StringTokenizer(value.toString(), ",");
        while (iter.hasMoreTokens()) {
            list.add(iter.nextToken());
        }
    }

    public void setImportOptions(JdbcImportSettings settings, Map options) {
        if (options == null) {
            throw new IllegalArgumentException("Options must not be null.");
        }
        JdbcPackage pkg = JdbcPackage.eINSTANCE;
        Iterator optionIter = options.entrySet().iterator();
        while (optionIter.hasNext()) {
            AbstractEnumerator conv;
            Map.Entry entry = optionIter.next();
            String option = entry.getKey().toString().toLowerCase();
            Object val = entry.getValue();
            if (option.equals(pkg.getJdbcImportSettings_ConvertCaseInModel().getName().toLowerCase())) {
                conv = CaseConversion.get(val.toString());
                this.verifyValue(conv, val, option, CaseConversion.VALUES);
                settings.setConvertCaseInModel((CaseConversion)conv);
                continue;
            }
            if (option.equals(pkg.getJdbcImportSettings_CreateCatalogsInModel().getName().toLowerCase())) {
                settings.setCreateCatalogsInModel(Boolean.valueOf(val.toString()));
                continue;
            }
            if (option.equals(pkg.getJdbcImportSettings_CreateSchemasInModel().getName().toLowerCase())) {
                settings.setCreateSchemasInModel(Boolean.valueOf(val.toString()));
                continue;
            }
            if (option.equals(pkg.getJdbcImportSettings_ExcludedObjectPaths().getName().toLowerCase())) {
                this.setImportListOption((List)settings.getExcludedObjectPaths(), val);
                continue;
            }
            if (option.equals(pkg.getJdbcImportSettings_GenerateSourceNamesInModel().getName().toLowerCase())) {
                conv = SourceNames.get(val.toString());
                this.verifyValue(conv, val, option, SourceNames.VALUES);
                settings.setGenerateSourceNamesInModel((SourceNames)conv);
                continue;
            }
            if (option.equals(pkg.getJdbcImportSettings_IncludeApproximateIndexes().getName().toLowerCase())) {
                settings.setIncludeApproximateIndexes(Boolean.valueOf(val.toString()));
                continue;
            }
            if (option.equals(pkg.getJdbcImportSettings_IncludedTableTypes().getName().toLowerCase())) {
                this.setImportListOption((List)settings.getIncludedTableTypes(), val);
                continue;
            }
            if (option.equals(pkg.getJdbcImportSettings_IncludeForeignKeys().getName().toLowerCase())) {
                settings.setIncludeForeignKeys(Boolean.valueOf(val.toString()));
                continue;
            }
            if (option.equals(pkg.getJdbcImportSettings_IncludeIndexes().getName().toLowerCase())) {
                settings.setIncludeIndexes(Boolean.valueOf(val.toString()));
                continue;
            }
            if (option.equals(pkg.getJdbcImportSettings_IncludeProcedures().getName().toLowerCase())) {
                settings.setIncludeProcedures(Boolean.valueOf(val.toString()));
                continue;
            }
            if (!option.equals(pkg.getJdbcImportSettings_IncludeUniqueIndexes().getName().toLowerCase())) continue;
            settings.setIncludeUniqueIndexes(Boolean.valueOf(val.toString()));
        }
    }

    private void verifyConnected() {
        if (this.db == null) {
            throw new IllegalStateException("The importer must first be connected to a JDBC source.");
        }
    }

    private void verifyValue(Object convertedValue, Object originalValue, Object option, Collection validValues) {
        if (convertedValue == null) {
            throw new IllegalArgumentException("The value for the \"" + option + "\" option is \"" + originalValue + "\".  It must be one of the following: " + validValues);
        }
    }
}

