/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.admin.api.core.Admin;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.jdbc.api.Connection;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class EmbeddedAdminContext
extends DatabaseConnectionContext {
    private static final String ADMIN_VDB = "Admin";
    private Admin admin = null;

    public synchronized Admin getAdmin() throws Exception, ClassNotFoundException {
        if (this.admin == null) {
            try {
                this.admin = ((Connection)this.getConnection()).getAdminAPI();
            }
            catch (SQLException e) {
                Exception e1 = new Exception(DQPToolsPlugin.UTIL.getString("EmbeddedAdminContext.error_admin_vdb"), e);
                throw e1;
            }
        }
        return this.admin;
    }

    public List getDeployedVDBs() throws Exception {
        TreeSet<String> vdbNames = new TreeSet<String>();
        Collection vdbs = this.getAdmin().getVDBs("*");
        Iterator vdbIter = vdbs.iterator();
        while (vdbIter.hasNext()) {
            VDB vdb = (VDB)vdbIter.next();
            String vdbName = vdb.getName();
            if (vdbName.equalsIgnoreCase(ADMIN_VDB)) continue;
            vdbNames.add(vdb.getName());
        }
        ArrayList<String> nameList = new ArrayList<String>(vdbNames.size());
        Iterator nameIter = vdbNames.iterator();
        while (nameIter.hasNext()) {
            String name = (String)nameIter.next();
            nameList.add(name);
        }
        return nameList;
    }

    public String getDeployedVDBsString() throws Exception {
        List vdbs = this.getDeployedVDBs();
        StringBuffer str = new StringBuffer();
        if (vdbs.size() > 0) {
            str.append(DQPToolsPlugin.UTIL.getString("VDBContext.known_vdbs") + "\n");
            for (int i = 0; i < vdbs.size(); ++i) {
                String name = (String)vdbs.get(i);
                String knownVDB = name.substring(0, name.length());
                str.append("\n  " + knownVDB);
            }
        }
        return str.toString();
    }

    public void closeConnection() {
        super.closeConnection();
        this.admin = null;
    }
}

