/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.BrowseJdbcSourceCommand;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.ListCommand;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.ecore.resource.Resource;

public class BrowseCommand
extends EmbeddedAdminCommandImpl {
    static final char PATH_SEPARATOR = '/';
    private static BrowseCommand shared;

    public static BrowseCommand get() {
        if (shared == null) {
            shared = new BrowseCommand();
        }
        return shared;
    }

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("BrowseCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return DQPToolsPlugin.UTIL.getString("BrowseCommand.longHelp");
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("BrowseCommand.shortHelp");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("BrowseCommand.argHelp");
    }

    public boolean executeCommand(Iterator iterator) {
        if (!this.verifyOpen()) {
            return true;
        }
        iterator.next();
        if (!iterator.hasNext()) {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(ListCommand.get().getCommandName());
            ListCommand.get().executeCommand(cmds.iterator());
            return true;
        }
        String srcName = this.getSourceName(iterator);
        if (srcName.equalsIgnoreCase("System")) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("BrowseCommand.systemNotBrowsable"));
            return true;
        }
        Properties properties = BrowseCommand.getPropertiesFromArguments(iterator);
        VDBContext context = this.getVDBContext();
        EmfResource resrc = (EmfResource)context.findResource(srcName);
        if (resrc != null && this.isRelational(resrc)) {
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("BrowseCommand.header"));
            BrowseJdbcSourceCommand.execute(srcName, (Resource)resrc, properties, this.toolShell, context);
        } else {
            this.printlnError(DQPToolsPlugin.UTIL.getString("BrowseCommand.unknownSource", (Object)srcName));
        }
        this.printHelp(DQPToolsPlugin.UTIL.getString("BrowseCommand.next_steps", (Object)srcName));
        return true;
    }
}

