/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.xslt;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.xslt.CoreXsltPlugin;
import com.metamatrix.core.xslt.Style;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;

public class StyleFromResource
implements Style {
    private final ClassLoader classLoader;
    private final String name;
    private final String description;
    private final String xsltUrl;

    public StyleFromResource(ClassLoader classLoader, String name, String xsltUri) {
        this(classLoader, name, xsltUri, null);
    }

    public StyleFromResource(ClassLoader classLoader, String name, String xsltUri, String desc) {
        ArgCheck.isNotNull((Object)name);
        ArgCheck.isNotZeroLength((String)name);
        ArgCheck.isNotNull((Object)xsltUri);
        ArgCheck.isNotZeroLength((String)xsltUri);
        ArgCheck.isNotNull((Object)classLoader);
        this.classLoader = classLoader;
        this.name = name;
        this.xsltUrl = xsltUri;
        this.description = desc != null ? desc : "";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getXsltUrl() {
        return this.xsltUrl;
    }

    public InputStream getInputStream() throws IOException, MetaMatrixCoreException {
        String xsltURL = this.getXsltUrl();
        InputStream stylesheetStream = this.getClassLoader().getResourceAsStream(xsltURL);
        if (stylesheetStream == null) {
            stylesheetStream = new FileInputStream(xsltURL);
        }
        if (stylesheetStream == null) {
            Object[] params = new Object[]{xsltURL};
            String msg = CoreXsltPlugin.Util.getString("StyleFromResource.Unable_to_load_XSLT_stylesheet_from_URI", params);
            throw new MetaMatrixCoreException(msg);
        }
        if (stylesheetStream.available() == 0) {
            Object[] params = new Object[]{xsltURL};
            String msg = CoreXsltPlugin.Util.getString("StyleFromResource.empty_xslt", params);
            throw new MetaMatrixCoreException(msg);
        }
        return stylesheetStream;
    }

    public StreamSource getStreamSource() throws IOException, MetaMatrixCoreException {
        InputStream stream = this.getInputStream();
        return new StreamSource(stream);
    }
}

