/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.text;

import com.metamatrix.connector.text.TextPlugin;
import com.metamatrix.data.api.ConnectorLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class StringToDateTranslator {
    private List simpleDateFormats;
    private List dateFormatStrings;
    private boolean hasFormatters = false;
    private ConnectorLogger logger;

    public StringToDateTranslator(Properties props, ConnectorLogger logger) {
        if (props == null) {
            return;
        }
        this.logger = logger;
        String dateFormats = props.getProperty("DateResultFormats");
        String dateFormatsDelimiter = props.getProperty("DateResultFormatsDelimiter");
        if (dateFormatsDelimiter != null && dateFormatsDelimiter.trim().length() != 0) {
            if (dateFormats != null && dateFormats.trim().length() != 0) {
                this.createSimpleDateFormats(dateFormats, dateFormatsDelimiter);
            }
        } else if (dateFormats != null && dateFormats.trim().length() != 0) {
            this.createSimpleDateFormat(dateFormats);
        }
        if (this.simpleDateFormats != null && this.simpleDateFormats.size() > 0) {
            this.hasFormatters = true;
        }
    }

    public Date translateStringToDate(String string) throws ParseException {
        ArrayList<ParseException> parseExceptionList = new ArrayList<ParseException>();
        Iterator iterator = this.simpleDateFormats.iterator();
        while (iterator.hasNext()) {
            SimpleDateFormat formatter = (SimpleDateFormat)iterator.next();
            try {
                Date date = formatter.parse(string);
                return date;
            }
            catch (ParseException e) {
                parseExceptionList.add(e);
            }
        }
        if (this.dateFormatStrings.size() == parseExceptionList.size()) {
            StringBuffer message = new StringBuffer();
            int counter = 0;
            Object[] params = new Object[]{string};
            message.append(TextPlugin.Util.getString("StringToDateTranslator.Attempts_to_parse_String__{0}_to_a_java.util.Date_failed_for_the_following_reasons___1", params));
            if (!this.hasFormatters()) {
                message.append(TextPlugin.Util.getString("StringToDateTranslator.There_is_no_format_Strings_found_in_this_formatter_object._n_2", params));
            }
            Iterator exceptionsIterator = parseExceptionList.iterator();
            Iterator formatStringsIterator = this.dateFormatStrings.iterator();
            while (exceptionsIterator.hasNext()) {
                String format = (String)formatStringsIterator.next();
                String exceptionMessage = ((ParseException)exceptionsIterator.next()).getMessage();
                Object[] params2 = new Object[]{"" + counter, format, exceptionMessage};
                message.append(TextPlugin.Util.getString("StringToDateTranslator.Parse_Attempt__{0}_using_format__{1}_failed_for_the_following_reason__{2}_4", params2));
                ++counter;
            }
            throw new ParseException(message.toString(), 0);
        }
        Object[] params3 = new Object[]{string, this.dateFormatStrings};
        throw new ParseException(TextPlugin.Util.getString("StringToDateTranslator.Failed_to_convert_String__{0}_to_a_Date_using_one_of_the_following_format_Strings_that_are_specified_in_the_properties_for_this_Connector__{1}_1", (Object)params3), 0);
    }

    public boolean hasFormatters() {
        return this.hasFormatters;
    }

    private void createSimpleDateFormats(String dateFormats, String dateFormatsDelimiter) {
        this.simpleDateFormats = new ArrayList();
        this.dateFormatStrings = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(dateFormats, dateFormatsDelimiter);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            this.logger.logTrace("Creating simple Date format for formatting String: " + token);
            this.dateFormatStrings.add(token);
            SimpleDateFormat formatter = new SimpleDateFormat(token.trim());
            this.simpleDateFormats.add(formatter);
        }
    }

    private void createSimpleDateFormat(String dateFormats) {
        this.simpleDateFormats = new ArrayList();
        this.dateFormatStrings = new ArrayList();
        this.logger.logTrace("Creating simple Date format for formatting String: " + dateFormats);
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormats);
        this.dateFormatStrings.add(dateFormats);
        this.simpleDateFormats.add(formatter);
    }
}

