/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.protocol.mmfile;

import com.metamatrix.common.protocol.MMURLConnection;
import com.metamatrix.common.protocol.URLHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.StringTokenizer;

public class MMFileURLConnection
extends MMURLConnection {
    public static String PROTOCOL = "mmfile";
    File file;
    File deleted;
    public static String DELETED = ".deleted";
    boolean readOnly = false;

    public MMFileURLConnection(URL u) throws MalformedURLException, IOException {
        this(u, false);
    }

    public MMFileURLConnection(URL u, boolean readOnly) throws MalformedURLException, IOException {
        super(u);
        String path = this.url.getPath();
        this.file = new File(path.replace('/', File.separatorChar).replace('|', ':'));
        this.deleted = new File(this.file.getAbsolutePath() + DELETED);
        this.doOutput = false;
        this.readOnly = readOnly;
    }

    public File getFile() {
        return this.file;
    }

    public void connect() throws IOException {
        this.connected = true;
        if (this.action.equals("read") || this.action.equals("list")) {
            if (!this.file.exists()) {
                throw new FileNotFoundException(this.file.getPath());
            }
            if (this.deleted.exists()) {
                throw new FileNotFoundException(this.file.getPath());
            }
            this.doOutput = false;
            this.doInput = true;
        } else if (this.action.equals("write")) {
            if (!this.readOnly && (!this.file.exists() || this.file.exists() && this.deleted.exists())) {
                this.deleted.delete();
                File parent = this.file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
            }
            this.doOutput = true;
            this.doInput = false;
        } else if (this.action.equals("delete") && !this.readOnly && this.file.exists()) {
            this.file.delete();
            if (this.file.exists()) {
                try {
                    FileWriter fw = new FileWriter(this.deleted);
                    fw.write("failed to delete file:\"" + this.url + "\"; this is marker to note this file has been deleted");
                    fw.close();
                }
                catch (IOException e) {
                    throw new IOException("failed to delete file:" + this.url);
                }
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.action.equals("list")) {
            FileFilter fileFilter = new FileFilter(){
                String filter;
                {
                    this.filter = MMFileURLConnection.this.props.getProperty("filter");
                }

                public boolean accept(File pathname) {
                    StringTokenizer st = new StringTokenizer(this.filter, ",");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().trim().toLowerCase();
                        if (!pathname.getPath().toLowerCase().endsWith(token)) continue;
                        return true;
                    }
                    return false;
                }
            };
            File[] matchedFiles = this.file.listFiles(fileFilter);
            String[] urls = new String[matchedFiles.length];
            for (int i = 0; i < matchedFiles.length; ++i) {
                urls[i] = URLHelper.buildURL(this.url, matchedFiles[i].getName()).toString();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(urls);
            oos.close();
            return new ByteArrayInputStream(out.toByteArray());
        }
        if (!this.deleted.exists() && this.file.exists()) {
            return new FileInputStream(this.file);
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.action.equals("write")) {
            if (this.readOnly) {
                return new NullOutputStream();
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                FilePermission p = new FilePermission(this.file.getPath(), "write");
                sm.checkPermission(p);
            }
            return new FileOutputStream(this.file);
        }
        throw new IOException("Writing to the file \"" + this.url + "\" is not allowed");
    }

    public String getHeaderField(String name) {
        String headerField = null;
        if (name.equalsIgnoreCase("last-modified")) {
            headerField = String.valueOf(this.getLastModified());
        } else if (name.equalsIgnoreCase("content-length")) {
            headerField = String.valueOf(this.file.length());
        } else if (name.equalsIgnoreCase("content-type")) {
            headerField = MMFileURLConnection.getFileNameMap().getContentTypeFor(this.file.getName());
            if (headerField == null) {
                try {
                    InputStream is = this.getInputStream();
                    BufferedInputStream bis = new BufferedInputStream(is);
                    headerField = URLConnection.guessContentTypeFromStream(bis);
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            headerField = name.equalsIgnoreCase("date") ? String.valueOf(this.file.lastModified()) : super.getHeaderField(name);
        }
        return headerField;
    }

    public Permission getPermission() throws IOException {
        return new FilePermission(this.file.getPath(), "read");
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    static class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }
}

