/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.protocol;

import com.metamatrix.common.protocol.classpath.ClasspathURLConnection;
import com.metamatrix.common.protocol.classpath.Handler;
import com.metamatrix.common.protocol.mmfile.MMFileURLConnection;
import com.metamatrix.core.io.FileUrl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URLHelper {
    private static final String SEPARATOR = ":";

    public static URL buildURL(String url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException();
        }
        if ((url = URLHelper.convertBackSlashes(url)).startsWith(ClasspathURLConnection.PROTOCOL + SEPARATOR)) {
            String filename = url.substring((ClasspathURLConnection.PROTOCOL + SEPARATOR).length());
            return new URL(ClasspathURLConnection.PROTOCOL, "", -1, filename, new Handler());
        }
        if (url.startsWith(MMFileURLConnection.PROTOCOL + SEPARATOR)) {
            String filename = url.substring((MMFileURLConnection.PROTOCOL + SEPARATOR).length());
            return new URL(MMFileURLConnection.PROTOCOL, "", -1, filename, new com.metamatrix.common.protocol.mmfile.Handler());
        }
        if (URLHelper.isFile(url)) {
            String filename = URLHelper.extractFileName(url);
            return new URL(MMFileURLConnection.PROTOCOL, "", -1, filename, new com.metamatrix.common.protocol.mmfile.Handler());
        }
        return new URL(url);
    }

    public static URL buildURL(URL context, String url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException();
        }
        if (context == null) {
            return URLHelper.buildURL(url);
        }
        if ((url = URLHelper.convertBackSlashes(url)).startsWith(ClasspathURLConnection.PROTOCOL + SEPARATOR)) {
            String filename = url.substring((ClasspathURLConnection.PROTOCOL + SEPARATOR).length());
            return new URL(ClasspathURLConnection.PROTOCOL, "", -1, filename, new Handler());
        }
        if (url.startsWith(MMFileURLConnection.PROTOCOL + SEPARATOR)) {
            String filename = url.substring((MMFileURLConnection.PROTOCOL + SEPARATOR).length());
            return new URL(MMFileURLConnection.PROTOCOL, "", -1, filename, new com.metamatrix.common.protocol.mmfile.Handler());
        }
        if (URLHelper.isFile(url)) {
            String filename = URLHelper.extractFileName(url);
            String contextURL = context.toString();
            if (contextURL.startsWith(ClasspathURLConnection.PROTOCOL + SEPARATOR)) {
                return new URL(context, filename, new Handler());
            }
            if (contextURL.startsWith(MMFileURLConnection.PROTOCOL + SEPARATOR)) {
                return new URL(context, filename, new com.metamatrix.common.protocol.mmfile.Handler());
            }
        }
        return new URL(context, url);
    }

    public static URL buildURL(URL url) {
        try {
            return URLHelper.buildURL(url.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resolveUrl(URL url) throws MalformedURLException, IOException {
        boolean resolved = true;
        if (url == null) {
            return resolved;
        }
        URLConnection urlConn = null;
        InputStreamReader inStream = null;
        BufferedReader buff = null;
        try {
            String nextLine;
            urlConn = url.openConnection();
            inStream = new InputStreamReader(urlConn.getInputStream());
            buff = new BufferedReader(inStream);
            while ((nextLine = buff.readLine()) != null) {
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createFileFromUrl(URL url, String fileNamePrefix, String fileNameSuffix) throws MalformedURLException, IOException {
        BufferedWriter bw;
        File file;
        block6: {
            URLConnection urlConn = null;
            InputStreamReader inStream = null;
            BufferedReader buff = null;
            file = null;
            FileWriter fw = null;
            bw = null;
            try {
                String nextLine;
                file = FileUrl.createTempFile((String)fileNamePrefix, (String)fileNameSuffix);
                file.deleteOnExit();
                ((FileUrl)file).setOriginalUrlString(url.toString());
                fw = new FileWriter(file);
                bw = new BufferedWriter(fw);
                urlConn = url.openConnection();
                inStream = new InputStreamReader(urlConn.getInputStream());
                buff = new BufferedReader(inStream);
                while ((nextLine = buff.readLine()) != null) {
                    bw.write(nextLine);
                }
                Object var11_10 = null;
                if (inStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (inStream != null) {
                    inStream.close();
                }
                if (bw != null) {
                    bw.close();
                }
                throw throwable;
            }
            inStream.close();
        }
        if (bw != null) {
            bw.close();
        }
        return file;
    }

    static boolean isFile(String file) {
        return URLHelper.extractFileName(file) != null;
    }

    static String extractFileName(String file) {
        if (file.matches("^(\\w){2,}:.*")) {
            return null;
        }
        if (file.matches("^\\/.*")) {
            return file;
        }
        if (file.matches("^\\w:[\\\\,\\/].*")) {
            file = file.replaceAll("\\\\", "\\/");
            return "/" + file;
        }
        if (file.matches("^(\\.)+\\/.*|^\\w+\\/.*|^\\w+.*")) {
            return file;
        }
        return null;
    }

    static String convertBackSlashes(String str) {
        return str.replaceAll("\\\\", "/");
    }

    static {
        String propKey = "java.protocol.handler.pkgs";
        String directory = "com.metamatrix.common.protocol";
        String value = System.getProperty(propKey);
        if (value == null || value.trim().length() == 0) {
            System.setProperty(propKey, directory);
        } else if (value.indexOf(directory) < 0) {
            value = value + "|" + directory;
            System.setProperty(propKey, value);
        }
    }
}

