/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;

public class NonDelegatingClassLoader
extends URLClassLoader {
    public NonDelegatingClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public NonDelegatingClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public NonDelegatingClassLoader(URL[] urls) {
        super(urls);
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        try {
            loadedClass = super.findClass(name);
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (loadedClass == null) {
            loadedClass = this.getParent().loadClass(name);
        }
        return loadedClass;
    }

    public URL getResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }
}

